/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option.marker;

import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.option.marker.GameMarker;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.EnumSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public interface FlagCaptureMarker
extends GameMarker {
    public static final double DEFAULT_CAPTURE_RADIUS = 4.0;

    public boolean shouldCountAsCapture(PlayerFlagLocation var1);

    public static FlagCaptureMarker aroundLocation(@Nonnull Location loc, Team ... forTeams) {
        return FlagCaptureMarker.aroundLocation(loc, 4.0, forTeams);
    }

    public static FlagCaptureMarker aroundLocation(@Nonnull Location loc, @Nonnull Iterable<Team> forTeams) {
        return FlagCaptureMarker.aroundLocation(loc, 4.0, forTeams);
    }

    public static FlagCaptureMarker aroundLocation(@Nonnull Location loc, @Nonnull EnumSet<Team> forTeams) {
        return FlagCaptureMarker.aroundLocation(loc, 4.0, forTeams);
    }

    public static FlagCaptureMarker aroundLocation(@Nonnull Location loc, @Nonnegative double radius, Team ... forTeams) {
        EnumSet<Team> asSet = EnumSet.noneOf(Team.class);
        for (Team team : forTeams) {
            asSet.add(team);
        }
        return FlagCaptureMarker.aroundLocation(loc, radius, asSet);
    }

    public static FlagCaptureMarker aroundLocation(@Nonnull Location loc, @Nonnegative double radius, @Nonnull Iterable<Team> forTeams) {
        if (forTeams instanceof EnumSet) {
            return FlagCaptureMarker.aroundLocation(loc, radius, (EnumSet)forTeams);
        }
        EnumSet<Team> asSet = EnumSet.noneOf(Team.class);
        for (Team team : forTeams) {
            asSet.add(team);
        }
        return FlagCaptureMarker.aroundLocation(loc, radius, asSet);
    }

    public static FlagCaptureMarker aroundLocation(@Nonnull Location loc, @Nonnegative double radius, @Nonnull EnumSet<Team> forTeams) {
        return flag -> forTeams.contains((Object)flag.getPlayer().getTeam()) && Utils.isInCircleRadiusFast(loc, flag.getLocation(), radius);
    }

    public static FlagCaptureMarker zonedCapture(@Nonnull Location a, @Nonnull Location b, Team ... forTeams) {
        EnumSet<Team> asSet = EnumSet.noneOf(Team.class);
        for (Team team : forTeams) {
            asSet.add(team);
        }
        return FlagCaptureMarker.zonedCapture(a, b, asSet);
    }

    public static FlagCaptureMarker zonedCapture(@Nonnull Location a, @Nonnull Location b, @Nonnull Iterable<Team> forTeams) {
        if (forTeams instanceof EnumSet) {
            return FlagCaptureMarker.zonedCapture(a, b, (EnumSet)forTeams);
        }
        EnumSet<Team> asSet = EnumSet.noneOf(Team.class);
        for (Team team : forTeams) {
            asSet.add(team);
        }
        return FlagCaptureMarker.zonedCapture(a, b, asSet);
    }

    public static FlagCaptureMarker zonedCapture(@Nonnull Location a, @Nonnull Location b, @Nonnull EnumSet<Team> forTeams) {
        double xMin = Math.min(a.getX(), b.getX());
        double xMax = Math.max(a.getX(), b.getX());
        double yMin = Math.min(a.getY(), b.getY());
        double yMax = Math.max(a.getY(), b.getY());
        double zMin = Math.min(a.getZ(), b.getZ());
        double zMax = Math.max(a.getZ(), b.getZ());
        return flag -> {
            Location loc = flag.getLocation();
            double x = loc.getX();
            double y = loc.getY();
            double z = loc.getZ();
            return forTeams.contains((Object)flag.getPlayer().getTeam()) && loc.getWorld() == a.getWorld() && x >= xMin && x <= xMax && y >= yMin && y <= yMax && z >= zMin && z <= zMax;
        };
    }
}

