/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option.marker;

import com.ebicep.warlords.game.option.marker.LocationMarker;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public interface DebugLocationMarker
extends LocationMarker {
    @Nonnull
    public String getName();

    @Nonnull
    public List<String> getExtra();

    @Nonnull
    public Class<?> getCreator();

    @Override
    @Nonnull
    public Location getLocation();

    @Nonnull
    public Material getMaterial();

    public short getMaterialData();

    @Nonnull
    default public ItemStack getAsItem() {
        int index;
        ItemBuilder item = new ItemBuilder(this.getMaterial(), 1, this.getMaterialData());
        String name = this.getName();
        String newName = name.indexOf(167) >= 0 ? name : ((index = name.indexOf(": ")) > 0 ? ChatColor.GOLD + name.substring(0, index + 1) + ChatColor.WHITE + name.substring(index + 1) : ChatColor.GOLD + name);
        item.name(newName);
        Location loc = this.getLocation();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + "XYZ: " + ChatColor.WHITE + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + " Yaw/pitch: " + loc.getYaw() + "/" + loc.getPitch());
        lore.add(ChatColor.GRAY + "Source: " + ChatColor.WHITE + this.getCreator().getName());
        for (String extra : this.getExtra()) {
            int index2;
            String newString = extra.indexOf(167) >= 0 ? extra : ((index2 = extra.indexOf(": ")) > 0 ? ChatColor.GRAY + extra.substring(0, index2 + 1) + ChatColor.WHITE + extra.substring(index2 + 1) : ChatColor.WHITE + extra);
            lore.add(newString);
        }
        item.lore(lore);
        return item.get();
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Class<?> creator, String name, Location location) {
        return DebugLocationMarker.create(material, data, () -> creator, () -> name, () -> location, Collections::emptyList);
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Class<?> creator, String name, Location location, Supplier<List<String>> extra) {
        return DebugLocationMarker.create(material, data, () -> creator, () -> name, () -> location, extra);
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Class<?> creator, String name, Supplier<Location> location, Supplier<List<String>> extra) {
        return DebugLocationMarker.create(material, data, () -> creator, () -> name, location, extra);
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Class<?> creator, Supplier<String> name, Supplier<Location> location) {
        return DebugLocationMarker.create(material, data, () -> creator, name, location, Collections::emptyList);
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Class<?> creator, Supplier<String> name, Supplier<Location> location, Supplier<List<String>> extra) {
        return DebugLocationMarker.create(material, data, () -> creator, name, location, extra);
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Supplier<Class<?>> creator, Supplier<String> name, Supplier<Location> location) {
        return DebugLocationMarker.create(material, data, creator, name, location, Collections::emptyList);
    }

    public static DebugLocationMarker create(@Nullable Material material, int data, Supplier<Class<?>> creator, Supplier<String> name, Supplier<Location> location, Supplier<List<String>> extra) {
        Material newMaterial = material == null ? Material.BARRIER : material;
        return DebugLocationMarker.create(() -> newMaterial, () -> data, creator, name, location, extra);
    }

    public static DebugLocationMarker create(final Supplier<Material> material, final IntSupplier data, final Supplier<Class<?>> creator, final Supplier<String> name, final Supplier<Location> location, final Supplier<List<String>> extra) {
        return new DebugLocationMarker(){

            @Override
            public String getName() {
                return (String)name.get();
            }

            @Override
            public Class<?> getCreator() {
                return (Class)creator.get();
            }

            @Override
            public Location getLocation() {
                return (Location)location.get();
            }

            @Override
            public List<String> getExtra() {
                return (List)extra.get();
            }

            @Override
            public Material getMaterial() {
                return (Material)material.get();
            }

            @Override
            public short getMaterialData() {
                return (short)data.getAsInt();
            }

            public String toString() {
                return ChatColor.stripColor((String)(this.getCreator().getName() + ": " + this.getName() + ": " + this.getLocation() + " - " + this.getExtra()));
            }
        };
    }
}

