/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.events.WarlordsPointsChangedEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.option.marker.scoreboard.SimpleScoreboardHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WinByPointsOption
implements Option,
Listener {
    public static final int DEFAULT_POINT_LIMIT = 1000;
    private static final int SCOREBOARD_PRIORITY = 5;
    private int pointLimit;
    private boolean hasActivated = false;
    private ScoreboardHandler scoreboard;

    public WinByPointsOption() {
        this(1000);
    }

    public WinByPointsOption(int pointLimit) {
        this.pointLimit = pointLimit;
    }

    @Override
    public void register(final Game game) {
        game.registerEvents(this);
        this.scoreboard = new SimpleScoreboardHandler(5, "points"){

            @Override
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                return TeamMarker.getTeams(game).stream().map(t2 -> t2.coloredPrefix() + ": " + ChatColor.AQUA + game.getPoints((Team)((Object)t2)) + ChatColor.GOLD + "/" + WinByPointsOption.this.pointLimit).collect(Collectors.toList());
            }
        };
        game.registerGameMarker(ScoreboardHandler.class, this.scoreboard);
    }

    public void setPointLimit(int pointLimit) {
        this.pointLimit = pointLimit;
    }

    public int getPointLimit() {
        return this.pointLimit;
    }

    @EventHandler
    public void onEvent(WarlordsPointsChangedEvent event) {
        if (!this.hasActivated && event.getNewPoints() >= this.pointLimit) {
            WarlordsGameTriggerWinEvent e = new WarlordsGameTriggerWinEvent(event.getGame(), this, event.getTeam());
            Bukkit.getPluginManager().callEvent((Event)e);
            if (!e.isCancelled()) {
                this.hasActivated = true;
            }
        }
    }
}

