/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.WinByPointsOption;
import com.ebicep.warlords.game.option.marker.PointPredicterMarker;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.option.marker.scoreboard.SimpleScoreboardHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitTask;

public class WinAfterTimeoutOption
implements Option {
    public static final int DEFAULT_TIME_REMAINING = 900;
    public static final Team DEFAULT_WINNER = null;
    private static final int SCOREBOARD_PRIORITY = 10;
    private int timeRemaining;
    private int timeInitial;
    private SimpleScoreboardHandler scoreboard;
    private BukkitTask runTaskTimer;
    private Team winner;

    public WinAfterTimeoutOption() {
        this(900, DEFAULT_WINNER);
    }

    public WinAfterTimeoutOption(int timeRemaining) {
        this(timeRemaining, DEFAULT_WINNER);
    }

    public WinAfterTimeoutOption(Team winner) {
        this(900, winner);
    }

    public WinAfterTimeoutOption(int timeRemaining, Team winner) {
        this.timeRemaining = timeRemaining;
        this.timeInitial = timeRemaining;
    }

    public int getTimeElapsed() {
        return this.timeInitial - this.timeRemaining;
    }

    public void setTimeRemaining(int timeRemaining) {
        this.timeRemaining = timeRemaining;
        this.timeInitial = timeRemaining;
    }

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public Team getWinner() {
        return this.winner;
    }

    public void setWinner(Team winner) {
        this.winner = winner;
    }

    @Override
    public void register(final Game game) {
        new TimerSkipAbleMarker(){

            @Override
            public int getDelay() {
                return WinAfterTimeoutOption.this.timeRemaining * 20;
            }

            @Override
            public void skipTimer(int delay) {
                WinAfterTimeoutOption.this.timeRemaining = WinAfterTimeoutOption.this.timeRemaining - delay / 20;
            }
        }.register(game);
        this.scoreboard = new SimpleScoreboardHandler(10, "timeout"){

            @Override
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                EnumSet<Team> teams = TeamMarker.getTeams(game);
                Team winner = null;
                if (teams.size() > 1) {
                    List<PointPredicterMarker> predictionMarkers = game.getMarkers(PointPredicterMarker.class);
                    int scoreNeededToEndGame = game.getOptions().stream().filter(e -> e instanceof WinByPointsOption).mapToInt(e -> ((WinByPointsOption)e).getPointLimit()).sorted().findFirst().orElse(Integer.MAX_VALUE);
                    int highestScore = Integer.MIN_VALUE;
                    int highestWinInSeconds = Integer.MAX_VALUE;
                    for (Team team : teams) {
                        int winInSeconds;
                        int points = game.getPoints(team);
                        if (predictionMarkers.isEmpty()) {
                            winInSeconds = Integer.MAX_VALUE;
                        } else {
                            double pointsPerMinute = predictionMarkers.stream().mapToDouble(e -> e.predictPointsNextMinute(team)).sum();
                            int pointsRemaining = scoreNeededToEndGame - points;
                            int winInSecondsCalculated = pointsPerMinute <= 0.0 ? Integer.MAX_VALUE : (int)((double)pointsRemaining / pointsPerMinute * 60.0);
                            int pointsAfterTimeIsOver = (int)((double)points + (double)WinAfterTimeoutOption.this.timeRemaining * pointsPerMinute / 60.0);
                            if (winInSecondsCalculated >= 0 && winInSecondsCalculated < WinAfterTimeoutOption.this.timeRemaining) {
                                winInSeconds = winInSecondsCalculated;
                                points = scoreNeededToEndGame;
                            } else {
                                winInSeconds = WinAfterTimeoutOption.this.timeRemaining;
                                points = pointsAfterTimeIsOver;
                            }
                        }
                        if (points > highestScore) {
                            highestScore = points;
                            highestWinInSeconds = winInSeconds;
                            winner = team;
                            continue;
                        }
                        if (points != highestScore) continue;
                        if (winInSeconds < highestWinInSeconds) {
                            highestWinInSeconds = winInSeconds;
                            winner = team;
                            continue;
                        }
                        if (winInSeconds != highestWinInSeconds) continue;
                        winner = null;
                    }
                }
                StringBuilder message = new StringBuilder(64);
                if (winner != null) {
                    message.append(winner.coloredPrefix()).append(ChatColor.GOLD).append(" Wins in: ");
                } else {
                    message.append(ChatColor.WHITE).append("Time Left: ");
                }
                message.append(ChatColor.GREEN);
                Utils.formatTimeLeft(message, WinAfterTimeoutOption.this.timeRemaining);
                return Collections.singletonList(message.toString());
            }
        };
        game.registerGameMarker(ScoreboardHandler.class, this.scoreboard);
    }

    @Override
    public void start(final Game game) {
        this.runTaskTimer = new GameRunnable(game){

            @Override
            public void run() {
                WinAfterTimeoutOption.this.timeRemaining--;
                if (WinAfterTimeoutOption.this.timeRemaining <= 0) {
                    Team leader;
                    if (WinAfterTimeoutOption.this.winner == null) {
                        int higest = Integer.MIN_VALUE;
                        int secondHighest = Integer.MIN_VALUE;
                        leader = null;
                        for (Team team : TeamMarker.getTeams(game)) {
                            int points = game.getPoints(team);
                            if (points > higest) {
                                leader = team;
                                secondHighest = higest;
                                higest = points;
                                continue;
                            }
                            if (points <= secondHighest) continue;
                            secondHighest = points;
                        }
                        if (higest <= secondHighest) {
                            leader = null;
                        }
                    } else {
                        leader = WinAfterTimeoutOption.this.winner;
                    }
                    WarlordsGameTriggerWinEvent event = new WarlordsGameTriggerWinEvent(game, WinAfterTimeoutOption.this, leader);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        this.cancel();
                    }
                }
                WinAfterTimeoutOption.this.scoreboard.markChanged();
            }
        }.runTaskTimer(20L, 20L);
    }

    @Override
    public void onGameEnding(@Nonnull Game game) {
        if (this.runTaskTimer != null) {
            this.runTaskTimer.cancel();
            this.runTaskTimer = null;
        }
    }

    public static OptionalInt getTimeRemaining(@Nonnull Game game) {
        for (Option option : game.getOptions()) {
            if (!(option instanceof WinAfterTimeoutOption)) continue;
            WinAfterTimeoutOption drawAfterTimeoutOption = (WinAfterTimeoutOption)option;
            return OptionalInt.of(drawAfterTimeoutOption.getTimeRemaining());
        }
        return OptionalInt.empty();
    }
}

