/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;

public class TextOption
implements Option,
TimerSkipAbleMarker {
    public static final int DEFAULT_DELAY = 0;
    @Nonnull
    private Type type;
    @Nonnull
    private List<String> text;
    private int delay;
    private Game game;

    public TextOption(@Nonnull Type type, @Nonnull List<String> text) {
        this(type, text, 0);
    }

    public TextOption(@Nonnull Type type, @Nonnull List<String> text, int delay) {
        this.type = Objects.requireNonNull(type, "type");
        this.text = Objects.requireNonNull(text, "text");
        this.delay = delay;
    }

    @Nonnull
    public List<String> getText() {
        return this.text;
    }

    public void setText(@Nonnull List<String> text) {
        this.text = Objects.requireNonNull(text, "text");
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public void setType(@Nonnull Type type) {
        this.type = Objects.requireNonNull(type, "type");
    }

    public void sendText() {
        this.type.sendText(this.game, this.text);
    }

    @Override
    public void start(@Nonnull Game game) {
        Option.super.start(game);
        if (this.delay <= 0) {
            this.sendText();
        } else {
            new GameRunnable(game){

                @Override
                public void run() {
                    if (TextOption.this.delay <= 0) {
                        TextOption.this.sendText();
                        this.cancel();
                    }
                    TextOption.this.delay--;
                }
            }.runTaskTimer(0L, 20L);
        }
    }

    @Override
    public int getDelay() {
        return this.delay * 20;
    }

    @Override
    public void skipTimer(int delayInTicks) {
        this.delay -= delayInTicks / 20;
    }

    @Override
    public void register(Game game) {
        this.game = game;
        game.registerGameMarker(TimerSkipAbleMarker.class, this);
    }

    public static enum Type {
        CHAT_CENTERED{

            @Override
            public void sendText(@Nonnull Game game, @Nonnull List<String> messages) {
                game.forEachOnlinePlayer((p, t2) -> {
                    ChatUtils.sendMessage(p, false, "" + ChatColor.GREEN + ChatColor.BOLD + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                    for (String line : messages) {
                        ChatUtils.sendMessage(p, true, line);
                    }
                    ChatUtils.sendMessage(p, false, "" + ChatColor.GREEN + ChatColor.BOLD + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                });
            }
        }
        ,
        CHAT{

            @Override
            public void sendText(@Nonnull Game game, @Nonnull List<String> messages) {
                game.forEachOnlinePlayer((p, t2) -> {
                    ChatUtils.sendMessage(p, false, "" + ChatColor.GREEN + ChatColor.BOLD + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                    for (String line : messages) {
                        ChatUtils.sendMessage(p, false, line);
                    }
                    ChatUtils.sendMessage(p, false, "" + ChatColor.GREEN + ChatColor.BOLD + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                });
            }
        }
        ,
        TITLE{

            @Override
            public void sendText(final @Nonnull Game game, @Nonnull List<String> messages) {
                final Iterator<String> itr = messages.iterator();
                if (!itr.hasNext()) {
                    return;
                }
                new GameRunnable(game){

                    @Override
                    public void run() {
                        String title = (String)itr.next();
                        String subtitle = itr.hasNext() ? (String)itr.next() : "";
                        game.forEachOnlinePlayer((p, t2) -> PacketUtils.sendTitle(p, title, subtitle, 0, 40, 20));
                        if (!itr.hasNext()) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer(0L, 40L);
            }
        };


        public abstract void sendText(@Nonnull Game var1, @Nonnull List<String> var2);

        public TextOption create(@Nonnull List<String> text) {
            return new TextOption(this, text);
        }

        public TextOption create(String ... text) {
            return new TextOption(this, Arrays.asList(text));
        }

        public TextOption create(int delay, @Nonnull List<String> text) {
            return new TextOption(this, text, delay);
        }

        public TextOption create(int delay, String ... text) {
            return new TextOption(this, Arrays.asList(text), delay);
        }
    }
}

