/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.MarkerOption;
import com.ebicep.warlords.game.option.marker.DebugLocationMarker;
import com.ebicep.warlords.game.option.marker.SpawnLocationMarker;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;

public class SpawnpointOption
extends MarkerOption {
    public static final int BAD_TEAM_PENALTY = -10000;

    public SpawnpointOption(final Location location, final ToDoubleFunction<WarlordsPlayer> teamCheck, List<String> debugExtra) {
        super(new SpawnLocationMarker(){

            @Override
            public double getPriority(WarlordsPlayer player) {
                return teamCheck.applyAsDouble(player);
            }

            @Override
            public Location getLocation() {
                return location;
            }
        }, DebugLocationMarker.create(Material.BED, 0, SpawnpointOption.class, "Spawnpoint", location, () -> debugExtra));
    }

    public static SpawnpointOption forTeam(Location location, Team team) {
        return new SpawnpointOption(location, p -> p.getTeam() == team ? 0.0 : -10000.0, Arrays.asList("Type: for-team", "Team: " + (Object)((Object)team)));
    }

    public static SpawnpointOption avoidingEnemyPlayers(Location location) {
        return new SpawnpointOption(location, p -> {
            Location cache = new Location(null, 0.0, 0.0, 0.0);
            Map<Boolean, Double> distances = p.getGame().offlinePlayersWithoutSpectators().map(w -> Warlords.getPlayer((OfflinePlayer)w.getKey())).filter(o -> o != null && o.isAlive()).collect(Collectors.groupingBy(w -> p.getTeam() == null || w.getTeam() == p.getTeam(), Collectors.averagingDouble(w -> Math.pow(w.getLocation(cache).distanceSquared(location), 0.25))));
            double distanceToEnemy = distances.getOrDefault(Boolean.FALSE, 0.0);
            double distanceToFriendlies = distances.getOrDefault(Boolean.TRUE, 0.0);
            return distanceToFriendlies - distanceToEnemy;
        }, Arrays.asList("Type: avoiding-enemy-players"));
    }
}

