/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsDeathEvent;
import com.ebicep.warlords.events.WarlordsRespawnEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class RespawnWaveOption
implements Option,
Listener {
    public static final int DEFAULT_INITIAL_DELAY = 0;
    public static final int DEFAULT_TASK_PERIOD = 12;
    public static final int DEFAULT_MIN_RESPAWN_TIMER = 5;
    private int initialDelay;
    private int taskPeriod;
    private int minRespawnTimer;
    private int currentTimer = 0;

    public RespawnWaveOption() {
        this(0, 12, 5);
    }

    public RespawnWaveOption(int initialTaskDelay, int taskPeriod, int minRespawnTimer) {
        this.initialDelay = initialTaskDelay;
        this.taskPeriod = taskPeriod;
        this.minRespawnTimer = minRespawnTimer;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public int getTaskPeriod() {
        return this.taskPeriod;
    }

    public void setTaskPeriod(int taskPeriod) {
        this.taskPeriod = taskPeriod;
    }

    public int getMinRespawnTimer() {
        return this.minRespawnTimer;
    }

    public void setMinRespawnTimer(int minRespawnTimer) {
        this.minRespawnTimer = minRespawnTimer;
    }

    public int getCurrentTimer() {
        return this.currentTimer;
    }

    public void setCurrentTimer(int currentTimer) {
        this.currentTimer = currentTimer;
    }

    @Override
    public void register(Game game) {
        game.registerEvents(this);
        game.registerGameMarker(TimerSkipAbleMarker.class, delayInTicks -> {
            this.currentTimer += delayInTicks / 20;
            for (WarlordsPlayer player : PlayerFilter.playingGame(game)) {
                if (player.getRespawnTimer() < 0) continue;
                player.setRespawnTimer(Math.max(player.getRespawnTimer() - delayInTicks * 20, 0));
            }
        });
        this.currentTimer = -this.initialDelay;
    }

    @Override
    public void start(final Game game) {
        new GameRunnable(game){

            @Override
            public void run() {
                RespawnWaveOption.this.currentTimer++;
                for (WarlordsPlayer player : PlayerFilter.playingGame(game)) {
                    if (!player.isDead() || !player.isOnline() || player.getRespawnTimer() != -1) continue;
                    RespawnWaveOption.this.giveRespawnTimer(player);
                }
            }
        }.runTaskTimer(20L, 20L);
    }

    @EventHandler
    public void onEvent(WarlordsDeathEvent event) {
        this.giveRespawnTimer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEvent(WarlordsRespawnEvent event) {
        if (event.isCancelled() && event.getPlayer().getRespawnTimer() == 0) {
            int respawn;
            for (respawn = -this.currentTimer % this.taskPeriod; respawn < 1; respawn += this.taskPeriod) {
            }
            event.getPlayer().setRespawnTimer(respawn);
        }
    }

    public void giveRespawnTimer(WarlordsPlayer player) {
        int respawn;
        for (respawn = -this.currentTimer % this.taskPeriod; respawn < this.minRespawnTimer; respawn += this.taskPeriod) {
        }
        player.setRespawnTimer(respawn);
    }
}

