/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.events.WarlordsRespawnEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class RespawnProtectionOption
implements Option,
Listener {
    private static final int DEFAULT_PROTECTION_TIME = 4;
    private static final int DEFAULT_RADIUS = 5;
    private final Map<WarlordsPlayer, Pair<Location, Integer>> spawnProtection = new HashMap<WarlordsPlayer, Pair<Location, Integer>>();
    private int protectionTime;
    private int radius;
    private int radiusSquared;

    public RespawnProtectionOption() {
        this(4, 5);
    }

    public RespawnProtectionOption(int protectionTime) {
        this(protectionTime, 5);
    }

    public RespawnProtectionOption(int protectionTime, int radius) {
        this.protectionTime = protectionTime;
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    public int getRadiusSquared() {
        return this.radiusSquared;
    }

    @Override
    public void register(Game game) {
        game.registerEvents(this);
    }

    @Override
    public void start(Game game) {
        new GameRunnable(game){
            private final Location location;
            {
                this.location = new Location(null, 0.0, 0.0, 0.0);
            }

            @Override
            public void run() {
                Iterator itr = RespawnProtectionOption.this.spawnProtection.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry next = itr.next();
                    int newVal = (Integer)((Pair)next.getValue()).getB() - 1;
                    if (newVal <= 0 || ((WarlordsPlayer)next.getKey()).getLocation().getWorld() == ((Location)((Pair)next.getValue()).getA()).getWorld() && ((WarlordsPlayer)next.getKey()).getLocation(this.location).distanceSquared((Location)((Pair)next.getValue()).getA()) > (double)RespawnProtectionOption.this.radiusSquared) {
                        itr.remove();
                        continue;
                    }
                    ((Pair)next.getValue()).setB(newVal);
                }
            }
        }.runTaskTimer(0L, 5L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEvent(WarlordsRespawnEvent event) {
        WarlordsPlayer player = event.getPlayer();
        Location respawnPoint = event.getRespawnLocation();
        this.spawnProtection.put(player, new Pair<Location, Integer>(respawnPoint, this.protectionTime * 4));
    }

    @EventHandler
    public void onEvent(WarlordsDamageHealingEvent event) {
        if (this.spawnProtection.containsKey(event.getPlayer())) {
            event.getPlayer().removeHorse();
            event.setCancelled(true);
        }
    }
}

