/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.abilties.internal.DamagePowerup;
import com.ebicep.warlords.abilties.internal.EnergyPowerup;
import com.ebicep.warlords.abilties.internal.HealingPowerup;
import com.ebicep.warlords.abilties.internal.SpeedPowerup;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.DebugLocationMarker;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;

public class PowerupOption
implements Option {
    public static int DEFAULT_TIME_TO_SPAWN = 60;
    public static int DEFAULT_MAX_COOLDOWN = 45;
    @Nonnull
    private Location location;
    @Nonnull
    private PowerupType type;
    @Nullable
    private ArmorStand entity;
    @Nonnegative
    private int duration;
    @Nonnegative
    private int cooldown;
    @Nonnegative
    private int maxCooldown;
    private boolean hasStarted = false;
    @Nonnull
    private Game game;

    public PowerupOption(@Nonnull Location location, @Nonnull PowerupType type) {
        this(location, type, type.getDuration(), DEFAULT_MAX_COOLDOWN, DEFAULT_TIME_TO_SPAWN);
    }

    public PowerupOption(@Nonnull Location location, @Nonnull PowerupType type, @Nonnegative int duration, @Nonnegative int maxCooldown, @Nonnegative int timeToSpawn) {
        this.location = Objects.requireNonNull(location, "location");
        this.type = Objects.requireNonNull(type, "type");
        this.duration = duration;
        this.maxCooldown = maxCooldown;
        this.cooldown = timeToSpawn * 4;
    }

    @Override
    public void register(Game game) {
        this.game = game;
        game.registerGameMarker(DebugLocationMarker.class, DebugLocationMarker.create(() -> this.type.getDebugMaterial(), () -> this.type.getDebugData(), this::getClass, () -> this.getClass().getSimpleName() + ": " + this.type.name(), this::getLocation, () -> Arrays.asList("Type: " + (Object)((Object)this.getType()), "Cooldown: " + this.getCooldown(), "Duration: " + this.getDuration(), "Max cooldown: " + this.getMaxCooldown(), "Entity: " + this.getEntity())));
        game.registerGameMarker(TimerSkipAbleMarker.class, new TimerSkipAbleMarker(){

            @Override
            public void skipTimer(int delayInTicks) {
                PowerupOption.this.cooldown = Math.max(PowerupOption.this.cooldown - delayInTicks / 20, 0);
                if (PowerupOption.this.cooldown == 0) {
                    PowerupOption.this.spawn();
                }
            }

            @Override
            public int getDelay() {
                return PowerupOption.this.cooldown * 20;
            }
        });
    }

    @Override
    public void start(Game game) {
        this.hasStarted = true;
        if (this.cooldown == 0) {
            this.spawn();
        }
        new GameRunnable(game){

            @Override
            public void run() {
                if (PowerupOption.this.cooldown == 0) {
                    PlayerFilter.entitiesAround(PowerupOption.this.location, 1.4, 1.4, 1.4).isAlive().first(nearPlayer -> {
                        PowerupOption.this.type.onPickUp(PowerupOption.this, (WarlordsPlayer)nearPlayer);
                        PowerupOption.this.remove();
                        PowerupOption.this.cooldown = PowerupOption.this.maxCooldown * 4;
                    });
                } else {
                    PowerupOption.this.cooldown--;
                    if (PowerupOption.this.cooldown == 0) {
                        PowerupOption.this.spawn();
                    }
                }
            }
        }.runTaskTimer(0L, 5L);
    }

    private void remove() {
        if (this.entity == null) {
            return;
        }
        this.entity.remove();
        this.entity = null;
    }

    private void spawn() {
        if (this.entity != null) {
            return;
        }
        this.entity = (ArmorStand)this.location.getWorld().spawn(this.location.clone().add(0.0, -1.5, 0.0), ArmorStand.class);
        this.type.setNameAndItem(this, this.entity);
        this.entity.setGravity(false);
        this.entity.setVisible(false);
        this.entity.setCustomNameVisible(true);
        Utils.playGlobalSound(this.location, "ctf.powerup.spawn", 2.0f, 1.0f);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        if (this.hasStarted) {
            throw new IllegalStateException("Cannot change location after starting.");
        }
        this.location = location;
    }

    public PowerupType getType() {
        return this.type;
    }

    public void setType(PowerupType type) {
        if (this.hasStarted) {
            throw new IllegalStateException("Cannot change type after starting.");
        }
        this.type = type;
        this.remove();
    }

    public void setTypeAndDuration(PowerupType type) {
        this.setType(type);
        this.duration = type.getDuration();
        this.remove();
    }

    public ArmorStand getEntity() {
        return this.entity;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    public void setDuration(@Nonnegative int duration) {
        this.duration = duration;
    }

    public void setCooldown(@Nonnegative int cooldown) {
        int oldCooldown = cooldown;
        this.cooldown = cooldown;
        if (oldCooldown == 0 && cooldown != 0) {
            this.remove();
        }
        if (oldCooldown != 0 && cooldown == 0 && this.hasStarted) {
            this.spawn();
        }
    }

    public void setMaxCooldown(@Nonnegative int maxCooldown) {
        this.maxCooldown = maxCooldown;
    }

    public static enum PowerupType {
        SPEED(10, Material.WOOL, 4){

            @Override
            public void onPickUp(PowerupOption option, WarlordsPlayer warlordsPlayer) {
                warlordsPlayer.getCooldownManager().removeCooldown(SpeedPowerup.class);
                warlordsPlayer.getCooldownManager().addRegularCooldown("Speed", "SPEED", SpeedPowerup.class, SpeedPowerup.SPEED_POWERUP, null, CooldownTypes.BUFF, cooldownManager -> warlordsPlayer.sendMessage(ChatColor.GOLD + "Your " + ChatColor.YELLOW + ChatColor.BOLD + "SPEED" + ChatColor.GOLD + " powerup has worn off."), option.getDuration() * 20, new TriConsumer[0]);
                warlordsPlayer.sendMessage(String.format("\u00a76You activated the \u00a7e\u00a7lSPEED \u00a76powerup! \u00a7a+40%% \u00a76Speed for \u00a7a%d \u00a76seconds!", option.getDuration()));
                warlordsPlayer.getSpeed().addSpeedModifier("Speed Powerup", 40, 200, "BASE");
                Utils.playGlobalSound(option.getLocation(), "ctf.powerup.speed", 2.0f, 1.0f);
            }

            @Override
            public void setNameAndItem(PowerupOption option, ArmorStand armorStand) {
                armorStand.setCustomName("\u00a7b\u00a7lSPEED");
                armorStand.setHelmet(new ItemStack(Material.WOOL, 1, 4));
            }
        }
        ,
        HEALING(5, Material.WOOL, 13){

            @Override
            public void onPickUp(PowerupOption option, WarlordsPlayer warlordsPlayer) {
                warlordsPlayer.getCooldownManager().removeCooldown(HealingPowerup.class);
                warlordsPlayer.getCooldownManager().addRegularCooldown("Healing", "HEAL", HealingPowerup.class, HealingPowerup.HEALING_POWERUP, null, CooldownTypes.BUFF, cooldownManager -> warlordsPlayer.sendMessage(ChatColor.GOLD + "Your " + ChatColor.GREEN + ChatColor.BOLD + "HEALING" + ChatColor.GOLD + " powerup has worn off."), option.getDuration() * 20, new TriConsumer[0]);
                warlordsPlayer.sendMessage(String.format("\u00a76You activated the \u00a7a\u00a7lHEALING \u00a76powerup! \u00a7a+8%% \u00a76Health per second for \u00a7a%d \u00a76seconds!", option.getDuration()));
            }

            @Override
            public void setNameAndItem(PowerupOption option, ArmorStand armorStand) {
                armorStand.setCustomName("\u00a7a\u00a7lHEALING");
                armorStand.setHelmet(new ItemStack(Material.WOOL, 1, 13));
            }
        }
        ,
        ENERGY(30, Material.WOOL, 1){

            @Override
            public void onPickUp(PowerupOption option, WarlordsPlayer warlordsPlayer) {
                warlordsPlayer.getCooldownManager().removeCooldown(EnergyPowerup.class);
                warlordsPlayer.getCooldownManager().addRegularCooldown("Energy", "ENERGY", EnergyPowerup.class, EnergyPowerup.ENERGY_POWERUP, null, CooldownTypes.BUFF, cooldownManager -> warlordsPlayer.sendMessage(ChatColor.GOLD + "Your " + ChatColor.GOLD + ChatColor.BOLD + "ENERGY" + ChatColor.GOLD + " powerup has worn off."), option.getDuration() * 20, new TriConsumer[0]);
                warlordsPlayer.sendMessage(String.format("\u00a76You activated the \u00a7lENERGY \u00a76powerup! \u00a7a+40%% \u00a76Energy gain for \u00a7a%d \u00a76seconds!", option.getDuration()));
            }

            @Override
            public void setNameAndItem(PowerupOption option, ArmorStand armorStand) {
                armorStand.setCustomName("\u00a76\u00a7lENERGY");
                armorStand.setHelmet(new ItemStack(Material.WOOL, 1, 1));
            }
        }
        ,
        DAMAGE(30, Material.WOOL, 14){

            @Override
            public void onPickUp(PowerupOption option, WarlordsPlayer warlordsPlayer) {
                warlordsPlayer.getCooldownManager().removeCooldown(DamagePowerup.class);
                warlordsPlayer.getCooldownManager().addRegularCooldown("Damage", "DMG", DamagePowerup.class, DamagePowerup.DAMAGE_POWERUP, null, CooldownTypes.BUFF, cooldownManager -> warlordsPlayer.sendMessage(ChatColor.GOLD + "Your " + ChatColor.RED + ChatColor.BOLD + "DAMAGE" + ChatColor.GOLD + " powerup has worn off."), option.getDuration() * 20, new TriConsumer[0]);
                warlordsPlayer.sendMessage(String.format("\u00a76You activated the \u00a7c\u00a7lDAMAGE \u00a76powerup! \u00a7a+20%% \u00a76Damage for \u00a7a%d \u00a76seconds!", option.getDuration()));
            }

            @Override
            public void setNameAndItem(PowerupOption option, ArmorStand armorStand) {
                armorStand.setCustomName("\u00a7c\u00a7lDAMAGE");
                armorStand.setHelmet(new ItemStack(Material.WOOL, 1, 14));
            }
        };

        private final int duration;
        private final Material debugMaterial;
        private final int debugData;

        private PowerupType(int duration, Material debugMaterial, int debugData) {
            this.duration = duration;
            this.debugMaterial = debugMaterial;
            this.debugData = debugData;
        }

        public int getDuration() {
            return this.duration;
        }

        public Material getDebugMaterial() {
            return this.debugMaterial;
        }

        public int getDebugData() {
            return this.debugData;
        }

        public abstract void onPickUp(PowerupOption var1, WarlordsPlayer var2);

        public abstract void setNameAndItem(PowerupOption var1, ArmorStand var2);
    }
}

