/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.EnumSet;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class MercyWinOption
implements Option {
    private static final int DEFAULT_LIMIT = 550;
    private static final int DEFAULT_TIMER = 300;
    private int limit;
    private int timer;

    public MercyWinOption() {
        this(550, 300);
    }

    public MercyWinOption(int mercyLimit) {
        this(550, 300);
    }

    public MercyWinOption(int mercyLimit, int timer) {
        this.limit = mercyLimit;
        this.timer = timer;
    }

    public int getLimit() {
        return this.limit;
    }

    public MercyWinOption setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void register(Game game) {
        game.registerGameMarker(TimerSkipAbleMarker.class, delayInTicks -> this.timer -= delayInTicks / 20);
    }

    @Override
    public void start(final Game game) {
        final EnumSet<Team> teams = TeamMarker.getTeams(game);
        new GameRunnable(game){

            @Override
            public void run() {
                if (MercyWinOption.this.timer > 0) {
                    MercyWinOption.this.timer--;
                    return;
                }
                int higest = Integer.MIN_VALUE;
                int secondHighest = Integer.MIN_VALUE;
                Team winner = null;
                for (Team team : teams) {
                    int points = game.getPoints(team);
                    if (points > higest) {
                        winner = team;
                        secondHighest = higest;
                        higest = points;
                        continue;
                    }
                    if (points <= secondHighest) continue;
                    secondHighest = points;
                }
                if (higest - MercyWinOption.this.limit >= secondHighest) {
                    WarlordsGameTriggerWinEvent event = new WarlordsGameTriggerWinEvent(game, MercyWinOption.this, winner);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer(20L, 20L);
    }
}

