/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.FlagSpawnPointOption;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.state.EndState;
import com.ebicep.warlords.player.ArmorManager;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.Weapons;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class InterchangeModeOption
implements Option {
    public static final int MAX_SWAP_TIME = 80;
    public static final int MIN_SWAP_TIME = 50;
    private final HashMap<UUID, Specializations> previousSelectedSpecs = new HashMap();
    private final HashMap<UUID, HashMap<Specializations, SkillBoosts>> previousSelectedSkillBoosts = new HashMap();
    private final HashMap<UUID, HashMap<Specializations, Weapons>> previousSelectedWeaponSkins = new HashMap();
    private final HashMap<UUID, List<ArmorManager.Helmets>> previousSelectedHelmets = new HashMap();
    private final HashMap<UUID, List<ArmorManager.ArmorSets>> previousSelectedArmorSets = new HashMap();
    private int secondsUntilNextSwap = 0;

    @Override
    public void register(@Nonnull Game game) {
    }

    @Override
    public void start(final @Nonnull Game game) {
        game.getPlayers().forEach((uuid, team) -> {
            System.out.println("SETTING " + Bukkit.getOfflinePlayer((UUID)uuid).getName());
            PlayerSettings playerSettings = Warlords.getPlayerSettings(uuid);
            System.out.println(Bukkit.getOfflinePlayer((UUID)uuid).getName() + " " + (Object)((Object)playerSettings.getSelectedSpec()));
            this.previousSelectedSpecs.put((UUID)uuid, playerSettings.getSelectedSpec());
            this.previousSelectedSkillBoosts.put((UUID)uuid, playerSettings.getClassesSkillBoosts());
            this.previousSelectedWeaponSkins.put((UUID)uuid, playerSettings.getWeaponSkins());
            this.previousSelectedHelmets.put((UUID)uuid, ArmorManager.Helmets.getSelected(uuid));
            this.previousSelectedArmorSets.put((UUID)uuid, ArmorManager.ArmorSets.getSelected(uuid));
        });
        this.generateNextSwapTime();
        new GameRunnable(game){
            int secondsPast;
            {
                super(game3);
                this.secondsPast = 0;
            }

            @Override
            public void run() {
                if (game.getState() instanceof EndState) {
                    return;
                }
                if (this.secondsPast >= InterchangeModeOption.this.secondsUntilNextSwap) {
                    InterchangeModeOption.this.swap(game);
                    InterchangeModeOption.this.generateNextSwapTime();
                    this.secondsPast = 0;
                }
                ++this.secondsPast;
            }
        }.runTaskTimer(20L, 20L);
    }

    @Override
    public void onGameEnding(@Nonnull Game game) {
        game.getPlayers().forEach((uuid, team) -> {
            System.out.println("RESETTING " + Bukkit.getOfflinePlayer((UUID)uuid).getName());
            PlayerSettings playerSettings = Warlords.getPlayerSettings(uuid);
            playerSettings.setSelectedSpec(this.previousSelectedSpecs.get(uuid));
            playerSettings.setSpecsSkillBoosts(this.previousSelectedSkillBoosts.get(uuid));
            playerSettings.setWeaponSkins(this.previousSelectedWeaponSkins.get(uuid));
            playerSettings.setHelmets(this.previousSelectedHelmets.get(uuid));
            playerSettings.setArmorSets(this.previousSelectedArmorSets.get(uuid));
        });
    }

    private void swap(Game game) {
        TeamMarker.getTeams(game).forEach(team -> this.swapTeamMembers(game, (Team)((Object)team)));
        for (Option option : game.getOptions()) {
            if (!(option instanceof FlagSpawnPointOption)) continue;
            ((FlagSpawnPointOption)option).getRenderer().render();
        }
    }

    private void swapTeamMembers(Game game, Team team) {
        List teamPlayers = game.warlordsPlayers().filter(warlordsPlayer -> warlordsPlayer.getTeam() == team).collect(Collectors.toList());
        if (teamPlayers.size() <= 1) {
            return;
        }
        HashMap<UUID, Location> playerLocations = new HashMap<UUID, Location>();
        HashMap<UUID, Specializations> playerClasses = new HashMap<UUID, Specializations>();
        HashMap<UUID, HashMap<Specializations, SkillBoosts>> playerBoosts = new HashMap<UUID, HashMap<Specializations, SkillBoosts>>();
        HashMap<UUID, HashMap<Specializations, Weapons>> playerWeaponSkins = new HashMap<UUID, HashMap<Specializations, Weapons>>();
        HashMap<UUID, List<ArmorManager.Helmets>> playerHelmets = new HashMap<UUID, List<ArmorManager.Helmets>>();
        HashMap<UUID, List<ArmorManager.ArmorSets>> playerArmorSets = new HashMap<UUID, List<ArmorManager.ArmorSets>>();
        HashMap<UUID, Boolean> playerOnHorse = new HashMap<UUID, Boolean>();
        for (WarlordsPlayer teamPlayer : teamPlayers) {
            UUID uuid = teamPlayer.getUuid();
            playerLocations.put(uuid, teamPlayer.getLocation());
            PlayerSettings playerSettings = Warlords.getPlayerSettings(uuid);
            playerClasses.put(uuid, playerSettings.getSelectedSpec());
            playerBoosts.put(uuid, playerSettings.getClassesSkillBoosts());
            playerWeaponSkins.put(uuid, playerSettings.getWeaponSkins());
            playerHelmets.put(uuid, playerSettings.getHelmets());
            playerArmorSets.put(uuid, playerSettings.getArmorSets());
            playerOnHorse.put(uuid, teamPlayer.getEntity().getVehicle() != null);
        }
        WarlordsPlayer secondPlayer = (WarlordsPlayer)teamPlayers.get(0);
        String secondPlayerName = secondPlayer.getName();
        UUID secondPlayerUuid = secondPlayer.getUuid();
        LivingEntity secondPlayerEntity = secondPlayer.getEntity();
        PlayerSettings playerSettings = Warlords.getPlayerSettings(secondPlayer.getUuid());
        for (int i = 0; i < teamPlayers.size() - 1; ++i) {
            this.transferPlayerStats((WarlordsPlayer)teamPlayers.get(i), (WarlordsPlayer)teamPlayers.get(i + 1), playerLocations, playerClasses, playerBoosts, playerWeaponSkins, playerHelmets, playerArmorSets, playerOnHorse);
        }
        WarlordsPlayer firstPlayer = (WarlordsPlayer)teamPlayers.get(teamPlayers.size() - 1);
        System.out.println("LAST SWAP - " + firstPlayer.getName() + " <<< " + secondPlayerName);
        UUID firstPlayerUuid = firstPlayer.getUuid();
        firstPlayer.setName(secondPlayerName);
        firstPlayer.setUuid(secondPlayerUuid);
        secondPlayerEntity.teleport(playerLocations.get(firstPlayerUuid));
        firstPlayer.setEntity(secondPlayerEntity);
        if (playerOnHorse.get(firstPlayerUuid).booleanValue()) {
            firstPlayer.getHorse().spawn();
        }
        if (firstPlayer.getEntity() instanceof Player) {
            PacketUtils.sendTitle((Player)firstPlayer.getEntity(), ChatColor.YELLOW + "Swapped to", ChatColor.GREEN.toString() + ChatColor.MAGIC + "00" + ChatColor.GREEN + " " + firstPlayer.getSpecClass().name + "! " + ChatColor.MAGIC + "00", 10, 40, 10);
        }
        playerSettings.setSelectedSpec(playerClasses.get(firstPlayerUuid));
        playerSettings.setWeaponSkins(playerWeaponSkins.get(firstPlayerUuid));
        playerSettings.setSpecsSkillBoosts(playerBoosts.get(firstPlayerUuid));
        playerSettings.setHelmets(playerHelmets.get(firstPlayerUuid));
        playerSettings.setArmorSets(playerArmorSets.get(firstPlayerUuid));
        if (firstPlayer.getEntity() instanceof Player) {
            firstPlayer.updatePlayer((Player)firstPlayer.getEntity());
        }
        Warlords.getPlayers().put(secondPlayerUuid, firstPlayer);
    }

    private void transferPlayerStats(WarlordsPlayer firstPlayer, WarlordsPlayer secondPlayer, HashMap<UUID, Location> playerLocations, HashMap<UUID, Specializations> playerClasses, HashMap<UUID, HashMap<Specializations, SkillBoosts>> playerBoosts, HashMap<UUID, HashMap<Specializations, Weapons>> playerWeaponSkins, HashMap<UUID, List<ArmorManager.Helmets>> playerHelmets, HashMap<UUID, List<ArmorManager.ArmorSets>> playerArmorSets, HashMap<UUID, Boolean> playerOnHorse) {
        System.out.println("SWAP - " + firstPlayer.getName() + " <<< " + secondPlayer.getName());
        UUID firstPlayerUuid = firstPlayer.getUuid();
        firstPlayer.setName(secondPlayer.getName());
        firstPlayer.setUuid(secondPlayer.getUuid());
        secondPlayer.teleport(playerLocations.get(firstPlayerUuid));
        firstPlayer.setEntity(secondPlayer.getEntity());
        if (playerOnHorse.get(firstPlayerUuid).booleanValue()) {
            firstPlayer.getHorse().spawn();
        }
        if (firstPlayer.getEntity() instanceof Player) {
            PacketUtils.sendTitle((Player)firstPlayer.getEntity(), ChatColor.YELLOW + "Swapped to", ChatColor.GREEN.toString() + ChatColor.MAGIC + "00" + ChatColor.GREEN + " " + firstPlayer.getSpecClass().name + "! " + ChatColor.MAGIC + "00", 10, 40, 10);
        }
        PlayerSettings playerSettings = Warlords.getPlayerSettings(secondPlayer.getUuid());
        playerSettings.setSelectedSpec(playerClasses.get(firstPlayerUuid));
        playerSettings.setWeaponSkins(playerWeaponSkins.get(firstPlayerUuid));
        playerSettings.setSpecsSkillBoosts(playerBoosts.get(firstPlayerUuid));
        playerSettings.setHelmets(playerHelmets.get(firstPlayerUuid));
        playerSettings.setArmorSets(playerArmorSets.get(firstPlayerUuid));
        if (firstPlayer.getEntity() instanceof Player) {
            firstPlayer.updatePlayer((Player)firstPlayer.getEntity());
        }
        Warlords.getPlayers().put(secondPlayer.getUuid(), firstPlayer);
    }

    private void generateNextSwapTime() {
        this.secondsUntilNextSwap = new Random().nextInt(30) + 50;
        System.out.println("Swapping in " + this.secondsUntilNextSwap + " seconds");
    }
}

