/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.effects.EffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.events.WarlordsIntersectionCaptureEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.CompassTargetMarker;
import com.ebicep.warlords.game.option.marker.DebugLocationMarker;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.option.marker.scoreboard.SimpleScoreboardHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class InterceptionPointOption
implements Option {
    private static final ItemStack NEUTRAL_ITEM_STACK = new ItemStack(Material.WOOL);
    public static final double DEFAULT_MIN_CAPTURE_RADIUS = 3.0;
    public static final double DEFAULT_MAX_CAPTURE_RADIUS = 6.0;
    public static final double DEFAULT_CAPTURE_SPEED = 0.01;
    private Game game;
    @Nonnull
    private String name;
    private final Location location;
    @Nonnegative
    private double minCaptureRadius;
    @Nonnegative
    private double maxCaptureRadius;
    private Team teamOwning = null;
    private Team teamAttacking = null;
    private Team teamInCircle = null;
    @Nonnegative
    private double captureProgress = 0.0;
    private boolean inConflict = false;
    private double captureSpeed;
    private SimpleScoreboardHandler scoreboard;
    private ArmorStand[] middle = new ArmorStand[4];
    @Nullable
    private CircleEffect effectPlayer;

    public InterceptionPointOption(String name, Location location) {
        this(name, location, 3.0, 6.0, 0.01);
    }

    public InterceptionPointOption(String name, Location location, @Nonnegative double minCaptureRadius) {
        this(name, location, minCaptureRadius, minCaptureRadius * 2.0, 0.01);
    }

    public InterceptionPointOption(String name, Location location, @Nonnegative double minCaptureRadius, @Nonnegative double maxCaptureRadius, @Nonnegative double captureSpeed) {
        this.name = name;
        this.location = location;
        this.maxCaptureRadius = maxCaptureRadius;
        this.minCaptureRadius = minCaptureRadius;
        this.captureSpeed = captureSpeed;
    }

    @Override
    public void register(Game game) {
        this.game = game;
        game.registerGameMarker(CompassTargetMarker.class, new CompassTargetMarker(){

            @Override
            public int getCompassTargetPriority(WarlordsPlayer player) {
                return (int)player.getDeathLocation().distanceSquared(InterceptionPointOption.this.location) / -100;
            }

            @Override
            public String getToolbarName(WarlordsPlayer player) {
                StringBuilder status = new StringBuilder();
                if (InterceptionPointOption.this.teamAttacking == null) {
                    status.append(ChatColor.GRAY);
                } else {
                    status.append(InterceptionPointOption.this.teamAttacking.teamColor());
                }
                status.append(InterceptionPointOption.this.name);
                status.append(" ");
                if (InterceptionPointOption.this.teamInCircle == null) {
                    status.append(ChatColor.GRAY);
                } else {
                    status.append(InterceptionPointOption.this.teamInCircle.teamColor());
                }
                status.append((int)Math.floor(InterceptionPointOption.this.captureProgress * 100.0)).append("%");
                status.append(ChatColor.WHITE).append(" - ");
                if (InterceptionPointOption.this.inConflict) {
                    status.append(ChatColor.GOLD).append("In conflict");
                } else if (InterceptionPointOption.this.teamOwning != player.getTeam()) {
                    if (InterceptionPointOption.this.teamInCircle != player.getTeam()) {
                        status.append(ChatColor.RED).append("Not under your control!");
                    } else {
                        status.append(ChatColor.AQUA).append("Your team is capturing this");
                    }
                } else if (InterceptionPointOption.this.teamInCircle != player.getTeam()) {
                    status.append(ChatColor.RED).append("Point is under attack!");
                } else {
                    status.append(ChatColor.GREEN).append("Safe");
                }
                return status.toString();
            }

            @Override
            public Location getLocation() {
                return InterceptionPointOption.this.location;
            }
        });
        game.registerGameMarker(DebugLocationMarker.class, DebugLocationMarker.create(Material.TORCH, 0, this.getClass(), "Capture point: " + this.name, () -> this.location, () -> Arrays.asList("inConflict: " + this.inConflict, "teamOwning: " + (Object)((Object)this.teamOwning), "teamAttacking: " + (Object)((Object)this.teamAttacking), "teamInCircle: " + (Object)((Object)this.teamInCircle), "minCaptureRadius: " + this.minCaptureRadius, "maxCaptureRadius: " + this.maxCaptureRadius, "radius: " + this.computeCurrentRadius())));
        this.scoreboard = new SimpleScoreboardHandler(19, "interception"){

            @Override
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                StringBuilder status = new StringBuilder();
                if (InterceptionPointOption.this.teamAttacking == null) {
                    status.append(ChatColor.GRAY);
                } else {
                    status.append(InterceptionPointOption.this.teamAttacking.teamColor());
                }
                status.append(InterceptionPointOption.this.name);
                status.append(ChatColor.WHITE);
                status.append(": ");
                if (InterceptionPointOption.this.teamInCircle == null) {
                    status.append(ChatColor.GRAY);
                } else {
                    status.append(InterceptionPointOption.this.teamInCircle.teamColor());
                }
                status.append((int)Math.floor(InterceptionPointOption.this.captureProgress * 100.0)).append("%");
                return Collections.singletonList(status.toString());
            }
        };
        game.registerGameMarker(ScoreboardHandler.class, this.scoreboard);
    }

    private ItemStack getItem(Team team) {
        return team == null ? NEUTRAL_ITEM_STACK : team.getItem();
    }

    private void updateArmorstandsAndEffect(ScoreboardHandler handler) {
        Location clone = this.location.clone();
        clone.add(0.0, -1.7, 0.0);
        for (int i = this.middle.length - 1; i >= 0; --i) {
            clone.add(0.0, this.captureProgress * 1.0 + 0.25, 0.0);
            this.middle[i].teleport(clone);
            ItemStack item = this.getItem((Team)((Object)(i == 0 ? (this.inConflict ? null : this.teamAttacking) : this.teamOwning)));
            if (item.equals((Object)this.middle[i].getHelmet())) continue;
            this.middle[i].setHelmet(item);
        }
        double computedCurrentRadius = this.computeCurrentRadius();
        if (this.effectPlayer == null || this.effectPlayer.getTeam() != this.teamOwning) {
            this.effectPlayer = new CircleEffect(this.game, this.teamOwning, this.location, computedCurrentRadius, new EffectPlayer[0]);
            this.effectPlayer.addEffect(new CircumferenceEffect(ParticleEffect.CRIT).particles(20.0));
        }
        if (this.effectPlayer.getRadius() != computedCurrentRadius) {
            this.effectPlayer.setRadius(computedCurrentRadius);
        }
    }

    @Override
    public void start(Game game) {
        Location clone = this.location.clone();
        clone.add(0.0, -1.7, 0.0);
        for (int i = this.middle.length - 1; i >= 0; --i) {
            clone.add(0.0, this.captureProgress * 1.0 + 0.25, 0.0);
            this.middle[i] = (ArmorStand)this.location.getWorld().spawn(clone, ArmorStand.class);
            this.middle[i].setGravity(false);
            this.middle[i].setBasePlate(false);
            this.middle[i].setArms(false);
            this.middle[i].setVisible(false);
        }
        this.updateArmorstandsAndEffect(null);
        this.scoreboard.registerChangeHandler(this::updateArmorstandsAndEffect);
        new GameRunnable(game){

            @Override
            public void run() {
                Stream<WarlordsPlayer> computePlayers = InterceptionPointOption.this.computePlayers();
                double speed = InterceptionPointOption.this.updateTeamInCircle(computePlayers);
                InterceptionPointOption.this.updateTeamHackProcess(speed);
                if (InterceptionPointOption.this.effectPlayer != null) {
                    InterceptionPointOption.this.effectPlayer.playEffects();
                }
            }
        }.runTaskTimer(1L, 1L);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getLocation() {
        return this.location;
    }

    public double getMinCaptureRadius() {
        return this.minCaptureRadius;
    }

    public void setMinCaptureRadius(double minCaptureRadius) {
        this.minCaptureRadius = minCaptureRadius;
    }

    public double getMaxCaptureRadius() {
        return this.maxCaptureRadius;
    }

    public void setMaxCaptureRadius(double maxCaptureRadius) {
        this.maxCaptureRadius = maxCaptureRadius;
    }

    public double getCaptureSpeed() {
        return this.captureSpeed;
    }

    public void setCaptureSpeed(double captureSpeed) {
        this.captureSpeed = captureSpeed;
    }

    public Team getTeamOwning() {
        return this.teamOwning;
    }

    public Team getTeamAttacking() {
        return this.teamAttacking;
    }

    public Team getTeamInCircle() {
        return this.teamInCircle;
    }

    public boolean isInConflict() {
        return this.inConflict;
    }

    public Game getGame() {
        return this.game;
    }

    protected double computeCurrentRadius() {
        return this.minCaptureRadius + this.captureProgress * (this.maxCaptureRadius - this.minCaptureRadius);
    }

    protected Stream<WarlordsPlayer> computePlayers() {
        double radius = this.computeCurrentRadius();
        return PlayerFilter.entitiesAround(this.location, radius, radius, radius).stream().filter(wp -> wp.getGame() == this.game && wp.isAlive());
    }

    protected double updateTeamInCircle(Stream<WarlordsPlayer> players) {
        int otherTeamPresence;
        Map perTeam = players.collect(Collectors.groupingBy(WarlordsPlayer::getTeam, Collectors.toList()));
        if (perTeam.isEmpty()) {
            this.teamInCircle = this.teamOwning;
            this.inConflict = false;
            return this.captureSpeed * 0.2;
        }
        Map.Entry highest = perTeam.entrySet().stream().sorted(Comparator.comparing(e -> ((List)e.getValue()).size()).reversed()).findFirst().get();
        int highestValue = ((List)highest.getValue()).size();
        int currentTeamPresence = highestValue - (otherTeamPresence = perTeam.values().stream().mapToInt(Collection::size).sum() - highestValue);
        if (currentTeamPresence > 1 || otherTeamPresence == 0) {
            this.teamInCircle = (Team)((Object)highest.getKey());
            this.inConflict = false;
        } else {
            this.teamInCircle = null;
            this.inConflict = true;
        }
        return Math.max((double)(currentTeamPresence - 1) * this.captureSpeed, this.captureSpeed);
    }

    protected void updateTeamHackProcess(double hackSpeed) {
        if (this.inConflict || hackSpeed <= 0.0) {
            return;
        }
        if (this.teamAttacking != this.teamInCircle) {
            this.captureProgress -= hackSpeed;
            if (this.captureProgress < 0.0) {
                this.captureProgress = 0.0;
                Team previousOwning = this.teamOwning;
                this.teamOwning = null;
                this.teamAttacking = this.teamInCircle;
                Bukkit.getPluginManager().callEvent((Event)new WarlordsIntersectionCaptureEvent(this));
                if (previousOwning != null) {
                    WarlordsPlayer capturer = (WarlordsPlayer)this.computePlayers().filter(wp -> wp.getTeam() == this.teamInCircle).collect(Utils.randomElement());
                    String message = this.teamAttacking.teamColor() + (capturer == null ? "???" : capturer.getName()) + " \u00a7eis capturing the " + ChatColor.GRAY + this.name + ChatColor.WHITE + "!";
                    this.game.forEachOnlinePlayer((p, t2) -> {
                        p.sendMessage(message);
                        PacketUtils.sendTitle(p, "", message, 0, 60, 0);
                        if (t2 != null) {
                            if (t2 != this.teamOwning) {
                                p.playSound(this.location, "ctf.friendlyflagtaken", 500.0f, 1.0f);
                            } else {
                                p.playSound(this.location, "ctf.enemyflagtaken", 500.0f, 1.0f);
                            }
                        }
                    });
                }
            }
            this.scoreboard.markChanged();
        } else if (this.teamInCircle != null) {
            if (this.captureProgress < 1.0) {
                this.captureProgress += hackSpeed;
                if (this.captureProgress > 1.0) {
                    this.captureProgress = 1.0;
                    if (this.teamAttacking != this.teamOwning) {
                        this.teamOwning = this.teamAttacking;
                        Bukkit.getPluginManager().callEvent((Event)new WarlordsIntersectionCaptureEvent(this));
                        WarlordsPlayer capturer = (WarlordsPlayer)this.computePlayers().filter(wp -> wp.getTeam() == this.teamOwning).collect(Utils.randomElement());
                        String message = this.teamOwning.teamColor() + (capturer == null ? "???" : capturer.getName()) + " \u00a7ehas captured the " + this.teamOwning.teamColor() + this.name + ChatColor.WHITE + "!";
                        this.game.forEachOnlinePlayer((p, t2) -> {
                            p.sendMessage(message);
                            PacketUtils.sendTitle(p, "", message, 0, 60, 0);
                            if (t2 != null) {
                                if (t2 != this.teamOwning) {
                                    p.playSound(this.location, "ctf.enemycapturedtheflag", 500.0f, 1.0f);
                                } else {
                                    p.playSound(this.location, "ctf.enemyflagcaptured", 500.0f, 1.0f);
                                }
                            }
                        });
                    }
                }
            }
            this.scoreboard.markChanged();
        }
    }
}

