/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.WinByPointsOption;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.option.marker.scoreboard.SimpleScoreboardHandler;
import com.ebicep.warlords.game.state.PlayingState;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.poll.polls.GamePoll;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class ImposterModeOption
implements Option {
    private final int numberOfImpostersPerTeam = 1;
    private final HashMap<Team, List<WarlordsPlayer>> imposters = new HashMap();
    private final HashMap<Team, List<WarlordsPlayer>> voters = new HashMap();
    private Game game;
    private GamePoll poll;

    @Override
    public void register(@Nonnull Game game) {
        this.game = game;
        for (Team team : TeamMarker.getTeams(game)) {
            this.imposters.put(team, new ArrayList());
        }
        game.registerGameMarker(ScoreboardHandler.class, new SimpleScoreboardHandler(30, "imposter"){

            @Override
            public List<String> computeLines(@Nullable WarlordsPlayer warlordsPlayer) {
                if (warlordsPlayer == null) {
                    return Collections.emptyList();
                }
                if (((List)ImposterModeOption.this.imposters.get((Object)warlordsPlayer.getTeam())).isEmpty()) {
                    return Collections.emptyList();
                }
                if (ImposterModeOption.this.imposters.entrySet().stream().anyMatch(teamListEntry -> ((List)teamListEntry.getValue()).contains(warlordsPlayer))) {
                    return Collections.singletonList(ChatColor.WHITE + "Role: " + ChatColor.RED + "Imposter");
                }
                return Collections.singletonList(ChatColor.WHITE + "Role: " + ChatColor.GREEN + "Innocent");
            }
        });
    }

    @Override
    public void start(final @Nonnull Game game) {
        new GameRunnable(game){
            int counter;
            {
                super(game3);
                this.counter = 0;
            }

            @Override
            public void run() {
                if (this.counter == 4) {
                    ImposterModeOption.this.assignImposters(game);
                }
                game.onlinePlayersWithoutSpectators().forEach(playerTeamEntry -> {
                    Player player = (Player)playerTeamEntry.getKey();
                    Team team = (Team)((Object)((Object)playerTeamEntry.getValue()));
                    String title = "";
                    switch (this.counter) {
                        case 0: {
                            title = ChatColor.GREEN + "3";
                            break;
                        }
                        case 1: {
                            title = ChatColor.YELLOW + "2";
                            break;
                        }
                        case 2: {
                            title = ChatColor.RED + "1";
                            break;
                        }
                        case 3: {
                            title = ChatColor.YELLOW + "You are...";
                            break;
                        }
                        case 4: {
                            if (((List)ImposterModeOption.this.imposters.get((Object)team)).contains(Warlords.getPlayer(player))) {
                                title = ChatColor.RED + "The IMPOSTER";
                                ChatUtils.sendMessageToPlayer(player, ChatColor.RED + "You are the IMPOSTER", ChatColor.BLUE, true);
                                break;
                            }
                            title = ChatColor.GREEN + "INNOCENT";
                            ChatUtils.sendMessageToPlayer(player, ChatColor.GREEN + "You are INNOCENT", ChatColor.BLUE, true);
                        }
                    }
                    PacketUtils.sendTitle(player, title, "", 0, 100, 40);
                });
                ++this.counter;
                if (this.counter == 5) {
                    this.cancel();
                }
            }
        }.runTaskTimer(240L, 20L);
    }

    private void assignImposters(Game game) {
        for (Team team : TeamMarker.getTeams(game)) {
            List teamPlayers = game.warlordsPlayers().filter(warlordsPlayer -> warlordsPlayer.getTeam() == team).collect(Collectors.toList());
            if (teamPlayers.size() == 0) continue;
            for (int i = 0; i < 1; ++i) {
                this.imposters.get((Object)team).add((WarlordsPlayer)teamPlayers.get(new Random().nextInt(teamPlayers.size())));
            }
        }
        System.out.println(" --- Assigned Imposters --- ");
        for (Team team : TeamMarker.getTeams(game)) {
            System.out.println(team.name + " - " + this.imposters.get((Object)team).stream().map(WarlordsPlayer::getName).collect(Collectors.joining(", ")));
        }
    }

    public void sendPoll(final Team team) {
        this.poll = (GamePoll)((GamePoll.Builder)((GamePoll.Builder)((GamePoll.Builder)((GamePoll.Builder)((GamePoll.Builder)new GamePoll.Builder(this.game).setQuestion("Who is the most SUS on your team?")).setTimeLeft(60)).setOptions(this.game.offlinePlayersWithoutSpectators().filter(uuidTeamEntry -> uuidTeamEntry.getValue() == team).map(offlinePlayerTeamEntry -> ((OfflinePlayer)offlinePlayerTeamEntry.getKey()).getName()).collect(Collectors.toList()))).setExcludedPlayers(this.game.offlinePlayersWithoutSpectators().filter(uuidTeamEntry -> uuidTeamEntry.getValue() != team).map(offlinePlayerTeamEntry -> ((OfflinePlayer)offlinePlayerTeamEntry.getKey()).getUniqueId()).collect(Collectors.toList()))).setRunnableAfterPollEnded(p -> {
            int mostVotes = (Integer)Collections.max(p.getOptionsWithVotes().entrySet(), Comparator.comparingInt(Map.Entry::getValue)).getValue();
            List votedOut = p.getOptionsWithVotes().entrySet().stream().filter(stringIntegerEntry -> (Integer)stringIntegerEntry.getValue() == mostVotes).map(Map.Entry::getKey).map(s2 -> this.game.warlordsPlayers().filter(warlordsPlayer -> warlordsPlayer.getName().equals(s2)).findFirst().get()).collect(Collectors.toList());
            final boolean votedCorrectly = votedOut.size() == 1 && this.imposters.get((Object)team).stream().anyMatch(warlordsPlayer -> warlordsPlayer == votedOut.get(0));
            new GameRunnable(this.game, true){
                int counter;
                {
                    super(game, runInPauseMode);
                    this.counter = 0;
                }

                @Override
                public void run() {
                    String title = "";
                    String subtitle = "";
                    switch (this.counter) {
                        case 0: 
                        case 1: {
                            title = team.teamColor + team.name + " voted...";
                            break;
                        }
                        case 2: 
                        case 3: {
                            title = votedCorrectly ? ChatColor.GREEN + "Correctly!" : ChatColor.RED + "Incorrectly!";
                            subtitle = team.teamColor + ((WarlordsPlayer)((List)ImposterModeOption.this.imposters.get((Object)team)).get(0)).getName() + ChatColor.YELLOW + " was the imposter";
                        }
                    }
                    ++this.counter;
                    if (this.counter < 6) {
                        ImposterModeOption.this.sendTitle(title, subtitle);
                    } else if (this.counter == 6) {
                        ImposterModeOption.this.game.onlinePlayersWithoutSpectators().forEach(playerTeamEntry -> {
                            Player player = (Player)playerTeamEntry.getKey();
                            player.removePotionEffect(PotionEffectType.BLINDNESS);
                            ImposterModeOption.this.showWinLossMessage(team, player, votedCorrectly, playerTeamEntry.getValue() == team);
                        });
                    } else if (this.counter == 9) {
                        ImposterModeOption.this.game.removeFrozenCause(team.teamColor + team.name + ChatColor.GREEN + " is voting!");
                        int scoreNeededToEndGame = ImposterModeOption.this.game.getOptions().stream().filter(e -> e instanceof WinByPointsOption).mapToInt(e -> ((WinByPointsOption)e).getPointLimit()).sorted().findFirst().orElse(Integer.MAX_VALUE);
                        if (votedCorrectly) {
                            ImposterModeOption.this.game.setPoints(team, scoreNeededToEndGame);
                        } else {
                            ImposterModeOption.this.game.setPoints(TeamMarker.getTeams(ImposterModeOption.this.game).stream().filter(t2 -> t2 != team).min(Comparator.comparingInt(o -> ImposterModeOption.this.game.getPoints((Team)((Object)o)))).get(), scoreNeededToEndGame);
                        }
                        ((PlayingState)ImposterModeOption.this.game.getState()).skipTimer();
                        ImposterModeOption.this.game.onlinePlayers().forEach(playerTeamEntry -> {
                            Player player = (Player)playerTeamEntry.getKey();
                            ImposterModeOption.this.sendImpostorResult(player);
                        });
                        this.cancel();
                    }
                }
            }.runTaskTimer(10L, 20L);
        })).get();
    }

    private void showWinLossMessage(Team team, Player player, boolean votedCorrectly, boolean sameTeam) {
        if (sameTeam) {
            if (votedCorrectly && this.imposters.get((Object)team).stream().noneMatch(warlordsPlayer -> warlordsPlayer.getName().equalsIgnoreCase(player.getName())) || !votedCorrectly && this.imposters.get((Object)team).stream().anyMatch(warlordsPlayer -> warlordsPlayer.getName().equalsIgnoreCase(player.getName()))) {
                PacketUtils.sendTitle(player, ChatColor.GREEN + "YOU WON!", "", 0, 300, 40);
                ChatUtils.sendMessageToPlayer(player, ChatColor.GREEN + "You won!", ChatColor.BLUE, true);
            } else {
                PacketUtils.sendTitle(player, ChatColor.RED + "YOU LOST!", "", 0, 300, 40);
                ChatUtils.sendMessageToPlayer(player, ChatColor.RED + "You lost!", ChatColor.BLUE, true);
            }
        } else {
            boolean isAnImposterOnOtherTeam = false;
            block0: for (Map.Entry teamListEntry2 : this.imposters.entrySet().stream().filter(teamListEntry -> teamListEntry.getKey() != team).collect(Collectors.toList())) {
                for (WarlordsPlayer warlordsPlayer2 : (List)teamListEntry2.getValue()) {
                    if (!warlordsPlayer2.getName().equalsIgnoreCase(player.getName())) continue;
                    isAnImposterOnOtherTeam = true;
                    continue block0;
                }
            }
            if (votedCorrectly && !isAnImposterOnOtherTeam) {
                PacketUtils.sendTitle(player, ChatColor.RED + "YOU LOST!", "", 0, 300, 40);
                ChatUtils.sendMessageToPlayer(player, ChatColor.RED + "You lost!", ChatColor.BLUE, true);
            } else {
                PacketUtils.sendTitle(player, ChatColor.GREEN + "YOU WON!", "", 0, 300, 40);
                ChatUtils.sendMessageToPlayer(player, ChatColor.GREEN + "You won!", ChatColor.BLUE, true);
            }
        }
    }

    private void sendImpostorResult(Player player) {
        StringBuilder message = new StringBuilder();
        this.imposters.forEach((team, warlordsPlayers) -> {
            if (warlordsPlayers.size() == 1) {
                message.append(ChatColor.GREEN).append("The ").append(team.teamColor).append(team.name).append(ChatColor.GREEN).append(" imposter was ").append(ChatColor.AQUA).append(warlordsPlayers.stream().map(WarlordsPlayer::getName).collect(Collectors.joining(", "))).append("\n");
            } else if (warlordsPlayers.size() > 1) {
                message.append(ChatColor.GREEN).append("The ").append(team.teamColor).append(team.name).append(ChatColor.GREEN).append(" imposters were ").append(ChatColor.AQUA).append(warlordsPlayers.stream().map(WarlordsPlayer::getName).collect(Collectors.joining(", "))).append("\n");
            }
        });
        message.setLength(message.length() - 1);
        ChatUtils.sendMessageToPlayer(player, message.toString(), ChatColor.BLUE, true);
    }

    private void sendTitle(String title, String subtitle) {
        this.game.onlinePlayers().forEach(playerTeamEntry -> PacketUtils.sendTitle((Player)playerTeamEntry.getKey(), title, subtitle, 0, 150, 40));
    }

    public int getNumberOfImpostersPerTeam() {
        return 1;
    }

    public HashMap<Team, List<WarlordsPlayer>> getImposters() {
        return this.imposters;
    }

    public HashMap<Team, List<WarlordsPlayer>> getVoters() {
        return this.voters;
    }

    public GamePoll getPoll() {
        return this.poll;
    }

    public void setPoll(GamePoll poll) {
        this.poll = poll;
    }
}

