/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsDeathEvent;
import com.ebicep.warlords.events.WarlordsRespawnEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class GraveOption
implements Option,
Listener {
    public static final Material DEFAULT_GRAVE_MATERIAL = Material.SAPLING;
    public static final byte DEFAULT_GRAVE_MATERIAL_DATA = 5;
    public static final Function<WarlordsPlayer, String> DEFAULT_GRAVE_TEXT = wp -> wp.getTeam().teamColor() + wp.getName() + ChatColor.GRAY + " - " + ChatColor.YELLOW + "DEAD";
    private final List<Grave> graves = new LinkedList<Grave>();
    private Material material;
    private byte data;
    private Function<WarlordsPlayer, String> graveName;
    private boolean activated = true;

    public GraveOption() {
        this(DEFAULT_GRAVE_MATERIAL, 5, DEFAULT_GRAVE_TEXT);
    }

    public GraveOption(Function<WarlordsPlayer, String> graveName) {
        this(DEFAULT_GRAVE_MATERIAL, 5, graveName);
    }

    public GraveOption(Material material) {
        this(material, 0, DEFAULT_GRAVE_TEXT);
    }

    public GraveOption(Material material, byte data) {
        this(material, data, DEFAULT_GRAVE_TEXT);
    }

    public GraveOption(Material material, byte data, Function<WarlordsPlayer, String> graveName) {
        this.material = Objects.requireNonNull(material, "material");
        this.data = data;
        this.graveName = Objects.requireNonNull(graveName, "graveName");
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = Objects.requireNonNull(material, "material");
    }

    public byte getData() {
        return this.data;
    }

    public void setData(byte data) {
        this.data = data;
    }

    public Function<WarlordsPlayer, String> getGraveName() {
        return this.graveName;
    }

    public void setGraveName(Function<WarlordsPlayer, String> graveName) {
        this.graveName = Objects.requireNonNull(graveName, "graveName");
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    @Override
    public void register(Game game) {
        game.registerEvents(this);
    }

    @Override
    public void onGameCleanup(Game game) {
        this.activated = false;
        for (Grave grave : this.graves) {
            grave.remove();
        }
        this.graves.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEvent(WarlordsDeathEvent event) {
        this.addGrave(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEvent(WarlordsRespawnEvent event) {
        Iterator<Grave> it = this.graves.iterator();
        while (it.hasNext()) {
            Grave grave = it.next();
            if (grave.getOwner() != event.getPlayer()) continue;
            grave.remove();
            it.remove();
        }
    }

    public void addGrave(WarlordsPlayer player) {
        if (!this.activated) {
            return;
        }
        Location deathLocation = player.getLocation();
        Block bestGraveCandidate = null;
        boolean isFlagCarrier = player.getCarriedFlag() != null;
        for (int x = -1; x <= 1; ++x) {
            block1: for (int z = -1; z <= 1; ++z) {
                Location toTest;
                Block lastBlock;
                if (isFlagCarrier && x == 0 && z == 0 || (lastBlock = (toTest = deathLocation.clone().add((double)x, 2.0, (double)z)).getBlock()).getType() != Material.AIR) continue;
                toTest.subtract(0.0, 1.0, 0.0);
                while (toTest.getY() > 0.0) {
                    Block underTest = toTest.getBlock();
                    if (underTest.getType() != Material.AIR) {
                        double existingDistance;
                        double newDistance;
                        if (underTest.getType().isTransparent() || underTest.getType() == Material.STANDING_BANNER || underTest.getType() == Material.BANNER) continue block1;
                        toTest.add(0.0, 1.0, 0.0);
                        if (bestGraveCandidate != null && (newDistance = toTest.distanceSquared(deathLocation)) >= (existingDistance = bestGraveCandidate.getLocation(toTest).distanceSquared(deathLocation))) continue block1;
                        bestGraveCandidate = lastBlock;
                        continue block1;
                    }
                    lastBlock = underTest;
                    toTest.subtract(0.0, 1.0, 0.0);
                }
            }
        }
        if (bestGraveCandidate != null) {
            bestGraveCandidate.setType(this.material);
            bestGraveCandidate.setData(this.data);
            ArmorStand deathStand = (ArmorStand)player.getWorld().spawnEntity(bestGraveCandidate.getLocation().add(0.5, -1.5, 0.5), EntityType.ARMOR_STAND);
            String name = this.graveName.apply(player);
            if (name != null) {
                deathStand.setCustomName(name);
                deathStand.setCustomNameVisible(true);
            }
            deathStand.setGravity(false);
            deathStand.setVisible(false);
            this.graves.add(new Grave(player, deathStand, bestGraveCandidate, this.material, this.data));
        }
    }

    private static class Grave {
        private final WarlordsPlayer owner;
        private final ArmorStand armorStand;
        private final Block block;
        private final Material material;
        private final byte data;

        public Grave(WarlordsPlayer owner, ArmorStand armorStand, Block location, Material material, byte data) {
            this.owner = owner;
            this.armorStand = armorStand;
            this.block = location;
            this.material = material;
            this.data = data;
        }

        public WarlordsPlayer getOwner() {
            return this.owner;
        }

        public void remove() {
            Block deathBlock = this.block;
            if (deathBlock.getType() == this.material && deathBlock.getData() == this.data) {
                deathBlock.setType(Material.AIR);
            }
            this.armorStand.remove();
        }
    }
}

