/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.AbstractCuboidOption;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.DebugLocationMarker;
import com.ebicep.warlords.game.option.marker.TimerSkipAbleMarker;
import com.ebicep.warlords.util.bukkit.LocationFactory;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GateOption
extends AbstractCuboidOption
implements TimerSkipAbleMarker {
    public static final int DEFAULT_GATE_DELAY = 10;
    public static final Material DEFAULT_OPEN_MATERIAL = Material.AIR;
    public static final Material DEFAULT_CLOSED_MATERIAL = Material.FENCE;
    public static final Boolean DEFAULT_SHOULD_BROADCAST = null;
    private final Material closed;
    private final Material open;
    private boolean autoDetectShouldBroadcast = true;
    private boolean shouldBroadcast;
    private int delay;
    @Nonnull
    private Game game;

    public GateOption(Location a, Location b) {
        this(a, b, DEFAULT_CLOSED_MATERIAL, DEFAULT_OPEN_MATERIAL, 10, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(Location a, Location b, Material closed) {
        this(a, b, closed, DEFAULT_OPEN_MATERIAL, 10, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(Location a, Location b, Material closed, Material open) {
        this(a, b, closed, open, 10, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(Location a, Location b, Material closed, Material open, int delay) {
        this(a, b, closed, open, delay, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(Location a, Location b, Material closed, Material open, int delay, Boolean shouldBroadcast) {
        super(a, b);
        if (closed == open) {
            throw new IllegalArgumentException("Cannot have the closed and open material of a gate be the same material");
        }
        this.closed = closed;
        this.open = open;
        this.delay = delay;
    }

    public GateOption(LocationFactory loc, double x1, double y1, double z1, double x2, double y2, double z2) {
        this(loc, x1, y1, z1, x2, y2, z2, DEFAULT_CLOSED_MATERIAL, DEFAULT_OPEN_MATERIAL, 10, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(LocationFactory loc, double x1, double y1, double z1, double x2, double y2, double z2, Material closed) {
        this(loc, x1, y1, z1, x2, y2, z2, closed, DEFAULT_OPEN_MATERIAL, 10, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(LocationFactory loc, double x1, double y1, double z1, double x2, double y2, double z2, Material closed, Material open) {
        this(loc, x1, y1, z1, x2, y2, z2, closed, open, 10, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(LocationFactory loc, double x1, double y1, double z1, double x2, double y2, double z2, Material closed, Material open, int delay) {
        this(loc, x1, y1, z1, x2, y2, z2, closed, open, delay, DEFAULT_SHOULD_BROADCAST);
    }

    public GateOption(LocationFactory loc, double x1, double y1, double z1, double x2, double y2, double z2, Material closed, Material open, int delay, Boolean shouldBroadcast) {
        super(loc, x1, y1, z1, x2, y2, z2);
        if (closed == open) {
            throw new IllegalArgumentException("Cannot have the closed and open material of a gate be the same material");
        }
        this.closed = closed;
        this.open = open;
        this.delay = delay;
    }

    protected int changeGate(Material search, Material replace) {
        int changed = 0;
        for (int x = this.min.getBlockX(); x <= this.max.getBlockX(); ++x) {
            for (int z = this.min.getBlockZ(); z <= this.max.getBlockZ(); ++z) {
                for (int y = this.min.getBlockY(); y <= this.max.getBlockY(); ++y) {
                    Block block;
                    if (x != this.min.getBlockX() && x != this.max.getBlockX() && y != this.min.getBlockY() && y != this.max.getBlockY() && z != this.min.getBlockZ() && z != this.max.getBlockZ() || (block = this.min.getWorld().getBlockAt(x, y, z)).getType() != search) continue;
                    block.setType(replace);
                    ++changed;
                }
            }
        }
        return changed;
    }

    @Override
    public void register(Game game) {
        this.changeGate(this.open, this.closed);
        this.game = game;
        game.registerGameMarker(TimerSkipAbleMarker.class, this);
        game.registerGameMarker(DebugLocationMarker.class, DebugLocationMarker.create(Material.FENCE_GATE, 0, this.getClass(), "Gates", new Location(this.min.getWorld(), (this.min.getX() + this.max.getX()) / 2.0, (this.min.getY() + this.max.getY()) / 2.0, (this.min.getZ() + this.max.getZ()) / 2.0), () -> Arrays.asList("MIN: " + this.min.getX() + ", " + this.min.getY() + ", " + this.min.getZ(), "MAX: " + this.max.getX() + ", " + this.max.getY() + ", " + this.max.getZ())));
    }

    public void openGates() {
        this.delay = -1;
        this.changeGate(this.closed, this.open);
        if (this.shouldBroadcast) {
            for (Map.Entry<Player, Team> entry : Utils.iterable(this.game.onlinePlayersWithoutSpectators())) {
                Player player = entry.getKey();
                player.playSound(player.getLocation(), Sound.WITHER_SPAWN, 5.0f, 1.0f);
                ChatUtils.sendMessage(player, false, ChatColor.YELLOW + "Gates opened! " + ChatColor.RED + "FIGHT!");
                Utils.resetPlayerMovementStatistics(player);
            }
        }
    }

    @Override
    public int getDelay() {
        return this.delay * 20;
    }

    @Override
    public void skipTimer(int delay) {
        if (this.delay > 0) {
            this.delay -= delay / 20;
            if (delay <= 0) {
                this.openGates();
            }
        }
    }

    @Override
    public void start(final @Nonnull Game game) {
        if (this.autoDetectShouldBroadcast) {
            for (Option option : game.getOptions()) {
                GateOption gateOption;
                if (!(option instanceof GateOption) || (gateOption = (GateOption)option).getDelay() != this.getDelay()) continue;
                this.shouldBroadcast = option == this;
                break;
            }
        }
        new GameRunnable(game){

            @Override
            public void run() {
                if (GateOption.this.delay < 0) {
                    this.cancel();
                    return;
                }
                if (GateOption.this.delay == 0) {
                    GateOption.this.openGates();
                    this.cancel();
                }
                if (GateOption.this.shouldBroadcast) {
                    Player player;
                    for (Map.Entry<Player, Team> entry : Utils.iterable(game.onlinePlayersWithoutSpectators())) {
                        player = entry.getKey();
                        player.playSound(player.getLocation(), GateOption.this.delay == 0 ? Sound.WITHER_SPAWN : Sound.NOTE_STICKS, 1.0f, 1.0f);
                        String number = (GateOption.this.delay >= 8 ? ChatColor.GREEN : (GateOption.this.delay >= 4 ? ChatColor.YELLOW : ChatColor.RED)).toString() + GateOption.this.delay;
                        if (GateOption.this.delay <= 0) continue;
                        PacketUtils.sendTitle(player, number, "", 0, 40, 0);
                    }
                    switch (GateOption.this.delay) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 10: {
                            for (Map.Entry<Player, Team> entry : Utils.iterable(game.onlinePlayersWithoutSpectators())) {
                                player = entry.getKey();
                                String s2 = GateOption.this.delay == 1 ? "" : "s";
                                ChatUtils.sendMessage(player, false, ChatColor.YELLOW + "The gates will fall in " + ChatColor.RED + GateOption.this.delay + ChatColor.YELLOW + " second" + s2 + "!");
                            }
                            break;
                        }
                    }
                }
                GateOption.this.delay--;
            }
        }.runTaskTimer(0L, 20L);
    }

    @Nullable
    public Boolean shouldBroadcast() {
        return !this.autoDetectShouldBroadcast ? null : Boolean.valueOf(this.shouldBroadcast);
    }

    public void setShouldBroadcast(@Nullable Boolean shouldBroadcast) {
        this.autoDetectShouldBroadcast = shouldBroadcast != null;
        this.shouldBroadcast = shouldBroadcast != null ? shouldBroadcast : false;
    }
}

