/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import com.ebicep.warlords.game.option.WinByPointsOption;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class GameOvertimeOption
implements Option,
Listener {
    private static final int OVERTIME_POINT = 20;
    private static final int OVERTIME_TIME = 60;
    private boolean wasActivated = false;
    private int overTimePoints;
    private int overTimeTime;

    public GameOvertimeOption() {
        this(20, 60);
    }

    public GameOvertimeOption(int overTimePoints, int overTimeTime) {
        this.overTimePoints = overTimePoints;
        this.overTimeTime = overTimeTime;
    }

    public boolean isWasActivated() {
        return this.wasActivated;
    }

    public void setWasActivated(boolean wasActivated) {
        this.wasActivated = wasActivated;
    }

    public int getOverTimePoints() {
        return this.overTimePoints;
    }

    public void setOverTimePoints(int overTimePoints) {
        this.overTimePoints = overTimePoints;
    }

    public int getOverTimeTime() {
        return this.overTimeTime;
    }

    public void setOverTimeTime(int overTimeTime) {
        this.overTimeTime = overTimeTime;
    }

    @Override
    public void register(Game game) {
        game.registerEvents(this);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEvent(WarlordsGameTriggerWinEvent event) {
        if (!this.wasActivated && event.getCause() instanceof WinAfterTimeoutOption && event.getDeclaredWinner() == null) {
            event.setCancelled(true);
            for (Team team2 : TeamMarker.getTeams(event.getGame())) {
                event.getGame().setPoints(team2, 0);
            }
            for (Option option : event.getGame().getOptions()) {
                if (!(option instanceof WinByPointsOption)) continue;
                WinByPointsOption winByPointsOption = (WinByPointsOption)option;
                winByPointsOption.setPointLimit(this.overTimePoints);
            }
            WinAfterTimeoutOption drawAfterTimeoutOption = (WinAfterTimeoutOption)event.getCause();
            drawAfterTimeoutOption.setTimeRemaining(this.overTimeTime);
            event.getGame().forEachOnlinePlayerWithoutSpectators((player, team) -> {
                PacketUtils.sendTitle(player, ChatColor.LIGHT_PURPLE + "OVERTIME!", ChatColor.YELLOW + "First team to reach " + this.overTimePoints + " points wins!", 0, 60, 0);
                player.sendMessage("\u00a7dOvertime is now active!");
                player.playSound(player.getLocation(), Sound.PORTAL_TRAVEL, 1.0f, 1.0f);
            });
            this.wasActivated = true;
        }
    }

    public String toString() {
        return "GameOvertimeOption{wasActivated=" + this.wasActivated + ", overTimePoints=" + this.overTimePoints + ", overTimeTime=" + this.overTimeTime + '}';
    }

    @Override
    public void checkConflicts(List<Option> options) {
        boolean hasDrawAfterTimeoutOption = Utils.collectionHasItem(options, e -> e instanceof WinAfterTimeoutOption);
        boolean hasWinByPointsOption = Utils.collectionHasItem(options, e -> e instanceof WinByPointsOption);
        if (!hasDrawAfterTimeoutOption || !hasWinByPointsOption) {
            throw new IllegalArgumentException("Game requires a WinAfterTimeoutOption and a WinByPointsOption for the GameOvertimeOption to work properly");
        }
    }
}

