/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.warlords.GameRunnable;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;

public class GameFreezeWhenOfflineOption
implements Option {
    private static final String FROZEN_MESSAGE = ChatColor.YELLOW + "Missing player detected!";
    public static final int UNFREEZE_TIME = 5;
    private static final int FREEZE_TIME = 10;
    private int timer = 0;
    private boolean isFrozen = false;

    @Override
    public void start(final Game game) {
        new GameRunnable(game, true){

            @Override
            public void run() {
                boolean anyOffline = game.offlinePlayersWithoutSpectators().anyMatch(e -> !((OfflinePlayer)e.getKey()).isOnline());
                if (GameFreezeWhenOfflineOption.this.isFrozen) {
                    if (anyOffline) {
                        GameFreezeWhenOfflineOption.this.timer = 0;
                    } else if (GameFreezeWhenOfflineOption.this.timer >= 5) {
                        game.removeFrozenCause(FROZEN_MESSAGE);
                        GameFreezeWhenOfflineOption.this.isFrozen = false;
                        GameFreezeWhenOfflineOption.this.timer = 0;
                    } else {
                        game.forEachOnlinePlayerWithoutSpectators((p, team) -> PacketUtils.sendTitle(p, ChatColor.BLUE + "Resuming in... " + ChatColor.GREEN + (5 - GameFreezeWhenOfflineOption.this.timer), "", 0, 40, 0));
                        GameFreezeWhenOfflineOption.this.timer++;
                    }
                } else if (!anyOffline) {
                    GameFreezeWhenOfflineOption.this.timer = 0;
                } else if (GameFreezeWhenOfflineOption.this.timer >= 10) {
                    game.addFrozenCause(FROZEN_MESSAGE);
                    GameFreezeWhenOfflineOption.this.isFrozen = true;
                    GameFreezeWhenOfflineOption.this.timer = 0;
                } else {
                    GameFreezeWhenOfflineOption.this.timer++;
                }
            }
        }.runTaskTimer(0L, 20L);
    }
}

