/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.events.WarlordsGameUpdatedEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.warlords.Utils;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Horse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GameFreezeOption
implements Option,
Listener {
    private static Listener GLOBAL_LISTENER = new Listener(){

        @EventHandler
        public void onEvent(PlayerMoveEvent e) {
            WarlordsPlayer wp = Warlords.getPlayer(e.getPlayer());
            if (wp != null && wp.getGame().isFrozen() && Utils.collectionHasItem(wp.getGame().getOptions(), o -> o instanceof GameFreezeOption)) {
                if (wp.isDead()) {
                    e.getPlayer().teleport(e.getPlayer().getLocation());
                } else if (e.getPlayer().getVehicle() == null) {
                    e.setTo(e.getFrom());
                } else {
                    e.setCancelled(true);
                }
            }
        }
    };
    private Game game;
    private boolean isFrozen = false;

    @Override
    public void register(Game game) {
        this.game = game;
        game.registerEvents(this);
        if (GLOBAL_LISTENER != null) {
            Bukkit.getPluginManager().registerEvents(GLOBAL_LISTENER, (Plugin)Warlords.getInstance());
            GLOBAL_LISTENER = null;
        }
    }

    private void freeze() {
        if (this.game.getFrozenCauses().isEmpty()) {
            throw new IllegalStateException("Game is not marked as frozen");
        }
        this.isFrozen = true;
        String message = this.game.getFrozenCauses().get(0);
        this.game.forEachOnlinePlayerWithoutSpectators((p, team) -> {
            if (p.getVehicle() instanceof Horse) {
                ((EntityLiving)((CraftEntity)p.getVehicle()).getHandle()).getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(0.0);
            }
            p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 9999999, 100000));
            PacketUtils.sendTitle(p, ChatColor.RED + "Game Paused", message, 0, 9999999, 0);
        });
    }

    private void unfreeze() {
        this.isFrozen = false;
        this.game.forEachOnlinePlayerWithoutSpectators((p, team) -> {
            if (p.getVehicle() instanceof Horse) {
                ((EntityLiving)((CraftEntity)p.getVehicle()).getHandle()).getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(0.318);
            }
            PacketUtils.sendTitle(p, "", "", 0, 0, 0);
            p.removePotionEffect(PotionEffectType.BLINDNESS);
        });
    }

    @EventHandler
    public void onGameUpdated(WarlordsGameUpdatedEvent evt) {
        if (evt.getGame() != this.game) {
            return;
        }
        switch (evt.getKey()) {
            case "frozen": {
                if (this.game.isFrozen() && !this.isFrozen) {
                    this.freeze();
                }
                if (this.game.isFrozen() || !this.isFrozen) break;
                this.unfreeze();
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent evt) {
        if (this.game.getPlayerTeam(evt.getPlayer().getUniqueId()) != null && this.isFrozen) {
            this.freeze();
        }
    }
}

