/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.events.WarlordsFlagUpdatedEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.FlagInfo;
import com.ebicep.warlords.game.flags.FlagLocation;
import com.ebicep.warlords.game.flags.FlagRenderer;
import com.ebicep.warlords.game.flags.GroundFlagLocation;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import com.ebicep.warlords.game.flags.WaitingFlagLocation;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.CompassTargetMarker;
import com.ebicep.warlords.game.option.marker.DebugLocationMarker;
import com.ebicep.warlords.game.option.marker.FlagCaptureInhibitMarker;
import com.ebicep.warlords.game.option.marker.FlagCaptureMarker;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.option.marker.scoreboard.SimpleScoreboardHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.MovingObjectPosition;
import net.minecraft.server.v1_8_R3.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class FlagSpawnPointOption
implements Option {
    public static final boolean DEFAULT_REGISTER_COMPASS_MARKER = true;
    @Nonnull
    private final FlagInfo info;
    @Nonnull
    private final FlagRenderer renderer;
    @Nonnull
    private SimpleScoreboardHandler scoreboard;
    @Nonnull
    private Game game;
    private final boolean registerCompassMarker;

    public FlagSpawnPointOption(@Nonnull Location loc, @Nonnull Team team) {
        this(loc, team, true);
    }

    public FlagSpawnPointOption(@Nonnull Location loc, @Nonnull Team team, boolean registerCompassMarker) {
        this.info = new FlagInfo(team, loc, this::onFlagUpdate);
        this.renderer = new FlagRenderer(this.info);
        this.registerCompassMarker = registerCompassMarker;
    }

    @Override
    public void register(final Game game) {
        this.game = game;
        game.registerGameMarker(FlagCaptureInhibitMarker.class, pFlag -> !(this.info.getFlag() instanceof SpawnFlagLocation) && this.info.getTeam() == pFlag.getPlayer().getTeam());
        game.registerGameMarker(DebugLocationMarker.class, DebugLocationMarker.create(Material.BANNER, 0, this.getClass(), "Flag spawn: " + (Object)((Object)this.info.getTeam()), this.info.getSpawnLocation()));
        game.registerGameMarker(DebugLocationMarker.class, DebugLocationMarker.create(Material.BANNER, 15, this.getClass(), "Flag: " + (Object)((Object)this.info.getTeam()), () -> this.info.getFlag().getLocation(), () -> this.info.getFlag().getDebugInformation()));
        FlagHolder holder = FlagHolder.create(() -> this.info);
        game.registerGameMarker(FlagHolder.class, holder);
        if (this.registerCompassMarker) {
            game.registerGameMarker(CompassTargetMarker.class, holder);
        }
        this.scoreboard = new SimpleScoreboardHandler(this.info.getTeam() == Team.RED ? 20 : 21, "flag"){

            @Override
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                String flagName = FlagSpawnPointOption.this.info.getTeam().coloredPrefix();
                FlagLocation flag = FlagSpawnPointOption.this.info.getFlag();
                if (flag instanceof SpawnFlagLocation) {
                    return Collections.singletonList(flagName + " Flag: " + ChatColor.GREEN + "Safe");
                }
                if (flag instanceof PlayerFlagLocation) {
                    PlayerFlagLocation pFlag = (PlayerFlagLocation)flag;
                    String extra = pFlag.getPickUpTicks() == 0 ? "" : ChatColor.YELLOW + " +" + pFlag.getComputedHumanMultiplier() + "\u00a7e%";
                    return Collections.singletonList(flagName + " Flag: " + ChatColor.RED + "Stolen!" + extra);
                }
                if (flag instanceof GroundFlagLocation) {
                    GroundFlagLocation gFlag = (GroundFlagLocation)flag;
                    return Collections.singletonList(flagName + " Flag: " + ChatColor.YELLOW + "Dropped! " + ChatColor.GRAY + gFlag.getDespawnTimerSeconds());
                }
                return Collections.singletonList(flagName + " Flag: " + ChatColor.GRAY + "Respawning...");
            }
        };
        game.registerGameMarker(ScoreboardHandler.class, this.scoreboard);
        game.registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.LOW)
            public void onArmorStandBreak(EntityDamageByEntityEvent event) {
                boolean isOurArmorStand = FlagSpawnPointOption.this.renderer.getRenderedArmorStands().contains(event.getEntity());
                WarlordsPlayer wp = Warlords.getPlayer(event.getDamager());
                if (wp != null && wp.getGame() == game && isOurArmorStand) {
                    this.onFlagInteract(wp);
                    event.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOW)
            public void onPotentialFlagInteract(PlayerInteractEntityEvent event) {
                this.onPotentialFlagInteract((PlayerEvent)event);
            }

            @EventHandler(priority=EventPriority.LOW)
            public void onPotentialFlagInteract(PlayerInteractEvent event) {
                this.onPotentialFlagInteract((PlayerEvent)event);
            }

            private void onPotentialFlagInteract(PlayerEvent event) {
                WarlordsPlayer wp = Warlords.getPlayer(event.getPlayer());
                if (wp != null && wp.getGame() == game) {
                    Location playerLocation = wp.getEntity().getEyeLocation();
                    Vector direction = wp.getEntity().getLocation().getDirection().multiply(3);
                    Vec3D from = new Vec3D(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
                    Vec3D to = new Vec3D(playerLocation.getX() + direction.getX(), playerLocation.getY() + direction.getY(), playerLocation.getZ() + direction.getZ());
                    this.checkFlagInteract(playerLocation, wp, from, to, FlagSpawnPointOption.this.renderer);
                }
            }

            private void checkFlagInteract(Location playerLocation, WarlordsPlayer wp, Vec3D from, Vec3D to, FlagRenderer render) {
                Location entityLoc = new Location(playerLocation.getWorld(), 0.0, 0.0, 0.0);
                for (Entity stand : render.getRenderedArmorStands()) {
                    AxisAlignedBB aabb;
                    MovingObjectPosition mop;
                    stand.getLocation(entityLoc);
                    if (entityLoc.getWorld() != playerLocation.getWorld() || !(entityLoc.distanceSquared(playerLocation) < 25.0) || (mop = (aabb = new AxisAlignedBB(entityLoc.getX() - 0.5, entityLoc.getY(), entityLoc.getZ() - 0.5, entityLoc.getX() + 0.5, entityLoc.getY() + 2.0, entityLoc.getZ() + 0.5)).a(from, to)) == null) continue;
                    this.onFlagInteract(wp);
                    break;
                }
            }

            private void onFlagInteract(WarlordsPlayer wp) {
                Team team = wp.getTeam();
                if (wp.isDead()) {
                    return;
                }
                if (wp.getFlagPickCooldown() != 0 && wp.getTeam() != FlagSpawnPointOption.this.info.getTeam()) {
                    wp.sendMessage("\u00a7cYou cannot pick up the flag yet!");
                    return;
                }
                if (FlagSpawnPointOption.this.renderer.getLastFlagState() != FlagSpawnPointOption.this.info.getFlag()) {
                    return;
                }
                wp.setFlagDropCooldown(2);
                if (FlagSpawnPointOption.this.info.getFlag() instanceof GroundFlagLocation) {
                    GroundFlagLocation groundFlagLocation = (GroundFlagLocation)FlagSpawnPointOption.this.info.getFlag();
                    if (team == FlagSpawnPointOption.this.info.getTeam()) {
                        FlagSpawnPointOption.this.info.setFlag(new SpawnFlagLocation(FlagSpawnPointOption.this.info.getSpawnLocation(), wp));
                    } else {
                        FlagSpawnPointOption.this.info.setFlag(new PlayerFlagLocation(wp, groundFlagLocation.getDamageTimer()));
                        if (wp.getEntity().getVehicle() != null) {
                            wp.getEntity().getVehicle().remove();
                        }
                    }
                } else if (FlagSpawnPointOption.this.info.getFlag() instanceof SpawnFlagLocation) {
                    if (team == FlagSpawnPointOption.this.info.getTeam()) {
                        wp.sendMessage("\u00a7cYou cannot steal your own team's flag!");
                    } else {
                        FlagSpawnPointOption.this.info.setFlag(new PlayerFlagLocation(wp, 0));
                        wp.getCooldownManager().addCooldown(new RegularCooldown<FlagSpawnPointOption>("Flag Damage Resistance", "RES", FlagSpawnPointOption.class, null, wp, CooldownTypes.BUFF, cooldownManager -> {}, 300){

                            @Override
                            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                                return currentDamageValue * 0.9f;
                            }
                        });
                    }
                }
            }
        });
    }

    private boolean flagIsInCaptureZone(PlayerFlagLocation playerFlagLocation) {
        for (FlagCaptureMarker flag : this.game.getMarkers(FlagCaptureMarker.class)) {
            if (!flag.shouldCountAsCapture(playerFlagLocation)) continue;
            return true;
        }
        return false;
    }

    private boolean flagCaptureIsNotBlocked(PlayerFlagLocation playerFlagLocation) {
        for (FlagCaptureInhibitMarker blocker : this.game.getMarkers(FlagCaptureInhibitMarker.class)) {
            if (!blocker.isInhibitingFlagCapture(playerFlagLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void start(final Game game) {
        new GameRunnable(game){

            @Override
            public void run() {
                if (!(FlagSpawnPointOption.this.info.getFlag() instanceof PlayerFlagLocation)) {
                    return;
                }
                PlayerFlagLocation playerFlagLocation = (PlayerFlagLocation)FlagSpawnPointOption.this.info.getFlag();
                if (FlagSpawnPointOption.this.flagIsInCaptureZone(playerFlagLocation) && !FlagSpawnPointOption.this.flagCaptureIsNotBlocked(playerFlagLocation)) {
                    FlagHolder.update(game, info -> new WaitingFlagLocation(info.getSpawnLocation(), info.getFlag() == playerFlagLocation ? playerFlagLocation.getPlayer() : null));
                }
            }
        }.runTaskTimer(0L, 4L);
        new GameRunnable(game){

            @Override
            public void run() {
                FlagLocation newFlag = FlagSpawnPointOption.this.info.getFlag().update(FlagSpawnPointOption.this.info);
                if (newFlag != null) {
                    FlagSpawnPointOption.this.info.setFlag(newFlag);
                }
                FlagSpawnPointOption.this.renderer.checkRender();
            }
        }.runTaskTimer(0L, 1L);
    }

    @Override
    public void onGameCleanup(Game game) {
        this.renderer.reset();
    }

    public FlagInfo getInfo() {
        return this.info;
    }

    public FlagRenderer getRenderer() {
        return this.renderer;
    }

    private void onFlagUpdate(FlagInfo info, FlagLocation old) {
        this.scoreboard.markChanged();
        Bukkit.getPluginManager().callEvent((Event)new WarlordsFlagUpdatedEvent(this.game, info, old));
        this.renderer.checkRender();
    }
}

