/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.option.marker.scoreboard.SimpleScoreboardHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;

public class BasicScoreboardOption
implements Option {
    @Override
    public void register(Game game) {
        game.registerGameMarker(ScoreboardHandler.class, BasicScoreboardOption.getDateScoreboard(game));
        game.registerGameMarker(ScoreboardHandler.class, BasicScoreboardOption.getVersionScoreboard(game));
        game.registerGameMarker(ScoreboardHandler.class, BasicScoreboardOption.getStatsScoreboard(game));
        game.registerGameMarker(ScoreboardHandler.class, BasicScoreboardOption.getSpecScoreboard(game));
    }

    private static SimpleScoreboardHandler getDateScoreboard(Game game) {
        final SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy - kk:mm");
        format.setTimeZone(TimeZone.getTimeZone("EST"));
        final SimpleScoreboardHandler simpleScoreboardHandler = new SimpleScoreboardHandler(0, "date"){

            @Override
            @Nonnull
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                return Collections.singletonList(ChatColor.GRAY + format.format(new Date()));
            }
        };
        new GameRunnable(game){

            @Override
            public void run() {
                simpleScoreboardHandler.markChanged();
            }
        }.runTaskTimer(20L, 20L);
        return simpleScoreboardHandler;
    }

    private static SimpleScoreboardHandler getVersionScoreboard(Game game) {
        return new SimpleScoreboardHandler(Integer.MAX_VALUE, "version"){

            @Override
            @Nonnull
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                return Collections.singletonList(ChatColor.YELLOW + Warlords.VERSION);
            }
        };
    }

    private static SimpleScoreboardHandler getStatsScoreboard(Game game) {
        return new SimpleScoreboardHandler(0x7FFFFFFE, "player-stats"){

            @Override
            @Nonnull
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                return player == null ? Collections.singletonList("") : Collections.singletonList(ChatColor.GREEN.toString() + player.getMinuteStats().total().getKills() + ChatColor.RESET + " Kills " + ChatColor.GREEN + player.getMinuteStats().total().getAssists() + ChatColor.RESET + " Assists");
            }
        };
    }

    private static SimpleScoreboardHandler getSpecScoreboard(Game game) {
        return new SimpleScoreboardHandler(0x7FFFFFFD, "spec"){

            @Override
            @Nonnull
            public List<String> computeLines(@Nullable WarlordsPlayer player) {
                return player == null ? Collections.singletonList("") : Collections.singletonList(ChatColor.WHITE + "Spec: " + ChatColor.GREEN + player.getSpec().getClass().getSimpleName());
            }
        };
    }
}

