/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.events.WarlordsDeathEvent;
import com.ebicep.warlords.events.WarlordsFlagUpdatedEvent;
import com.ebicep.warlords.events.WarlordsIntersectionCaptureEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import com.ebicep.warlords.game.flags.WaitingFlagLocation;
import com.ebicep.warlords.game.option.InterceptionPointOption;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.PointPredicterMarker;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.BiFunction;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public abstract class AbstractScoreOnEventOption<T>
implements Option {
    protected int scoreIncrease;
    private BiFunction<T, Pair<Team, Integer>, Pair<Team, Integer>> scoreModifier = (a, b) -> b;
    private Game game;

    public AbstractScoreOnEventOption(int scoreIncrease) {
        this.scoreIncrease = scoreIncrease;
    }

    public int getScoreIncrease() {
        return this.scoreIncrease;
    }

    public void setScoreIncrease(int scoreIncrease) {
        this.scoreIncrease = scoreIncrease;
    }

    public BiFunction<T, Pair<Team, Integer>, Pair<Team, Integer>> getScoreModifier() {
        return this.scoreModifier;
    }

    public void setScoreModifier(BiFunction<T, Pair<Team, Integer>, Pair<Team, Integer>> scoreModifier) {
        this.scoreModifier = scoreModifier;
    }

    @Override
    public void register(Game game) {
        this.game = game;
    }

    protected void giveScore(T event, Team team, int score) {
        Pair<Team, Integer> res = this.scoreModifier.apply(event, new Pair<Team, Integer>(team, score));
        this.game.addPoints(res.getA(), res.getB());
    }

    public static class OnInterceptionTimer
    extends AbstractScoreOnEventOption<InterceptionPointOption> {
        public static int DEFAULT_SCORE = 1;

        public OnInterceptionTimer() {
            this(DEFAULT_SCORE);
        }

        public OnInterceptionTimer(int scoreIncrease) {
            super(scoreIncrease);
        }

        @Override
        public void register(Game game) {
            super.register(game);
            game.registerGameMarker(PointPredicterMarker.class, team -> {
                double predictedScoreIncrease = 0.0;
                for (Option option : game.getOptions()) {
                    InterceptionPointOption intersectionPointOption;
                    if (!(option instanceof InterceptionPointOption) || (intersectionPointOption = (InterceptionPointOption)option).getTeamOwning() != team) continue;
                    predictedScoreIncrease += (double)(this.scoreIncrease * 60);
                }
                return predictedScoreIncrease;
            });
        }

        @Override
        public void start(final Game game) {
            super.register(game);
            new GameRunnable(game){

                @Override
                public void run() {
                    for (Option option : game.getOptions()) {
                        InterceptionPointOption intersectionPointOption;
                        if (!(option instanceof InterceptionPointOption) || (intersectionPointOption = (InterceptionPointOption)option).getTeamOwning() == null) continue;
                        this.giveScore(intersectionPointOption, intersectionPointOption.getTeamOwning(), scoreIncrease);
                    }
                }
            }.runTaskTimer(20L, 20L);
        }
    }

    public static class OnInterceptionCapture
    extends AbstractScoreOnEventOption<WarlordsIntersectionCaptureEvent> {
        public static int DEFAULT_SCORE = 5;

        public OnInterceptionCapture() {
            this(DEFAULT_SCORE);
        }

        public OnInterceptionCapture(int scoreIncrease) {
            super(scoreIncrease);
        }

        @Override
        public void register(Game game) {
            super.register(game);
            game.registerEvents(new Listener(){

                @EventHandler
                public void onEvent(WarlordsIntersectionCaptureEvent event) {
                    if (event.getOption().getTeamOwning() != null) {
                        this.giveScore(event, event.getOption().getTeamOwning(), scoreIncrease);
                    }
                }
            });
        }
    }

    public static class OnKill
    extends AbstractScoreOnEventOption<WarlordsDeathEvent> {
        public static int DEFAULT_SCORE = 5;

        public OnKill() {
            this(DEFAULT_SCORE);
        }

        public OnKill(int scoreIncrease) {
            super(scoreIncrease);
        }

        @Override
        public void register(Game game) {
            super.register(game);
            game.registerEvents(new Listener(){

                @EventHandler
                public void onEvent(WarlordsDeathEvent event) {
                    EnumSet<Team> teams = TeamMarker.getTeams(event.getGame());
                    ArrayList<Team> toReward = new ArrayList<Team>(teams.size() - 1);
                    for (Team team : teams) {
                        if (event.getKiller() != null && event.getKiller().getTeam() != event.getPlayer().getTeam() && event.getKiller().getTeam() != team || team == event.getPlayer().getTeam()) continue;
                        toReward.add(team);
                    }
                    for (Team team : toReward) {
                        this.giveScore(event, team, scoreIncrease / toReward.size());
                    }
                }
            });
        }
    }

    public static class FlagHolding
    extends AbstractScoreOnEventOption<WarlordsFlagUpdatedEvent> {
        public static int DEFAULT_SCORE = 1;

        public FlagHolding() {
            this(DEFAULT_SCORE);
        }

        public FlagHolding(int scoreIncrease) {
            super(scoreIncrease);
        }

        @Override
        public void register(Game game) {
            super.register(game);
            game.registerEvents(new Listener(){

                @EventHandler
                public void onEvent(WarlordsFlagUpdatedEvent event) {
                    if (event.getOld() instanceof PlayerFlagLocation && event.getNew() instanceof PlayerFlagLocation) {
                        PlayerFlagLocation playerFlagLocation = (PlayerFlagLocation)event.getNew();
                        WarlordsPlayer scorer = playerFlagLocation.getPlayer();
                        this.giveScore(event, scorer.getTeam(), scoreIncrease);
                    }
                }
            });
        }
    }

    public static class FlagReturn
    extends AbstractScoreOnEventOption<WarlordsFlagUpdatedEvent> {
        public static int DEFAULT_SCORE = 100;

        public FlagReturn() {
            this(DEFAULT_SCORE);
        }

        public FlagReturn(int scoreIncrease) {
            super(scoreIncrease);
        }

        @Override
        public void register(Game game) {
            super.register(game);
            game.registerEvents(new Listener(){

                @EventHandler
                public void onEvent(WarlordsFlagUpdatedEvent event) {
                    SpawnFlagLocation spawnFlagLocation;
                    WarlordsPlayer scorer;
                    if (event.getNew() instanceof SpawnFlagLocation && (scorer = (spawnFlagLocation = (SpawnFlagLocation)event.getNew()).getFlagReturner()) != null) {
                        this.giveScore(event, scorer.getTeam(), scoreIncrease);
                    }
                }
            });
        }
    }

    public static class FlagCapture
    extends AbstractScoreOnEventOption<WarlordsFlagUpdatedEvent> {
        public static int DEFAULT_SCORE = 250;

        public FlagCapture() {
            this(DEFAULT_SCORE);
        }

        public FlagCapture(int scoreIncrease) {
            super(scoreIncrease);
        }

        @Override
        public void register(Game game) {
            super.register(game);
            game.registerEvents(new Listener(){

                @EventHandler
                public void onEvent(WarlordsFlagUpdatedEvent event) {
                    WaitingFlagLocation waitingFlagLocation;
                    WarlordsPlayer scorer;
                    if (event.getNew() instanceof WaitingFlagLocation && (scorer = (waitingFlagLocation = (WaitingFlagLocation)event.getNew()).getScorer()) != null) {
                        this.giveScore(event, scorer.getTeam(), scoreIncrease);
                    }
                }
            });
        }
    }
}

