/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.option;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.option.GameFreezeOption;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.state.PlayingState;
import com.ebicep.warlords.permissions.PermissionHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class AFKDetectionOption
implements Option,
Listener {
    public static boolean enabled = true;
    private final HashMap<WarlordsPlayer, List<Location>> playerLocations = new HashMap();
    private boolean canFreeze = false;

    @Override
    public void register(@Nonnull Game game) {
        game.registerEvents(this);
        this.canFreeze = Utils.collectionHasItem(game.getOptions(), o -> o instanceof GameFreezeOption);
    }

    @Override
    public void start(final @Nonnull Game game) {
        new GameRunnable(game){
            boolean wasFrozen;
            {
                super(game3);
                this.wasFrozen = false;
            }

            @Override
            public void run() {
                if (!enabled) {
                    return;
                }
                if (game.getPlayers().size() < 14 || game.getAddons().contains((Object)GameAddon.CUSTOM_GAME)) {
                    return;
                }
                if (this.wasFrozen) {
                    this.wasFrozen = false;
                    return;
                }
                game.getState(PlayingState.class).ifPresent(state -> {
                    for (WarlordsPlayer warlordsPlayer : PlayerFilter.playingGame(game)) {
                        if (warlordsPlayer.isDead() || warlordsPlayer.getName().equalsIgnoreCase("TestDummy") || warlordsPlayer.isSneaking()) continue;
                        AFKDetectionOption.this.playerLocations.computeIfAbsent(warlordsPlayer, k -> new ArrayList()).add(warlordsPlayer.getLocation());
                        List locations = (List)AFKDetectionOption.this.playerLocations.get(warlordsPlayer);
                        if (locations.size() < 2) continue;
                        Location lastLocation = (Location)locations.get(locations.size() - 1);
                        Location secondLastLocation = (Location)locations.get(locations.size() - 2);
                        if (locations.size() >= 3) {
                            Location thirdLastLocation = (Location)locations.get(locations.size() - 3);
                            if (locations.size() >= 4) {
                                Location fourthLastLocation = (Location)locations.get(locations.size() - 4);
                                if (lastLocation.equals((Object)secondLastLocation) && lastLocation.equals((Object)thirdLastLocation) && lastLocation.equals((Object)fourthLastLocation)) {
                                    for (WarlordsPlayer wp : PlayerFilter.playingGame(game)) {
                                        PermissionHandler.sendMessageToDebug(wp, ChatColor.RED + "----------------------------------------");
                                        PermissionHandler.sendMessageToDebug(wp, ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.RED + " is AFK. (Hasn't moved for 10 seconds)");
                                        PermissionHandler.sendMessageToDebug(wp, ChatColor.RED + "----------------------------------------");
                                    }
                                    if (!AFKDetectionOption.this.canFreeze) continue;
                                    warlordsPlayer.getGame().addFrozenCause(ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.RED + " has been detected as AFK.");
                                    this.wasFrozen = true;
                                    continue;
                                }
                            }
                            if (!secondLastLocation.equals((Object)thirdLastLocation)) continue;
                            for (WarlordsPlayer wp : PlayerFilter.playingGame(game)) {
                                PermissionHandler.sendMessageToDebug(wp, ChatColor.RED + "----------------------------------------");
                                PermissionHandler.sendMessageToDebug(wp, ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.RED + " is possibly AFK. (Hasn't moved for 7.5 seconds)");
                                PermissionHandler.sendMessageToDebug(wp, ChatColor.RED + "----------------------------------------");
                            }
                            continue;
                        }
                        if (!lastLocation.equals((Object)secondLastLocation)) continue;
                        for (WarlordsPlayer wp : PlayerFilter.playingGame(game)) {
                            PermissionHandler.sendMessageToDebug(wp, ChatColor.RED + "----------------------------------------");
                            PermissionHandler.sendMessageToDebug(wp, ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.RED + " is possibly AFK. (Hasn't moved for 5 seconds)");
                            PermissionHandler.sendMessageToDebug(wp, ChatColor.RED + "----------------------------------------");
                        }
                    }
                });
            }
        }.runTaskTimer(300L, 50L);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        WarlordsPlayer warlordsPlayer = Warlords.getPlayer(player);
        if (warlordsPlayer != null) {
            this.playerLocations.computeIfAbsent(warlordsPlayer, k -> new ArrayList()).clear();
        }
    }

    @EventHandler
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        WarlordsPlayer warlordsPlayer = Warlords.getPlayer(player);
        if (warlordsPlayer != null) {
            this.playerLocations.computeIfAbsent(warlordsPlayer, k -> new ArrayList()).clear();
        }
    }
}

