/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.flags;

import com.ebicep.warlords.game.flags.FlagInfo;
import com.ebicep.warlords.game.flags.FlagLocation;
import com.ebicep.warlords.game.flags.GroundFlagLocation;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public class PlayerFlagLocation
implements FlagLocation {
    private final WarlordsPlayer player;
    private int pickUpTicks;

    public PlayerFlagLocation(WarlordsPlayer player, int pickUpTicks) {
        this.player = player;
        this.pickUpTicks = pickUpTicks;
    }

    @Override
    public Location getLocation() {
        return this.player.getLocation();
    }

    public WarlordsPlayer getPlayer() {
        return this.player;
    }

    public int getPickUpTicks() {
        return this.pickUpTicks;
    }

    public void setPickUpTicks(int modifier) {
        this.pickUpTicks = modifier;
    }

    public void addPickUpTicks(int amount) {
        this.pickUpTicks += amount;
    }

    public double getComputedMultiplier() {
        return 1.0 + (double)(this.pickUpTicks / 60) * 0.01;
    }

    public int getComputedHumanMultiplier() {
        return this.pickUpTicks / 60;
    }

    @Override
    public FlagLocation update(FlagInfo info) {
        ++this.pickUpTicks;
        return this.pickUpTicks % 60 == 0 ? new PlayerFlagLocation(this.player, this.pickUpTicks) : null;
    }

    @Override
    public List<String> getDebugInformation() {
        return Arrays.asList("Type: " + this.getClass().getSimpleName(), "Player: " + this.getPlayer().getName(), "pickUpTicks: " + this.getPickUpTicks(), "pickUpTicks / 20: " + this.getPickUpTicks() / 20, "Multiplier: +" + this.getComputedHumanMultiplier() + "%");
    }

    public static PlayerFlagLocation of(@Nonnull FlagLocation flag, WarlordsPlayer player) {
        return flag instanceof GroundFlagLocation ? new PlayerFlagLocation(player, ((GroundFlagLocation)flag).getDamageTimer()) : new PlayerFlagLocation(player, 0);
    }
}

