/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.flags;

import com.ebicep.warlords.game.flags.AbstractLocationBasedFlagLocation;
import com.ebicep.warlords.game.flags.FlagInfo;
import com.ebicep.warlords.game.flags.FlagLocation;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public class GroundFlagLocation
extends AbstractLocationBasedFlagLocation
implements FlagLocation {
    int damageTimer;
    int despawnTimer;

    public GroundFlagLocation(Location location, int damageTimer) {
        super(location);
        this.damageTimer = damageTimer;
        this.despawnTimer = 300;
    }

    public GroundFlagLocation(PlayerFlagLocation playerFlagLocation) {
        this(playerFlagLocation.getLocation(), playerFlagLocation.getPlayer().isDead() ? playerFlagLocation.getPickUpTicks() + 600 : playerFlagLocation.getPickUpTicks());
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public int getDamageTimer() {
        return this.damageTimer;
    }

    public int getDespawnTimer() {
        return this.despawnTimer;
    }

    public int getDespawnTimerSeconds() {
        return this.despawnTimer / 20;
    }

    @Override
    public FlagLocation update(FlagInfo info) {
        --this.despawnTimer;
        ++this.damageTimer;
        return this.despawnTimer <= 0 ? new SpawnFlagLocation(info.getSpawnLocation(), null) : null;
    }

    @Override
    public List<String> getDebugInformation() {
        return Arrays.asList("Type: " + this.getClass().getSimpleName(), "Despawn ticks: " + this.getDespawnTimer(), "Despawn seconds: " + this.getDespawnTimerSeconds(), "damageTimer: " + this.getDamageTimer());
    }

    public static GroundFlagLocation of(@Nonnull FlagLocation flag) {
        return flag instanceof PlayerFlagLocation ? new GroundFlagLocation((PlayerFlagLocation)flag) : new GroundFlagLocation(flag.getLocation(), 0);
    }
}

