/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.flags;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.FlagInfo;
import com.ebicep.warlords.game.flags.FlagLocation;
import com.ebicep.warlords.game.flags.GroundFlagLocation;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import com.ebicep.warlords.game.flags.WaitingFlagLocation;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Banner;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FlagRenderer {
    private final FlagInfo info;
    private int timer = 0;
    private final List<Player> affectedPlayers = new ArrayList<Player>();
    private final List<Entity> renderedArmorStands = new ArrayList<Entity>();
    private final List<Block> renderedBlocks = new ArrayList<Block>();
    private final List<Runnable> runningTasksCancel = new ArrayList<Runnable>();
    private FlagLocation lastLocation;

    public FlagRenderer(FlagInfo info) {
        this.info = info;
    }

    public FlagInfo getInfo() {
        return this.info;
    }

    public List<Entity> getRenderedArmorStands() {
        return this.renderedArmorStands;
    }

    @Nullable
    public FlagLocation getLastFlagState() {
        return this.lastLocation;
    }

    public void checkRender() {
        if (this.lastLocation != this.info.getFlag()) {
            this.render();
        }
        if (this.timer <= 0 && !(this.info.getFlag() instanceof WaitingFlagLocation)) {
            this.timer = 20;
            float offset = this.info.getFlag() instanceof PlayerFlagLocation ? 1.5f : 0.5f;
            this.info.getFlag().getLocation().getWorld().playEffect(this.info.getFlag().getLocation().clone().add(0.0, (double)offset, 0.0), Effect.STEP_SOUND, this.info.getTeam() == Team.RED ? Material.REDSTONE_BLOCK.getId() : Material.LAPIS_BLOCK.getId());
        }
        --this.timer;
    }

    public void render() {
        if (this.lastLocation != null) {
            this.reset();
        }
        this.lastLocation = this.info.getFlag();
        Warlords plugin = Warlords.getInstance();
        if (this.lastLocation instanceof GroundFlagLocation || this.lastLocation instanceof SpawnFlagLocation) {
            Block block = this.lastLocation.getLocation().getBlock();
            for (int i = 0; !block.isEmpty() && block.getType() != Material.STANDING_BANNER && i < 4; ++i) {
                block = block.getRelative(0, 1, 0);
            }
            if (block.isEmpty() || block.getType() == Material.STANDING_BANNER) {
                this.renderedBlocks.add(block);
                block.setType(Material.STANDING_BANNER);
                org.bukkit.block.Banner banner = (org.bukkit.block.Banner)block.getState();
                banner.setBaseColor(this.info.getTeam() == Team.BLUE ? DyeColor.BLUE : DyeColor.RED);
                banner.addPattern(new Pattern(DyeColor.BLACK, PatternType.SKULL));
                banner.addPattern(new Pattern(DyeColor.BLACK, PatternType.TRIANGLES_TOP));
                banner.update();
                MaterialData newData = block.getState().getData();
                Vector target = this.lastLocation.getLocation().getDirection();
                Vector toTest = new Vector(0, 0, 0);
                BlockFace dir = BlockFace.SOUTH;
                double distance = Double.MAX_VALUE;
                for (BlockFace face : new BlockFace[]{BlockFace.SOUTH, BlockFace.SOUTH_SOUTH_WEST, BlockFace.SOUTH_WEST, BlockFace.WEST_SOUTH_WEST, BlockFace.WEST, BlockFace.WEST_NORTH_WEST, BlockFace.NORTH_WEST, BlockFace.NORTH_NORTH_WEST, BlockFace.NORTH, BlockFace.NORTH_NORTH_EAST, BlockFace.NORTH_EAST, BlockFace.EAST_NORTH_EAST, BlockFace.EAST, BlockFace.EAST_SOUTH_EAST, BlockFace.SOUTH_SOUTH_EAST, BlockFace.SOUTH_EAST}) {
                    toTest.setX(face.getModX());
                    toTest.setZ(face.getModZ());
                    toTest.normalize();
                    double newDistance = toTest.distanceSquared(target);
                    if (!(newDistance < distance)) continue;
                    dir = face;
                    distance = newDistance;
                }
                ((Banner)newData).setFacingDirection(dir);
                block.setData(newData.getData());
            }
            ArmorStand stand = (ArmorStand)this.lastLocation.getLocation().getWorld().spawn(block.getLocation().add(0.5, 0.0, 0.5), ArmorStand.class);
            this.renderedArmorStands.add((Entity)stand);
            stand.setGravity(false);
            stand.setCanPickupItems(false);
            stand.setCustomName(this.info.getTeam() == Team.BLUE ? ChatColor.BLUE + "" + ChatColor.BOLD + "BLU FLAG" : ChatColor.RED + "" + ChatColor.BOLD + "RED FLAG");
            stand.setCustomNameVisible(true);
            stand.setMetadata("INFO", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)this.info));
            stand.setVisible(false);
            ArmorStand stand1 = (ArmorStand)this.lastLocation.getLocation().getWorld().spawn(block.getLocation().add(0.5, -0.3, 0.5), ArmorStand.class);
            this.renderedArmorStands.add((Entity)stand1);
            stand1.setGravity(false);
            stand1.setCanPickupItems(false);
            stand1.setCustomName(ChatColor.WHITE + "" + ChatColor.BOLD + "LEFT-CLICK TO STEAL IT");
            stand1.setCustomNameVisible(true);
            stand.setMetadata("INFO", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)this.info));
            stand1.setVisible(false);
        } else if (this.lastLocation instanceof PlayerFlagLocation) {
            PlayerFlagLocation flag = (PlayerFlagLocation)this.lastLocation;
            this.runningTasksCancel.add(flag.getPlayer().getSpeed().addSpeedModifier("FLAG", -20, 0, true, new String[0]));
            LivingEntity entity = ((PlayerFlagLocation)this.lastLocation).getPlayer().getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.affectedPlayers.add(player);
                ItemStack item = new ItemStack(Material.BANNER);
                BannerMeta banner = (BannerMeta)item.getItemMeta();
                banner.setBaseColor(this.info.getTeam() == Team.BLUE ? DyeColor.BLUE : DyeColor.RED);
                banner.addPattern(new Pattern(DyeColor.BLACK, PatternType.SKULL));
                banner.addPattern(new Pattern(DyeColor.BLACK, PatternType.TRIANGLES_TOP));
                item.setItemMeta((ItemMeta)banner);
                player.getInventory().setHelmet(item);
                player.getInventory().setItem(6, new ItemBuilder(Material.BANNER, 1).name("\u00a7aDrop Flag").get());
            }
        }
    }

    public void reset() {
        this.lastLocation = null;
        for (Block b : this.renderedBlocks) {
            b.setType(Material.AIR);
        }
        this.renderedBlocks.clear();
        for (Entity e : this.renderedArmorStands) {
            e.removeMetadata("INFO", (Plugin)Warlords.getInstance());
            e.remove();
        }
        this.renderedArmorStands.clear();
        for (Player p : this.affectedPlayers) {
            WarlordsPlayer wp = Warlords.getPlayer(p);
            if (wp != null) {
                wp.updateArmor();
            }
            p.getInventory().setItem(6, null);
        }
        this.affectedPlayers.clear();
        for (Runnable t2 : this.runningTasksCancel) {
            t2.run();
        }
        this.runningTasksCancel.clear();
    }
}

