/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game.flags;

import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.flags.FlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import java.util.function.BiConsumer;
import org.bukkit.Location;

public class FlagInfo {
    private FlagLocation flag;
    private final Location spawnLocation;
    private final Team team;
    private final BiConsumer<FlagInfo, FlagLocation> onUpdate;

    public FlagInfo(Team team, Location spawnLocation, BiConsumer<FlagInfo, FlagLocation> onUpdate) {
        this.team = team;
        this.spawnLocation = spawnLocation;
        this.flag = new SpawnFlagLocation(this.spawnLocation, null);
        this.onUpdate = onUpdate;
    }

    public FlagLocation getFlag() {
        return this.flag;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setFlag(FlagLocation flag) {
        FlagLocation old = this.flag;
        this.flag = flag;
        this.onUpdate.accept(this, old);
    }

    void update() {
        FlagLocation updated = this.flag.update(this);
        if (updated != null) {
            this.setFlag(updated);
        }
    }
}

