/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public enum Team {
    BLUE("Blue", "BLU", ChatColor.BLUE, Color.fromRGB((int)51, (int)76, (int)178), new ItemStack(Material.WOOL, 1, 11)),
    RED("Red", "RED", ChatColor.RED, Color.fromRGB((int)153, (int)51, (int)51), new ItemStack(Material.WOOL, 1, 14));

    private static final Team[] inverseMapping;
    public final String name;
    public final ChatColor teamColor;
    public final String chatTag;
    public final String chatTagColored;
    public final String chatTagBoldColored;
    public final Color armorColor;
    public final ItemStack item;

    private Team(String name, String chatTag, ChatColor teamColor, Color armorColor, ItemStack item) {
        this.name = name;
        this.teamColor = teamColor;
        this.chatTag = chatTag;
        this.chatTagColored = teamColor + chatTag;
        this.chatTagBoldColored = teamColor.toString() + ChatColor.BOLD + chatTag;
        this.armorColor = armorColor;
        this.item = item;
    }

    @Nonnull
    public ChatColor teamColor() {
        return this.teamColor;
    }

    @Nonnull
    public Color armorColor() {
        return this.armorColor;
    }

    @Nonnull
    public String prefix() {
        return this.chatTag;
    }

    @Nonnull
    public String coloredPrefix() {
        return this.chatTagColored;
    }

    @Nonnull
    public String boldColoredPrefix() {
        return this.chatTagBoldColored;
    }

    @Deprecated
    @Nonnull
    public Team enemy() {
        return inverseMapping[this.ordinal()];
    }

    @Nonnull
    public ItemStack getItem() {
        return this.item;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    static {
        inverseMapping = Team.values();
        Collections.reverse(Arrays.asList(inverseMapping));
    }
}

