/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.LobbyLocationMarker;
import com.ebicep.warlords.game.option.marker.MapSymmetryMarker;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public enum MapSymmetry {
    NONE{

        @Override
        public Location getOppositeLocation(Game game, Team sourceTeam, Team targetTeam, Location original, Location target) {
            return target;
        }
    }
    ,
    SPIN{

        @Override
        public Location getOppositeLocation(Game game, Team sourceTeam, Team targetTeam, Location original, Location target) {
            EnumSet<Team> teams = TeamMarker.getTeams(game);
            Location mapCenter = new Location(target.getWorld(), 0.0, 0.0, 0.0);
            int indexSource = 0;
            int indexTarget = 0;
            int index = 0;
            for (Team team : teams) {
                LobbyLocationMarker lobby;
                if (team == sourceTeam) {
                    indexSource = index;
                }
                if (team == targetTeam) {
                    indexSource = index;
                }
                if ((lobby = LobbyLocationMarker.getFirstLobbyLocation(game, team)) != null) {
                    mapCenter.add(lobby.getLocation());
                }
                ++index;
            }
            if (indexSource == indexTarget) {
                return target;
            }
            mapCenter.multiply((double)(1 / teams.size()));
            double rotationAngle = (double)indexSource * Math.PI * 2.0 / (double)teams.size() + (double)indexTarget * Math.PI * 2.0 / (double)teams.size();
            Vector difference = mapCenter.toVector().subtract(original.toVector());
            Vector rotated = new Vector(difference.getX() * Math.cos(rotationAngle) + difference.getZ() * Math.sin(rotationAngle), difference.getY(), difference.getZ() * Math.cos(rotationAngle) + difference.getX() * -Math.sin(rotationAngle));
            mapCenter.subtract(rotated);
            mapCenter.setPitch(original.getPitch());
            mapCenter.setYaw((float)((double)original.getYaw() + rotationAngle / Math.PI * 180.0));
            return mapCenter;
        }
    }
    ,
    MIRROR{

        @Override
        public Location getOppositeLocation(Game game, Team sourceTeam, Team targetTeam, Location original, Location target) {
            return target;
        }
    };


    public MapSymmetryMarker asMarker() {
        return new MapSymmetryMarker(){

            @Override
            public MapSymmetry getSymmetry() {
                return MapSymmetry.this;
            }

            public String toString() {
                return MapSymmetry.this.toString();
            }
        };
    }

    public Option asOption() {
        return this.asMarker().asOption();
    }

    public abstract Location getOppositeLocation(Game var1, Team var2, Team var3, Location var4, Location var5);
}

