/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.AbstractScoreOnEventOption;
import com.ebicep.warlords.game.option.BasicScoreboardOption;
import com.ebicep.warlords.game.option.BoundingBoxOption;
import com.ebicep.warlords.game.option.FlagCapturePointOption;
import com.ebicep.warlords.game.option.FlagSpawnPointOption;
import com.ebicep.warlords.game.option.GameOvertimeOption;
import com.ebicep.warlords.game.option.GateOption;
import com.ebicep.warlords.game.option.GraveOption;
import com.ebicep.warlords.game.option.MercyWinOption;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.PowerupOption;
import com.ebicep.warlords.game.option.RespawnProtectionOption;
import com.ebicep.warlords.game.option.RespawnWaveOption;
import com.ebicep.warlords.game.option.SpawnpointOption;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import com.ebicep.warlords.game.option.WinByPointsOption;
import com.ebicep.warlords.game.option.marker.LobbyLocationMarker;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.state.PreLobbyState;
import com.ebicep.warlords.game.state.State;
import com.ebicep.warlords.util.bukkit.LocationFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public enum GameMap {
    RIFT("Rift", 32, 12, 1200, "", new GameMode[]{GameMode.CAPTURE_THE_FLAG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(-86.5, 46.0, -33.5), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(87.5, 46.0, 35.5, 180.0f, 0.0f), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(-32.5, 25.5, 49.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(33.5, 25.5, -48.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(-54.5, 36.5, 24.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(55.5, 36.5, -23.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(-0.5, 24.5, 64.5), PowerupOption.PowerupType.HEALING));
            options.add(new PowerupOption(loc.addXYZ(1.5, 24.5, -62.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(-32.5, 34.5, -43.5, -90.0f, 0.0f), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(33.0, 34.5, 45.0, 90.0f, 0.0f), Team.RED));
            switch (category) {
                case CAPTURE_THE_FLAG: {
                    options.add(new FlagCapturePointOption((Location)loc.addXYZ(-98.5, 45.5, -17.5, -90.0f, 0.0f), Team.BLUE));
                    options.add(new FlagSpawnPointOption(loc.addXYZ(-98.5, 45.5, -17.5, -90.0f, 0.0f), Team.BLUE));
                    options.add(new FlagCapturePointOption((Location)loc.addXYZ(99.5, 45.5, 17.5, 90.0f, 0.0f), Team.RED));
                    options.add(new FlagSpawnPointOption(loc.addXYZ(99.5, 45.5, 17.5, 90.0f, 0.0f), Team.RED));
                    options.add(new AbstractScoreOnEventOption.FlagCapture(250));
                    break;
                }
                default: {
                    throw new IllegalStateException("Not prepared to handle gamemode " + (Object)((Object)category));
                }
            }
            options.add(new GateOption(loc, -79.0, 45.0, -29.0, -79.0, 49.0, -24.0));
            options.add(new GateOption(loc, -91.0, 45.0, -6.0, -86.0, 49.0, -6.0));
            options.add(new GateOption(loc, 79.0, 45.0, 25.0, 79.0, 49.0, 29.0));
            options.add(new GateOption(loc, 87.0, 45.0, 6.0, 91.0, 49.0, 6.0));
            options.add(new WinByPointsOption());
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.OnKill(5));
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    }
    ,
    CROSSFIRE("Crossfire", 32, 12, 1200, "", new GameMode[]{GameMode.CAPTURE_THE_FLAG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(215.5, 37.0, 109.5), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(7.5, 37.0, 19.5, 180.0f, 0.0f), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(158.5, 6.5, 28.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(65.5, 6.5, 98.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(217.5, 36.5, 89.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(6.5, 36.5, 39.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(96.5, 6.5, 108.5), PowerupOption.PowerupType.HEALING));
            options.add(new PowerupOption(loc.addXYZ(127.5, 6.5, 19.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(133.0, 11.5, 130.5, 125.0f, 0.0f), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(91.0, 11.5, -2.5, -55.0f, 0.0f), Team.RED));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(217.5, 36.5, 126.5, 150.0f, 0.0f), Team.BLUE));
            options.add(new FlagSpawnPointOption(loc.addXYZ(217.5, 36.5, 126.5, 150.0f, 0.0f), Team.BLUE));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(5.5, 36.5, 1.5, -25.0f, 0.0f), Team.RED));
            options.add(new FlagSpawnPointOption(loc.addXYZ(5.5, 36.5, 1.5, -25.0f, 0.0f), Team.RED));
            options.add(new GateOption(loc.addXYZ(203.0, 36.0, 119.0), loc.addXYZ(203.0, 42.0, 124.0)));
            options.add(new GateOption(loc.addXYZ(227.0, 36.0, 109.0), loc.addXYZ(227.0, 40.0, 115.0)));
            options.add(new GateOption(loc.addXYZ(19.0, 36.0, 4.0), loc.addXYZ(19.0, 40.0, 9.0)));
            options.add(new GateOption(loc.addXYZ(-3.0, 36.0, 14.0), loc.addXYZ(-3.0, 40.0, 18.0)));
            options.add(new WinByPointsOption());
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.FlagCapture());
            options.add(new AbstractScoreOnEventOption.OnKill());
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    }
    ,
    WARSONG("Warsong Remastered", 32, 12, 1200, "", new GameMode[]{GameMode.CAPTURE_THE_FLAG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(71.5, 40.0, -71.5, 90.0f, 0.0f), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(73.5, 41.0, 213.5, -90.0f, 0.0f), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(102.5, 21.5, 51.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(42.5, 21.5, 92.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(63.5, 33.5, -31.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(79.5, 32.5, 167.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(44.5, 20.5, 42.5), PowerupOption.PowerupType.HEALING));
            options.add(new PowerupOption(loc.addXYZ(100.5, 20.5, 101.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(45.5, 29.5, 15.5, -30.0f, 0.0f), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(99.5, 29.5, 128.5, 150.0f, 0.0f), Team.RED));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(56.5, 39.5, -76.5), Team.BLUE));
            options.add(new FlagSpawnPointOption(loc.addXYZ(56.5, 39.5, -76.5), Team.BLUE));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(88.5, 39.5, 218.5, 180.0f, 0.0f), Team.RED));
            options.add(new FlagSpawnPointOption(loc.addXYZ(88.5, 39.5, 218.5, 180.0f, 0.0f), Team.RED));
            options.add(new GateOption(loc.addXYZ(42.0, 39.0, -52.0), loc.addXYZ(47.0, 45.0, -52.0)));
            options.add(new GateOption(loc.addXYZ(69.0, 35.0, -52.0), loc.addXYZ(75.0, 43.0, -52.0)));
            options.add(new GateOption(loc.addXYZ(70.0, 36.0, 195.0), loc.addXYZ(75.0, 43.0, 195.0)));
            options.add(new GateOption(loc.addXYZ(97.0, 39.0, 195.0), loc.addXYZ(104.0, 45.0, 195.0)));
            options.add(new WinByPointsOption());
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.FlagCapture());
            options.add(new AbstractScoreOnEventOption.OnKill());
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    }
    ,
    VALLEY("Atherrough Valley", 32, 12, 1200, "", new GameMode[]{GameMode.CAPTURE_THE_FLAG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(-22.5, 39.0, -83.5, -180.0f, 0.0f), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(23.5, 39.0, 83.5), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(5.5, 15.5, -33.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(-4.5, 15.5, 34.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(4.5, 25.5, -86.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(-3.5, 25.5, 87.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(57.5, 15.5, 1.5), PowerupOption.PowerupType.HEALING));
            options.add(new PowerupOption(loc.addXYZ(-56.5, 15.5, -0.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(39.5, 28.5, -97.5), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(-38.5, 28.5, 97.5, -180.0f, 0.0f), Team.RED));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(-29.5, 38.5, -88.5, -90.0f, 0.0f), Team.BLUE));
            options.add(new FlagSpawnPointOption(loc.addXYZ(-29.5, 38.5, -88.5, -90.0f, 0.0f), Team.BLUE));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(30.5, 38.5, 89.5, 90.0f, 0.0f), Team.RED));
            options.add(new FlagSpawnPointOption(loc.addXYZ(30.5, 38.5, 89.5, 90.0f, 0.0f), Team.RED));
            options.add(new GateOption(loc.addXYZ(-26.0, 33.0, -96.0), loc.addXYZ(-19.0, 40.0, -96.0)));
            options.add(new GateOption(loc.addXYZ(-28.0, 31.0, -81.0), loc.addXYZ(-28.0, 41.0, -75.0)));
            options.add(new GateOption(loc.addXYZ(20.0, 33.0, 96.0), loc.addXYZ(26.0, 42.0, 96.0)));
            options.add(new GateOption(loc.addXYZ(29.0, 31.0, 76.0), loc.addXYZ(29.0, 41.0, 82.0)));
            options.add(new WinByPointsOption());
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.FlagCapture());
            options.add(new AbstractScoreOnEventOption.OnKill());
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    }
    ,
    APERTURE("Aperture", 32, 12, 1200, "", new GameMode[]{GameMode.CAPTURE_THE_FLAG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(513.5, 37.5, 243.5, -90.0f, 0.0f), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(687.5, 37.5, 231.5, 90.0f, 0.0f), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(608.5, 16.5, 280.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(592.5, 16.5, 194.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(551.5, 31.5, 217.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(649.5, 31.5, 257.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(577.5, 22.5, 286.5), PowerupOption.PowerupType.HEALING));
            options.add(new PowerupOption(loc.addXYZ(623.5, 22.5, 188.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(560.5, 32.5, 294.5, -140.0f, 0.0f), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(640.5, 32.5, 180.5, 40.0f, 0.0f), Team.RED));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(522.5, 37.5, 233.5, 90.0f, 0.0f), Team.BLUE));
            options.add(new FlagSpawnPointOption(loc.addXYZ(522.5, 37.5, 233.5, 90.0f, 0.0f), Team.BLUE));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(678.5, 37.5, 241.1, -90.0f, 0.0f), Team.RED));
            options.add(new FlagSpawnPointOption(loc.addXYZ(678.5, 37.5, 241.1, -90.0f, 0.0f), Team.RED));
            options.add(new GateOption(loc.addXYZ(665.0, 36.0, 228.0), loc.addXYZ(665.0, 40.0, 232.0)));
            options.add(new GateOption(loc.addXYZ(683.0, 36.0, 252.0), loc.addXYZ(690.0, 40.0, 252.0)));
            options.add(new GateOption(loc.addXYZ(663.0, 42.0, 212.0), loc.addXYZ(663.0, 46.0, 215.0)));
            options.add(new GateOption(loc.addXYZ(535.0, 36.0, 242.0), loc.addXYZ(535.0, 40.0, 247.0)));
            options.add(new GateOption(loc.addXYZ(510.0, 36.0, 222.0), loc.addXYZ(518.0, 40.0, 222.0)));
            options.add(new GateOption(loc.addXYZ(537.0, 42.0, 262.0), loc.addXYZ(537.0, 46.0, 259.0)));
            options.add(new WinByPointsOption());
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.FlagCapture());
            options.add(new AbstractScoreOnEventOption.OnKill());
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    }
    ,
    ARATHI("Arathi", 48, 16, 1200, "", new GameMode[]{GameMode.DEBUG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(173.5, 67.0, 426.5), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(736.5, 67.0, 450.5).yaw(-180.0f), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(455.5, 67.5, 423.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(604.5, 56.5, 465.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(298.5, 56.5, 430.5), PowerupOption.PowerupType.DAMAGE));
            options.add(new PowerupOption(loc.addXYZ(425.5, 15.5, 272.5), PowerupOption.PowerupType.DAMAGE));
            options.add(new PowerupOption(loc.addXYZ(449.5, 95.5, 600.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(173.5, 67.0, 426.5), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(736.5, 67.0, 450.5, -180.0f, 0.0f), Team.RED));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(162.5, 70.5, 445.5, -90.0f, 0.0f), Team.BLUE));
            options.add(new FlagSpawnPointOption(loc.addXYZ(162.5, 70.5, 445.5, -90.0f, 0.0f), Team.BLUE));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(749.5, 70.5, 439.5, 90.0f, 0.0f), Team.RED));
            options.add(new FlagSpawnPointOption(loc.addXYZ(749.5, 70.5, 439.5, 90.0f, 0.0f), Team.RED));
            options.add(new GateOption(loc.addXYZ(183.0, 67.0, 447.0), loc.addXYZ(183.0, 64.0, 443.0)));
            options.add(new GateOption(loc.addXYZ(727.0, 67.0, 437.0), loc.addXYZ(727.0, 64.0, 441.0)));
            options.add(new WinByPointsOption(2000));
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.FlagCapture());
            options.add(new AbstractScoreOnEventOption.OnKill());
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    }
    ,
    DEBUG("Debug", 96, 1, 1200, "WLDebug", new GameMode[]{GameMode.DEBUG}){

        @Override
        public List<Option> initMap(GameMode category, LocationFactory loc, EnumSet<GameAddon> addons) {
            List<Option> options = category.initMap(this, loc, addons);
            options.add(TeamMarker.create(Team.BLUE, Team.RED).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(727.5, 8.5, 200.5), Team.BLUE).asOption());
            options.add(LobbyLocationMarker.create(loc.addXYZ(727.5, 8.5, 196.5), Team.RED).asOption());
            options.add(new PowerupOption(loc.addXYZ(699.5, 8.5, 184.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(699.5, 8.5, 188.5), PowerupOption.PowerupType.ENERGY));
            options.add(new PowerupOption(loc.addXYZ(699.5, 8.5, 192.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(699.5, 8.5, 196.5), PowerupOption.PowerupType.SPEED));
            options.add(new PowerupOption(loc.addXYZ(699.5, 8.5, 200.5), PowerupOption.PowerupType.HEALING));
            options.add(new PowerupOption(loc.addXYZ(699.5, 8.5, 204.5), PowerupOption.PowerupType.HEALING));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(727.5, 8.5, 196.5), Team.BLUE));
            options.add(SpawnpointOption.forTeam(loc.addXYZ(727.5, 8.5, 196.5), Team.RED));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(703.5, 8.5, 212.5), Team.BLUE));
            options.add(new FlagSpawnPointOption(loc.addXYZ(703.5, 8.5, 212.5), Team.BLUE));
            options.add(new FlagCapturePointOption((Location)loc.addXYZ(720.5, 8.5, 212.5), Team.RED));
            options.add(new FlagSpawnPointOption(loc.addXYZ(720.5, 8.5, 212.5), Team.RED));
            options.add(new GateOption(loc.addXYZ(713.0, 7.0, 195.0), loc.addXYZ(713.0, 10.0, 198.0)));
            options.add(new WinByPointsOption());
            options.add(new MercyWinOption());
            if (addons.contains((Object)GameAddon.DOUBLE_TIME)) {
                options.add(new WinAfterTimeoutOption(1800));
            } else {
                options.add(new WinAfterTimeoutOption());
            }
            options.add(new GameOvertimeOption());
            options.add(new AbstractScoreOnEventOption.FlagCapture());
            options.add(new AbstractScoreOnEventOption.OnKill());
            options.add(new RespawnWaveOption());
            options.add(new RespawnProtectionOption());
            options.add(new GraveOption());
            options.add(new BasicScoreboardOption());
            options.add(new BoundingBoxOption(loc.getWorld()));
            return options;
        }
    };

    private final String mapName;
    private final int maxPlayers;
    private final int minPlayers;
    private final int lobbyCountdown;
    private final String mapDirPath;
    private final List<GameMode> gameMode;

    private GameMap(String mapName, int maxPlayers, @Nonnull int minPlayers, @Nonnull int lobbyCountdown, String mapDirPath, GameMode ... gameMode) {
        this.mapName = mapName;
        this.maxPlayers = maxPlayers;
        this.minPlayers = minPlayers;
        this.lobbyCountdown = lobbyCountdown;
        this.mapDirPath = mapDirPath;
        this.gameMode = Collections.unmodifiableList(Arrays.asList(gameMode));
    }

    public abstract List<Option> initMap(GameMode var1, LocationFactory var2, EnumSet<GameAddon> var3);

    public State initialState(Game game) {
        return new PreLobbyState(game);
    }

    public String getMapName() {
        return this.mapName;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getLobbyCountdown() {
        return this.lobbyCountdown;
    }

    public String getMapDirPath() {
        return this.mapDirPath;
    }

    public List<GameMode> getGameModes() {
        return this.gameMode;
    }

    public static GameMap getGameMap(String mapName) {
        for (GameMap value : GameMap.values()) {
            if (!value.mapName.equalsIgnoreCase(mapName)) continue;
            return value;
        }
        return null;
    }
}

