/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameMap;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.util.bukkit.LocationFactory;
import com.ebicep.warlords.util.java.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class GameManager
implements AutoCloseable {
    private final List<GameHolder> games = new ArrayList<GameHolder>();
    private final LinkedList<QueueEntry> queue = new LinkedList();

    public List<GameHolder> getGames() {
        return this.games;
    }

    @Nullable
    private GameHolder findSuitableGame(@Nonnull QueueEntry entry) {
        GameHolder selected = null;
        int newGamesSeen = 0;
        for (GameHolder next : this.games) {
            Game game;
            if (entry.getMap() != null && entry.getMap() != next.getMap() || entry.getCategory() != null && !next.getMap().getGameModes().contains((Object)entry.getCategory())) continue;
            if (next.getGame() != null && (next.getGame().playersCount() == 0 || next.getGame().isClosed())) {
                next.forceEndGame();
            }
            if ((game = next.getGame()) == null) {
                int computedMaxPlayers = next.getMap().getMaxPlayers();
                for (GameAddon addon : entry.getRequestedGameAddons()) {
                    if (!addon.canCreateGame(next)) continue;
                    computedMaxPlayers = addon.getMaxPlayers(next.getMap(), computedMaxPlayers);
                }
                if (computedMaxPlayers < entry.getPlayers().size()) continue;
                ++newGamesSeen;
                if (selected == null) {
                    selected = next;
                    continue;
                }
                if (selected.getGame() != null || !(Math.random() * (double)newGamesSeen < 1.0)) continue;
                selected = next;
                continue;
            }
            if (!game.acceptsPeople() || !entry.getRequestedGameAddons().equals(game.getAddons()) || game.getMaxPlayers() - game.playersCount() < entry.getPlayers().size() || entry.getCategory() != null && game.getGameMode() != entry.getCategory()) continue;
            if (selected == null) {
                selected = next;
                continue;
            }
            if (selected.getGame() == null) {
                selected = next;
                continue;
            }
            if (selected.getGame().createdAt() < game.createdAt()) continue;
            selected = next;
        }
        return selected;
    }

    private void runQueue() {
        long now = System.currentTimeMillis();
        Iterator itr = this.queue.iterator();
        while (itr.hasNext()) {
            Game game;
            GameHolder selected;
            QueueEntry entry = (QueueEntry)itr.next();
            if (entry == null) {
                return;
            }
            try {
                selected = this.findSuitableGame(entry);
            }
            catch (Throwable e) {
                entry.onResult(QueueResult.ERROR_FIND_GAME, null);
                throw e;
            }
            if (selected == null) {
                if (now <= entry.getExpireTime()) continue;
                itr.remove();
                entry.onResult(QueueResult.EXPIRED, null);
                continue;
            }
            itr.remove();
            boolean isNewGame = selected.getGame() == null;
            try {
                game = selected.optionallyStartNewGame(entry.getRequestedGameAddons(), entry.getCategory());
            }
            catch (Throwable e) {
                entry.onResult(QueueResult.ERROR_NEW_GAME, null);
                throw e;
            }
            entry.onResult(isNewGame ? QueueResult.READY_NEW : QueueResult.READY_JOIN, game);
            for (OfflinePlayer player : entry.getPlayers()) {
                game.addPlayer(player, false);
            }
        }
    }

    public void dropPlayerFromQueueOrGames(OfflinePlayer player) {
        this.dropPlayerFromQueueOrGames(player, false);
    }

    private void dropPlayerFromQueueOrGames(OfflinePlayer player, boolean wouldBeReplaced) {
        Iterator itr = this.queue.iterator();
        while (itr.hasNext()) {
            QueueEntry entry = (QueueEntry)itr.next();
            if (!entry.players.contains(player)) continue;
            itr.remove();
            entry.onResult(wouldBeReplaced ? QueueResult.REPLACED : QueueResult.CANCELLED, null);
        }
        for (GameHolder holder : this.games) {
            if (holder.getGame() == null || !holder.getGame().acceptsPeople() && !wouldBeReplaced) continue;
            holder.getGame().removePlayer(player.getUniqueId());
        }
    }

    public long getPlayerCount() {
        return this.games.stream().mapToInt(e -> e.getGame() == null ? 0 : e.getGame().getPlayers().size()).sum();
    }

    public long getPlayerCountInLobby() {
        return this.games.stream().mapToInt(e -> {
            Game game = e.getGame();
            if (game == null) {
                return 0;
            }
            if (!game.acceptsPeople()) {
                return 0;
            }
            return game.getPlayers().size();
        }).sum();
    }

    public long getQueueSize() {
        return this.queue.size();
    }

    public long getQueuePlayerCount() {
        return this.queue.stream().map(e -> e.getPlayers().size()).collect(Collectors.counting());
    }

    private boolean queue(QueueEntry entry) {
        if (entry.getPlayers().isEmpty()) {
            throw new IllegalArgumentException("Cannot queue an entry with 0 players");
        }
        if (this.queue.contains(entry)) {
            throw new IllegalArgumentException("Queue entry already exists");
        }
        boolean valid = false;
        boolean invalidOversize = false;
        boolean invalidMapCategory = false;
        for (GameHolder next : this.games) {
            if (entry.getMap() != null && entry.getMap() != next.getMap()) continue;
            if (entry.getCategory() != null && !next.getMap().getGameModes().contains((Object)entry.getCategory())) {
                invalidMapCategory = true;
                continue;
            }
            int computedMaxPlayers = next.getMap().getMaxPlayers();
            for (GameAddon addon : entry.getRequestedGameAddons()) {
                if (!addon.canCreateGame(next)) continue;
                computedMaxPlayers = addon.getMaxPlayers(next.getMap(), computedMaxPlayers);
            }
            if (computedMaxPlayers < entry.getPlayers().size()) {
                invalidOversize = true;
                continue;
            }
            valid = true;
            break;
        }
        if (!valid) {
            entry.onResult(invalidOversize ? QueueResult.INVALID_OVERSIZE : (invalidMapCategory ? QueueResult.INVALID_MAP_CATEGORY : QueueResult.INVALID_GENERIC), null);
            return false;
        }
        for (OfflinePlayer p : entry.getPlayers()) {
            this.dropPlayerFromQueueOrGames(p, true);
        }
        boolean inserted = false;
        ListIterator<QueueEntry> listIterator = this.queue.listIterator(this.queue.size());
        while (listIterator.hasPrevious()) {
            QueueEntry previous = listIterator.previous();
            if (previous.compareTo(entry) <= 0) continue;
            listIterator.add(entry);
            inserted = true;
            break;
        }
        if (!inserted) {
            listIterator.add(entry);
        }
        this.runQueue();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<QueueResult, Game> queueNow(QueueEntry entry) {
        BiConsumer<QueueResult, Game> onResult = entry.getOnResult();
        try {
            AtomicReference<Object> res = new AtomicReference<Object>(null);
            AtomicReference<Object> game = new AtomicReference<Object>(null);
            entry.setOnResult((result, g2) -> {
                res.set(result);
                game.set(g2);
            });
            if (!this.queue(entry)) {
                Pair<QueueResult, Object> pair = new Pair<QueueResult, Object>(QueueResult.INVALID_GENERIC, null);
                return pair;
            }
            this.runQueue();
            QueueResult val = res.get();
            Game g3 = game.get();
            if (val == null) {
                val = QueueResult.EXPIRED;
            }
            if (onResult != null) {
                onResult.accept(val, g3);
            }
            Pair<QueueResult, Game> pair = new Pair<QueueResult, Game>(val, g3);
            return pair;
        }
        finally {
            this.queue.remove(entry);
            entry.setOnResult(onResult);
        }
    }

    public QueueEntryBuilder newEntry(Collection<? extends OfflinePlayer> players) {
        return new QueueEntryBuilder(players, null);
    }

    public QueueEntryBuilder newEntry(Collection<? extends OfflinePlayer> players, @Nullable BiConsumer<QueueResult, Game> onResult) {
        return new QueueEntryBuilder(players, onResult);
    }

    @Nonnull
    public Optional<Game> getPlayerGame(UUID player) {
        return this.games.stream().filter(e -> e.getGame() != null && e.getGame().hasPlayer(player)).map(e -> e.getGame()).findAny();
    }

    @Override
    public void close() {
        for (QueueEntry entry : this.queue) {
            entry.onResult(QueueResult.CLOSE, null);
        }
        this.queue.clear();
        for (GameHolder next : this.games) {
            next.forceEndGame();
        }
        this.games.clear();
    }

    public void addGameHolder(String name, GameMap map, World world) {
        this.addGameHolder(name, map, new LocationFactory(world));
    }

    public void addGameHolder(String name, GameMap map, LocationFactory locations) {
        this.games.add(new GameHolder(map, locations, name));
    }

    public class QueueEntryBuilder {
        @Nonnull
        protected List<OfflinePlayer> players;
        @Nonnull
        protected EnumSet<GameAddon> requestedGameAddons = EnumSet.noneOf(GameAddon.class);
        @Nullable
        protected GameMode category = null;
        @Nullable
        protected GameMap map = null;
        protected int priority = 0;
        @Nullable
        private BiConsumer<QueueResult, Game> onResult;
        private long expiresTime = Long.MAX_VALUE;

        public QueueEntryBuilder(@Nullable Collection<? extends OfflinePlayer> players, BiConsumer<QueueResult, Game> onResult) {
            this.players = new ArrayList<OfflinePlayer>(players);
            this.onResult = onResult;
        }

        public QueueEntryBuilder setPlayers(@Nonnull Collection<? extends OfflinePlayer> players) {
            this.players = new ArrayList<OfflinePlayer>(players);
            return this;
        }

        public QueueEntryBuilder setRequestedGameAddons(@Nonnull EnumSet<GameAddon> requestedGameAddons) {
            this.requestedGameAddons = requestedGameAddons.clone();
            return this;
        }

        public QueueEntryBuilder setRequestedGameAddons(GameAddon ... rga) {
            return this.setRequestedGameAddons(rga.length == 0 ? EnumSet.noneOf(GameAddon.class) : EnumSet.copyOf(Arrays.asList(rga)));
        }

        public QueueEntryBuilder setCategory(@Nullable GameMode category) {
            this.category = category;
            return this;
        }

        public QueueEntryBuilder setMap(@Nullable GameMap map) {
            this.map = map;
            return this;
        }

        public QueueEntryBuilder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public List<OfflinePlayer> getPlayers() {
            return this.players;
        }

        @Nonnull
        public EnumSet<GameAddon> getRequestedGameAddons() {
            return this.requestedGameAddons;
        }

        @Nullable
        public GameMode getCategory() {
            return this.category;
        }

        @Nullable
        public GameMap getMap() {
            return this.map;
        }

        public int getPriority() {
            return this.priority;
        }

        public QueueEntryBuilder setExpiresTime(long expiresTime) {
            this.expiresTime = expiresTime;
            return this;
        }

        public QueueEntryBuilder setOnResult(@Nonnull BiConsumer<QueueResult, Game> onResult) {
            this.onResult = onResult;
            return this;
        }

        @Nonnull
        public BiConsumer<QueueResult, Game> getOnResult() {
            return this.onResult;
        }

        public long getExpiresTime() {
            return this.expiresTime;
        }

        public void queue() {
            GameManager.this.queue(new QueueEntry(this.players, this.expiresTime, this.requestedGameAddons, this.category, this.map, this.onResult, this.priority));
        }

        @Nonnull
        public Pair<QueueResult, Game> queueNow() {
            return GameManager.this.queueNow(new QueueEntry(this.players, Long.MIN_VALUE, this.requestedGameAddons, this.category, this.map, null, this.priority));
        }
    }

    public static enum QueueResult {
        READY_JOIN("You have joined an existing game."),
        READY_NEW("A new game has been made for you."),
        ERROR_FIND_GAME("We were unable to create a new game for you because of an internal error. Please report this."),
        ERROR_NEW_GAME("We were unable to find a new for you because of an internal error. Please report this."),
        EXPIRED("No game found in time"),
        CANCELLED("Cancelled queueing"),
        REPLACED("Replaced with another queue entry"),
        INVALID_GENERIC("Your request to queue was invalid because of an unknown reason. Please report this."),
        INVALID_OVERSIZE("Your request to queue was invalid because your party was too big for the specified map/game."),
        INVALID_MAP_CATEGORY("Your request to queue was invalid because the combination of map/category was not found."),
        CLOSE("The queue has been closed");

        private final String message;

        private QueueResult(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    private static class QueueEntry
    implements Comparable<QueueEntry> {
        private static final AtomicInteger SEQUENCE = new AtomicInteger();
        @Nonnull
        private final List<OfflinePlayer> players;
        private final long expireTime;
        @Nonnull
        private final EnumSet<GameAddon> requestedGameAddons;
        @Nullable
        private final GameMode category;
        @Nullable
        private final GameMap map;
        @Nullable
        private BiConsumer<QueueResult, Game> onResult;
        private final int priority;
        private final int insertionId;

        public QueueEntry(@Nonnull List<OfflinePlayer> players, long expiresTime, @Nonnull EnumSet<GameAddon> requestedGameAddons, @Nullable GameMode category, @Nullable GameMap map, @Nullable BiConsumer<QueueResult, Game> onResult, int priority) {
            this.players = Objects.requireNonNull(players, "players");
            this.expireTime = expiresTime;
            this.requestedGameAddons = Objects.requireNonNull(requestedGameAddons, "requestedGameAddons");
            this.category = category;
            this.map = map;
            this.onResult = onResult;
            this.priority = priority;
            this.insertionId = SEQUENCE.incrementAndGet();
        }

        @Nonnull
        public List<OfflinePlayer> getPlayers() {
            return this.players;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        @Nonnull
        public EnumSet<GameAddon> getRequestedGameAddons() {
            return this.requestedGameAddons;
        }

        public GameMode getCategory() {
            return this.category;
        }

        @Nullable
        public GameMap getMap() {
            return this.map;
        }

        @Nullable
        public BiConsumer<QueueResult, Game> getOnResult() {
            return this.onResult;
        }

        public void onResult(@Nonnull QueueResult res, @Nullable Game game) {
            if (this.onResult != null) {
                this.onResult.accept(res, game);
            }
        }

        public void setOnResult(BiConsumer<QueueResult, Game> onResult) {
            this.onResult = onResult;
        }

        @Override
        public int compareTo(QueueEntry o) {
            int c = Integer.compare(this.priority, o.priority);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.insertionId, o.insertionId);
        }
    }

    public static class GameHolder {
        @Nullable
        private Game game;
        @Nonnull
        private final GameMap map;
        @Nonnull
        private final LocationFactory locations;
        @Nonnull
        private final String name;

        public GameHolder(GameMap map, LocationFactory locations, String name) {
            this.map = map;
            this.locations = locations;
            this.name = name;
        }

        public GameMap getMap() {
            return this.map;
        }

        @Nullable
        public Game getGame() {
            return this.game;
        }

        public void forceEndGame() {
            if (this.game != null) {
                this.game.close();
                this.game = null;
            }
        }

        @Nonnull
        private Game optionallyStartNewGame(@Nonnull EnumSet<GameAddon> requestedGameAddons, @Nullable GameMode category) {
            if (this.game == null) {
                GameMode newCategory = category != null ? category : this.map.getGameModes().get((int)(Math.random() * (double)this.map.getGameModes().size()));
                this.game = new Game(requestedGameAddons, this.map, newCategory, this.locations);
                this.game.start();
            }
            if (!this.game.getAddons().equals(requestedGameAddons)) {
                throw new IllegalArgumentException('[' + this.name + "] The requested game addons do not match the actual game addons: " + requestedGameAddons + " vs " + this.game.getAddons());
            }
            if (category != null && !this.game.getGameMode().equals((Object)category)) {
                throw new IllegalArgumentException('[' + this.name + "] The requested game category do not match the actual game category: " + (Object)((Object)category) + " vs " + (Object)((Object)this.game.getGameMode()));
            }
            return this.game;
        }

        public String getName() {
            return this.name;
        }
    }
}

