/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.game;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.events.AbstractWarlordsGameEvent;
import com.ebicep.warlords.events.WarlordsEvents;
import com.ebicep.warlords.events.WarlordsGameUpdatedEvent;
import com.ebicep.warlords.events.WarlordsPointsChangedEvent;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameMap;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.Option;
import com.ebicep.warlords.game.option.marker.GameMarker;
import com.ebicep.warlords.game.option.marker.TeamMarker;
import com.ebicep.warlords.game.option.marker.scoreboard.ScoreboardHandler;
import com.ebicep.warlords.game.state.ClosedState;
import com.ebicep.warlords.game.state.State;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.LocationFactory;
import com.ebicep.warlords.util.warlords.GameRunnable;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitTask;

public final class Game
implements Runnable,
AutoCloseable {
    public static final String KEY_UPDATED_FROZEN = "frozen";
    private final UUID gameId = UUID.randomUUID();
    private final Map<UUID, Team> players = new HashMap<UUID, Team>();
    private final long createdAt = System.currentTimeMillis();
    private final List<BukkitTask> gameTasks = new ArrayList<BukkitTask>();
    private final List<Listener> eventHandlers = new ArrayList<Listener>();
    private final EnumMap<Team, Integer> points = new EnumMap(Team.class);
    @Nonnull
    private final GameMap map;
    @Nonnull
    private final GameMode gameMode;
    @Nonnull
    private final EnumSet<GameAddon> addons;
    @Nonnull
    private List<Option> options;
    @Nullable
    private State state = null;
    @Nullable
    private State nextState = null;
    private boolean closed = false;
    private final List<String> frozenCauses = new CopyOnWriteArrayList<String>();
    private boolean unfreezeCooldown = false;
    private int maxPlayers;
    private int minPlayers;
    private boolean acceptsPlayers;
    private boolean acceptsSpectators;
    private final LocationFactory locations;
    private final Map<Class<? extends GameMarker>, List<GameMarker>> gameMarkers = new HashMap<Class<? extends GameMarker>, List<GameMarker>>();

    public Game(EnumSet<GameAddon> gameAddons, GameMap map, GameMode gameMode, LocationFactory locations) {
        this(gameAddons, map, gameMode, locations, map.initMap(gameMode, locations, gameAddons));
    }

    Game(EnumSet<GameAddon> gameAddons, GameMap map, GameMode gameMode, LocationFactory locations, List<Option> options) {
        this.locations = locations;
        this.addons = gameAddons;
        this.map = map;
        this.gameMode = gameMode;
        this.options = new ArrayList<Option>(options);
        this.minPlayers = map.getMinPlayers();
        this.maxPlayers = map.getMaxPlayers();
        for (GameAddon addon : gameAddons) {
            this.maxPlayers = addon.getMaxPlayers(map, this.maxPlayers);
        }
    }

    public void start() {
        if (this.state != null) {
            throw new IllegalStateException("Game already started");
        }
        for (GameAddon addon : this.addons) {
            addon.modifyGame(this);
        }
        this.options = Collections.unmodifiableList(this.options);
        this.state = this.map.initialState(this);
        for (Option option : this.options) {
            option.register(this);
        }
        for (Team team : TeamMarker.getTeams(this)) {
            this.points.put(team, 0);
        }
        this.state.begin();
        for (GameAddon addon : this.addons) {
            addon.stateHasChanged(this, null, this.state);
        }
        new GameRunnable(this){

            @Override
            public void run() {
                Game.this.run();
            }
        }.runTaskTimer(0L, 1L);
    }

    public boolean isState(Class<? extends State> clazz) {
        if (this.state == null) {
            throw new IllegalStateException("The game is not started yet");
        }
        return clazz.isAssignableFrom(this.state.getClass());
    }

    public <T extends State> Optional<T> getState(Class<T> clazz) {
        if (this.state == null) {
            throw new IllegalStateException("The game is not started yet");
        }
        if (clazz.isAssignableFrom(this.state.getClass())) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    @Nonnull
    public State getState() {
        if (this.state == null) {
            throw new IllegalStateException("The game is not started yet");
        }
        return this.state;
    }

    @Nonnull
    public GameMap getMap() {
        return this.map;
    }

    @Nonnull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    public LocationFactory getLocations() {
        return this.locations;
    }

    public boolean isFrozen() {
        return !this.frozenCauses.isEmpty();
    }

    @Nonnull
    public List<String> getFrozenCauses() {
        return Collections.unmodifiableList(this.frozenCauses);
    }

    public void addFrozenCause(String cause) {
        this.frozenCauses.add(cause);
        Bukkit.getPluginManager().callEvent((Event)new WarlordsGameUpdatedEvent(this, KEY_UPDATED_FROZEN));
    }

    public void removeFrozenCause(String cause) {
        this.frozenCauses.remove(cause);
        Bukkit.getPluginManager().callEvent((Event)new WarlordsGameUpdatedEvent(this, KEY_UPDATED_FROZEN));
    }

    public void clearFrozenCauses() {
        this.frozenCauses.clear();
        Bukkit.getPluginManager().callEvent((Event)new WarlordsGameUpdatedEvent(this, KEY_UPDATED_FROZEN));
    }

    public boolean isUnfreezeCooldown() {
        return this.unfreezeCooldown;
    }

    public void setUnfreezeCooldown(boolean unfreezeCooldown) {
        this.unfreezeCooldown = unfreezeCooldown;
    }

    public UUID getGameId() {
        return this.gameId;
    }

    @Nonnull
    public EnumSet<GameAddon> getAddons() {
        return this.addons;
    }

    @Nonnull
    public List<Option> getOptions() {
        return this.options;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public void setMinPlayers(int minPlayers) {
        this.minPlayers = minPlayers;
    }

    public boolean acceptsPeople() {
        return this.acceptsPlayers;
    }

    public void setAcceptsPlayers(boolean acceptsPlayers) {
        if (this.closed) {
            throw new IllegalStateException("Game has been closed");
        }
        this.acceptsPlayers = acceptsPlayers;
    }

    public boolean acceptsSpectators() {
        return this.acceptsSpectators;
    }

    public void setAcceptsSpectators(boolean acceptsSpectators) {
        if (this.closed) {
            throw new IllegalStateException("Game has been closed");
        }
        this.acceptsSpectators = acceptsSpectators;
    }

    public void setNextState(@Nullable State nextState) {
        if (this.closed) {
            throw new IllegalStateException("Game has been closed");
        }
        this.nextState = nextState;
    }

    public boolean isOnTeam(@Nonnull UUID player, @Nullable Team team) {
        return this.players.containsKey(player) && this.players.get(player) == team;
    }

    @Deprecated
    public boolean isRedTeam(@Nonnull UUID player) {
        return this.isOnTeam(player, Team.RED);
    }

    @Deprecated
    public boolean isBlueTeam(@Nonnull UUID player) {
        return this.isOnTeam(player, Team.BLUE);
    }

    @Nullable
    public Team getPlayerTeam(@Nonnull UUID player) {
        return this.players.get(player);
    }

    @Nonnull
    public Map<UUID, Team> getPlayers() {
        return this.players;
    }

    public void addPlayer(@Nonnull OfflinePlayer player, boolean asSpectator) {
        Validate.notNull((Object)player, (String)"player");
        if (this.state == null) {
            throw new IllegalStateException("The game is not started yet");
        }
        if (this.closed) {
            throw new IllegalStateException("Game has been closed");
        }
        this.players.put(player.getUniqueId(), null);
        this.state.onPlayerJoinGame(player, asSpectator);
        Player p = player.getPlayer();
        if (p != null) {
            this.state.onPlayerReJoinGame(p);
            Warlords.getInstance().hideAndUnhidePeople(p);
        }
    }

    public void setPlayerTeam(@Nonnull OfflinePlayer player, @Nonnull Team team) {
        Validate.notNull((Object)player, (String)"player");
        Validate.notNull((Object)((Object)team), (String)"team");
        if (!this.players.containsKey(player.getUniqueId())) {
            throw new IllegalArgumentException("The specified player is not part of this game");
        }
        Team oldTeam = this.players.get(player.getUniqueId());
        if (team == oldTeam) {
            return;
        }
        this.players.put(player.getUniqueId(), team);
    }

    private boolean removePlayer0(UUID player) {
        if (this.players.containsKey(player)) {
            assert (this.state != null) : "A player was added and removed from the game while it was not started??";
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)player);
            this.state.onPlayerQuitGame(op);
            this.players.remove(player);
            Warlords.removePlayer(player);
            Player p = op.getPlayer();
            if (p != null) {
                WarlordsEvents.joinInteraction(p, true);
            }
            return true;
        }
        return false;
    }

    public boolean removePlayer(UUID player) {
        if (this.removePlayer0(player)) {
            Player p = Bukkit.getPlayer((UUID)player);
            if (p != null) {
                Warlords.getInstance().hideAndUnhidePeople(p);
            }
            return true;
        }
        return false;
    }

    public List<UUID> removeAllPlayers() {
        ArrayList<UUID> toRemove = new ArrayList<UUID>(this.players.keySet());
        for (UUID p : toRemove) {
            this.removePlayer0(p);
        }
        if (!toRemove.isEmpty()) {
            Warlords.getInstance().hideAndUnhidePeople();
        }
        assert (this.players.isEmpty());
        return toRemove;
    }

    public boolean hasPlayer(UUID player) {
        return this.players.containsKey(player);
    }

    public int playersCount() {
        return (int)this.players.values().stream().filter(Objects::nonNull).count();
    }

    public int spectatorsCount() {
        return (int)this.players.values().stream().filter(Objects::isNull).count();
    }

    public Stream<WarlordsPlayer> warlordsPlayers() {
        return this.players.entrySet().stream().map(e -> Warlords.getPlayer((UUID)e.getKey())).filter(Objects::nonNull);
    }

    public Stream<Map.Entry<UUID, Team>> players() {
        return this.players.entrySet().stream();
    }

    public Stream<Map.Entry<UUID, Team>> playersWithoutSpectators() {
        return this.players.entrySet().stream().filter(e -> e.getValue() != null);
    }

    public Stream<Map.Entry<OfflinePlayer, Team>> offlinePlayersWithoutSpectators() {
        return this.playersWithoutSpectators().map(e -> new AbstractMap.SimpleImmutableEntry(Bukkit.getOfflinePlayer((UUID)((UUID)e.getKey())), e.getValue()));
    }

    public Stream<Map.Entry<Player, Team>> onlinePlayersWithoutSpectators() {
        return this.playersWithoutSpectators().map(e -> new AbstractMap.SimpleImmutableEntry(Bukkit.getPlayer((UUID)((UUID)e.getKey())), e.getValue())).filter(e -> e.getKey() != null);
    }

    public Stream<Map.Entry<Player, Team>> onlinePlayers() {
        return this.players().map(e -> new AbstractMap.SimpleImmutableEntry(Bukkit.getPlayer((UUID)((UUID)e.getKey())), e.getValue())).filter(e -> e.getKey() != null);
    }

    public Stream<UUID> spectators() {
        return this.players.entrySet().stream().filter(e -> e.getValue() == null).map(e -> (UUID)e.getKey());
    }

    public void forEachOfflinePlayer(BiConsumer<OfflinePlayer, Team> consumer) {
        this.offlinePlayersWithoutSpectators().forEach(entry -> consumer.accept((OfflinePlayer)entry.getKey(), (Team)((Object)entry.getValue())));
    }

    public void forEachOfflineWarlordsPlayer(Consumer<WarlordsPlayer> consumer) {
        this.warlordsPlayers().forEach(consumer);
    }

    public void forEachOnlinePlayer(BiConsumer<Player, Team> consumer) {
        this.onlinePlayers().forEach(entry -> consumer.accept((Player)entry.getKey(), (Team)((Object)entry.getValue())));
    }

    public void forEachOnlinePlayerWithoutSpectators(BiConsumer<Player, Team> consumer) {
        this.onlinePlayersWithoutSpectators().forEach(entry -> consumer.accept((Player)entry.getKey(), (Team)((Object)entry.getValue())));
    }

    public void forEachOnlineWarlordsPlayer(Consumer<WarlordsPlayer> consumer) {
        this.warlordsPlayers().filter(WarlordsPlayer::isOnline).forEach(consumer);
    }

    @Override
    public void run() {
        if (this.nextState == null && this.state != null) {
            this.nextState = this.state.run();
        }
        while (this.nextState != null) {
            for (GameAddon addon : this.addons) {
                this.nextState = addon.stateWillChange(this, this.state, this.nextState);
                if (this.nextState != null) continue;
                return;
            }
            if (this.state != null) {
                this.state.end();
            }
            State newState = this.nextState == null ? new ClosedState(this) : this.nextState;
            this.nextState = null;
            State oldState = this.state;
            this.state = newState;
            newState.begin();
            for (GameAddon addon : this.addons) {
                addon.stateHasChanged(this, oldState, newState);
            }
        }
    }

    @Nonnull
    @Deprecated
    public List<ScoreboardHandler> getScoreboardHandlers() {
        return this.getMarkers(ScoreboardHandler.class);
    }

    @Deprecated
    public void registerScoreboardHandler(@Nonnull ScoreboardHandler handler) {
        this.registerGameMarker(ScoreboardHandler.class, handler);
    }

    public <T extends GameMarker> void registerGameMarker(@Nonnull Class<T> clazz, @Nonnull T object) {
        if (this.closed) {
            throw new IllegalStateException("Game has been closed");
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Attempted to register a marker for interface " + clazz.getName() + " while passing class " + object.getClass().getName() + " does not implement this");
        }
        this.gameMarkers.computeIfAbsent(clazz, e -> new ArrayList()).add(object);
    }

    @Nonnull
    public <T extends GameMarker> List<T> getMarkers(@Nonnull Class<T> clazz) {
        return this.gameMarkers.getOrDefault(clazz, Collections.emptyList());
    }

    public void unregisterGameTask(@Nonnull BukkitTask task) {
        if (this.closed) {
            return;
        }
        this.gameTasks.remove(Objects.requireNonNull(task, "task"));
    }

    @Nonnull
    public BukkitTask registerGameTask(@Nonnull BukkitTask task) {
        if (this.closed) {
            task.cancel();
            throw new IllegalStateException("Game has been closed");
        }
        this.gameTasks.add(Objects.requireNonNull(task, "task"));
        return task;
    }

    public BukkitTask registerGameTask(Runnable task) {
        return this.registerGameTask(Bukkit.getScheduler().runTask((Plugin)Warlords.getInstance(), task));
    }

    public BukkitTask registerGameTask(Runnable task, int delay) {
        return this.registerGameTask(Bukkit.getScheduler().runTaskLater((Plugin)Warlords.getInstance(), task, (long)delay));
    }

    public BukkitTask registerGameTask(Runnable task, int delay, int period) {
        return this.registerGameTask(Bukkit.getScheduler().runTaskTimer((Plugin)Warlords.getInstance(), task, (long)delay, (long)period));
    }

    private HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalPluginAccessException(e.toString());
        }
    }

    private Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException localNoSuchMethodException) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public void registerEvents(Listener listener) {
        if (this.state == null) {
            throw new IllegalStateException("The game is not started yet");
        }
        if (this.closed) {
            throw new IllegalStateException("Game has been closed");
        }
        this.eventHandlers.add(listener);
        if (!Warlords.getInstance().isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + listener + " while not enabled");
        }
        for (Map.Entry entry : Warlords.getInstance().getPluginLoader().createRegisteredListeners(listener, (Plugin)Warlords.getInstance()).entrySet()) {
            if (AbstractWarlordsGameEvent.class.isAssignableFrom((Class)entry.getKey())) {
                entry.setValue(((Set)entry.getValue()).stream().map(rl -> new RegisteredListener(rl.getListener(), (l, e) -> {
                    AbstractWarlordsGameEvent wge = (AbstractWarlordsGameEvent)e;
                    if (wge.getGame() == this) {
                        rl.callEvent(e);
                    }
                }, rl.getPriority(), rl.getPlugin(), false)).collect(Collectors.toSet()));
            }
            this.getEventListeners(this.getRegistrationClass((Class)entry.getKey())).registerAll((Collection)entry.getValue());
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (BukkitTask task : this.gameTasks) {
            task.cancel();
        }
        this.gameTasks.clear();
        for (Listener listener : this.eventHandlers) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.eventHandlers.clear();
        try {
            this.removeAllPlayers();
        }
        catch (Throwable e) {
            exceptions.add(e);
        }
        for (Option option : this.options) {
            try {
                option.onGameCleanup(this);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        }
        this.acceptsPlayers = false;
        this.acceptsSpectators = false;
        this.nextState = null;
        if (this.state != null && !(this.state instanceof ClosedState)) {
            try {
                this.state.end();
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            this.state = new ClosedState(this);
        }
        this.options = Collections.emptyList();
        if (!exceptions.isEmpty()) {
            RuntimeException e = new RuntimeException("Problems closing the game", (Throwable)exceptions.get(0));
            for (int i = 1; i < exceptions.size(); ++i) {
                e.addSuppressed((Throwable)exceptions.get(i));
            }
            throw e;
        }
    }

    public String toString() {
        return "Game{\nplayers=" + this.players.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n\t", "\n\t", "")) + ",\ncreatedAt=" + this.createdAt + ",\ngameTasks=" + this.gameTasks + ",\neventHandlers=" + this.eventHandlers + ",\nmap=" + (Object)((Object)this.map) + ",\ncategory=" + (Object)((Object)this.gameMode) + ",\naddons=" + this.addons + ",\noptions=" + this.options + ",\nstate=" + this.state + ",\nnextState=" + this.nextState + ",\nclosed=" + this.closed + ",\nfrozenCauses=" + this.frozenCauses + ",\nmaxPlayers=" + this.maxPlayers + ",\nminPlayers=" + this.minPlayers + ",\nacceptsPlayers=" + this.acceptsPlayers + ",\nacceptsSpectators=" + this.acceptsSpectators + ",\ngameMarkers=" + this.gameMarkers.entrySet().stream().map(e -> ((Class)e.getKey()).getSimpleName() + ": " + ((List)e.getValue()).stream().map(Object::toString).collect(Collectors.joining("\n\t\t", "\n\t\t", ""))).collect(Collectors.joining("\n\t", "\n\t", "")) + ",\nlocations=" + this.locations + "\n}";
    }

    @Deprecated
    public void printDebuggingInformation() {
        Warlords.getInstance().getLogger().info(String.valueOf(this));
    }

    public int getPoints(@Nonnull Team team) {
        Integer oldPointsObj = this.points.get((Object)team);
        if (oldPointsObj == null) {
            throw new IllegalArgumentException("Team " + (Object)((Object)team) + " is not part of this game");
        }
        return oldPointsObj;
    }

    public void addPoints(@Nonnull Team team, int addPoints) {
        Integer oldPointsObj = this.points.get((Object)team);
        if (oldPointsObj == null) {
            throw new IllegalArgumentException("Team " + (Object)((Object)team) + " is not part of this game");
        }
        int oldPoints = oldPointsObj;
        int points = oldPoints + addPoints;
        this.points.put(team, points);
        Bukkit.getPluginManager().callEvent((Event)new WarlordsPointsChangedEvent(this, team, oldPoints, points));
    }

    public void setPoints(@Nonnull Team team, int points) {
        Integer oldPointsObj = this.points.get((Object)team);
        if (oldPointsObj == null) {
            throw new IllegalArgumentException("Team " + (Object)((Object)team) + " is not part of this game");
        }
        int oldPoints = oldPointsObj;
        this.points.put(team, points);
        Bukkit.getPluginManager().callEvent((Event)new WarlordsPointsChangedEvent(this, team, oldPoints, points));
    }
}

