/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.events;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.IceBarrier;
import com.ebicep.warlords.abilties.OrderOfEviscerate;
import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.TimeWarp;
import com.ebicep.warlords.abilties.UndyingArmy;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.classes.shaman.specs.Spiritguard;
import com.ebicep.warlords.commands.debugcommands.misc.MuteCommand;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.leaderboards.LeaderboardManager;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.events.WarlordsDeathEvent;
import com.ebicep.warlords.events.WarlordsFlagUpdatedEvent;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.game.flags.GroundFlagLocation;
import com.ebicep.warlords.game.flags.PlayerFlagLocation;
import com.ebicep.warlords.game.flags.SpawnFlagLocation;
import com.ebicep.warlords.game.flags.WaitingFlagLocation;
import com.ebicep.warlords.game.option.marker.FlagHolder;
import com.ebicep.warlords.game.state.EndState;
import com.ebicep.warlords.game.state.PreLobbyState;
import com.ebicep.warlords.menu.debugmenu.DebugMenuGameOptions;
import com.ebicep.warlords.menu.generalmenu.WarlordsShopMenu;
import com.ebicep.warlords.party.Party;
import com.ebicep.warlords.party.RegularGamesMenu;
import com.ebicep.warlords.permissions.PermissionHandler;
import com.ebicep.warlords.player.CustomScoreboard;
import com.ebicep.warlords.player.ExperienceManager;
import com.ebicep.warlords.player.PlayerSettings;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.Weapons;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.chat.ChatChannels;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryFurnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class WarlordsEvents
implements Listener {
    public static Set<Entity> entityList = new HashSet<Entity>();

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (event.getEntity() instanceof FallingBlock && entityList.remove(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    public static void addEntityUUID(Entity entity) {
        entityList.add(entity);
    }

    @EventHandler
    public static void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        if (DatabaseManager.playerService == null && DatabaseManager.enabled) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, "Please wait!");
        }
    }

    @EventHandler
    public static void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        WarlordsPlayer wp = Warlords.getPlayer(player);
        if (wp != null) {
            if (wp.isAlive()) {
                e.getPlayer().setAllowFlight(false);
            }
            e.setJoinMessage(wp.getColoredNameBold() + ChatColor.GOLD + " rejoined the game!");
        } else {
            e.getPlayer().setAllowFlight(true);
            e.setJoinMessage(ChatColor.AQUA + e.getPlayer().getName() + ChatColor.GOLD + " joined the lobby!");
            if (DatabaseManager.playerService == null || !DatabaseManager.enabled) {
                Warlords.updateHead(e.getPlayer());
            }
            Warlords.newChain().async(() -> DatabaseManager.loadPlayer(e.getPlayer().getUniqueId(), PlayersCollections.LIFETIME, () -> {
                Warlords.updateHead(e.getPlayer());
                Location rejoinPoint = Warlords.getRejoinPoint(player.getUniqueId());
                if (LeaderboardManager.loaded && ((World)Bukkit.getWorlds().get(0)).equals(rejoinPoint.getWorld())) {
                    LeaderboardManager.setLeaderboardHologramVisibility(player);
                    DatabaseGameBase.setGameHologramVisibility(player);
                    Warlords.playerScoreboards.get(player.getUniqueId()).giveMainLobbyScoreboard();
                    ExperienceManager.giveExperienceBar(player);
                }
            })).execute();
        }
        if (!Warlords.playerScoreboards.containsKey(player.getUniqueId()) || Warlords.playerScoreboards.get(player.getUniqueId()) == null) {
            Warlords.playerScoreboards.put(player.getUniqueId(), new CustomScoreboard(player));
        }
        player.setScoreboard(Warlords.playerScoreboards.get(player.getUniqueId()).getScoreboard());
        WarlordsEvents.joinInteraction(player, false);
        Bukkit.getOnlinePlayers().forEach(p -> PacketUtils.sendTabHF(p, ChatColor.AQUA + "     Welcome to " + ChatColor.YELLOW + ChatColor.BOLD + "Warlords 2.0     ", ChatColor.GREEN + "Players Online: " + ChatColor.GRAY + Bukkit.getOnlinePlayers().size()));
        Warlords.getGameManager().dropPlayerFromQueueOrGames((OfflinePlayer)e.getPlayer());
    }

    public static void joinInteraction(Player player, boolean fromGame) {
        WarlordsPlayer p;
        boolean playerIsInWrongWorld;
        Location rejoinPoint = Warlords.getRejoinPoint(player.getUniqueId());
        boolean isSpawnWorld = ((World)Bukkit.getWorlds().get(0)).getName().equals(rejoinPoint.getWorld().getName());
        boolean bl = playerIsInWrongWorld = !player.getWorld().getName().equals(rejoinPoint.getWorld().getName());
        if (isSpawnWorld || playerIsInWrongWorld) {
            player.teleport(rejoinPoint);
        }
        if (playerIsInWrongWorld && isSpawnWorld) {
            player.sendMessage(ChatColor.RED + "The game you were previously playing is no longer running!");
        }
        if (playerIsInWrongWorld && !isSpawnWorld) {
            player.sendMessage(ChatColor.RED + "The game started without you, but we still love you enough and you were warped into the game");
        }
        if (isSpawnWorld) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
            player.removePotionEffect(PotionEffectType.SLOW);
            player.removePotionEffect(PotionEffectType.ABSORPTION);
            player.setGameMode(GameMode.ADVENTURE);
            ChatUtils.sendCenteredMessage(player, ChatColor.GRAY + "-----------------------------------------------------");
            ChatUtils.sendCenteredMessage(player, ChatColor.GOLD + "" + ChatColor.BOLD + "Welcome to Warlords 2.0 " + ChatColor.GRAY + "(" + ChatColor.RED + Warlords.VERSION + ChatColor.GRAY + ")");
            ChatUtils.sendCenteredMessage(player, ChatColor.GOLD + "Developed by " + ChatColor.RED + "sumSmash " + ChatColor.GOLD + "&" + ChatColor.RED + " Plikie");
            ChatUtils.sendCenteredMessage(player, "");
            ChatUtils.sendCenteredMessage(player, ChatColor.GOLD + "Click the Nether Star or do " + ChatColor.GREEN + "/menu" + ChatColor.GOLD + " to open the selection menu.");
            ChatUtils.sendCenteredMessage(player, ChatColor.GOLD + "You can start private games using the " + ChatColor.GREEN + "Blaze Powder" + ChatColor.GOLD + " in your inventory!");
            ChatUtils.sendCenteredMessage(player, "");
            ChatUtils.sendCenteredMessage(player, ChatColor.GOLD + "Make sure to join our discord if you wish to stay up-to-date with our most recent patches, interact with our community and make bug reports or game suggestions at: " + ChatColor.RED + "\u00a7ldiscord.gg/GWPAx9sEG7");
            ChatUtils.sendCenteredMessage(player, "");
            ChatUtils.sendCenteredMessage(player, ChatColor.GOLD + "We highly recommend you to download our resource pack at: " + ChatColor.RED + "\u00a7lhttps://bit.ly/3J1lGGn");
            ChatUtils.sendCenteredMessage(player, ChatColor.GRAY + "-----------------------------------------------------");
            PlayerSettings playerSettings = Warlords.getPlayerSettings(player.getUniqueId());
            Specializations selectedSpec = playerSettings.getSelectedSpec();
            AbstractPlayerClass apc = selectedSpec.create.get();
            player.getInventory().clear();
            player.getInventory().setArmorContents(new ItemStack[]{null, null, null, null});
            try {
                player.getInventory().setItem(1, new ItemBuilder(apc.getWeapon().getItem(playerSettings.getWeaponSkins().getOrDefault((Object)((Object)selectedSpec), (Weapons)Weapons.FELFLAME_BLADE).item)).name("\u00a7aWeapon Skin Preview").get());
                player.getInventory().setItem(4, new ItemBuilder(Material.NETHER_STAR).name("\u00a7aSelection Menu").get());
            }
            catch (Exception e) {
                System.out.println("ERROR: WEAPON THINGY - " + player.getName());
                e.printStackTrace();
            }
            if (!fromGame) {
                Warlords.partyManager.getPartyFromAny(player.getUniqueId()).ifPresent(party -> {
                    List<RegularGamesMenu.RegularGamePlayer> playerList = party.getRegularGamesMenu().getRegularGamePlayers();
                    if (!playerList.isEmpty()) {
                        playerList.stream().filter(regularGamePlayer -> regularGamePlayer.getUuid().equals(player.getUniqueId())).findFirst().ifPresent(regularGamePlayer -> player.getInventory().setItem(7, new ItemBuilder(Material.WOOL).name("\u00a7aTeam Builder").get()));
                    }
                });
            }
            if (player.hasPermission("warlords.game.debug")) {
                player.getInventory().setItem(3, new ItemBuilder(Material.EMERALD).name("\u00a7aDebug Menu").get());
            } else {
                player.getInventory().setItem(3, new ItemBuilder(Material.BLAZE_POWDER).name("\u00a7aStart Menu").get());
            }
            if (fromGame) {
                Warlords.playerScoreboards.get(player.getUniqueId()).giveMainLobbyScoreboard();
                ExperienceManager.giveExperienceBar(player);
            }
            player.getActivePotionEffects().clear();
        }
        if ((p = Warlords.getPlayer(player)) != null) {
            player.teleport(p.getLocation());
            p.updatePlayerReference(player);
        } else {
            player.setAllowFlight(true);
        }
        Warlords.getInstance().hideAndUnhidePeople(player);
    }

    @EventHandler
    public static void onPlayerQuit(PlayerQuitEvent e) {
        WarlordsPlayer wp = Warlords.getPlayer(e.getPlayer());
        if (wp != null) {
            wp.updatePlayerReference(null);
            e.setQuitMessage(wp.getColoredNameBold() + ChatColor.GOLD + " left the game!");
        } else {
            e.setQuitMessage(ChatColor.AQUA + e.getPlayer().getName() + ChatColor.GOLD + " left the lobby!");
        }
        if (e.getPlayer().getVehicle() != null) {
            e.getPlayer().getVehicle().remove();
        }
        LeaderboardManager.removePlayerSpecificHolograms(e.getPlayer());
        Bukkit.getOnlinePlayers().forEach(p -> PacketUtils.sendTabHF(p, ChatColor.AQUA + "     Welcome to " + ChatColor.YELLOW + ChatColor.BOLD + "Warlords 2.0     ", ChatColor.GREEN + "Players Online: " + ChatColor.GRAY + (Bukkit.getOnlinePlayers().size() - 1)));
        for (GameManager.GameHolder holder : Warlords.getGameManager().getGames()) {
            if (holder.getGame() == null || !holder.getGame().hasPlayer(e.getPlayer().getUniqueId()) || holder.getGame().getPlayerTeam(e.getPlayer().getUniqueId()) != null) continue;
            holder.getGame().removePlayer(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if ((e.getEntity() instanceof Player || e.getEntity() instanceof Zombie) && e.getDamager() instanceof Player) {
            Player attacker = (Player)e.getDamager();
            WarlordsPlayer wpAttacker = Warlords.getPlayer(attacker);
            WarlordsPlayer wpVictim = Warlords.getPlayer(e.getEntity());
            if (wpAttacker != null && wpAttacker.isEnemyAlive(wpVictim) && !wpAttacker.getGame().isFrozen()) {
                if (attacker.getInventory().getHeldItemSlot() == 0 && wpAttacker.getHitCooldown() == 0) {
                    wpAttacker.setHitCooldown(12);
                    wpAttacker.subtractEnergy(wpAttacker.getSpec().getEnergyOnHit() * -1);
                    if (wpAttacker.getSpec() instanceof Spiritguard && wpAttacker.getCooldownManager().hasCooldown(Soulbinding.class)) {
                        Soulbinding baseSoulBinding = (Soulbinding)wpAttacker.getSpec().getPurple();
                        new CooldownFilter<PersistentCooldown>(wpAttacker, PersistentCooldown.class).filter(PersistentCooldown::isShown).filterCooldownClassAndMapToObjectsOfClass(Soulbinding.class).forEachOrdered(soulbinding -> {
                            wpAttacker.doOnStaticAbility(Soulbinding.class, Soulbinding::addPlayersBinded);
                            if (soulbinding.hasBoundPlayer(wpVictim)) {
                                soulbinding.getSoulBindedPlayers().stream().filter(p -> p.getBoundPlayer() == wpVictim).forEach(boundPlayer -> {
                                    boundPlayer.setHitWithSoul(false);
                                    boundPlayer.setHitWithLink(false);
                                    boundPlayer.setTimeLeft(baseSoulBinding.getBindDuration());
                                });
                            } else {
                                wpVictim.sendMessage(ChatColor.RED + "\u00ab " + ChatColor.GRAY + "You have been bound by " + wpAttacker.getName() + "'s " + ChatColor.LIGHT_PURPLE + "Soulbinding Weapon" + ChatColor.GRAY + "!");
                                wpAttacker.sendMessage(ChatColor.GREEN + "\u00bb " + ChatColor.GRAY + "Your " + ChatColor.LIGHT_PURPLE + "Soulbinding Weapon " + ChatColor.GRAY + "has bound " + wpVictim.getName() + "!");
                                soulbinding.getSoulBindedPlayers().add(new Soulbinding.SoulBoundPlayer(wpVictim, baseSoulBinding.getBindDuration()));
                                Utils.playGlobalSound(wpVictim.getLocation(), "shaman.earthlivingweapon.activation", 2.0f, 1.0f);
                            }
                        });
                    }
                    wpVictim.addDamageInstance(wpAttacker, "", 132.0f, 179.0f, 25, 200, false);
                    wpVictim.updateJimmyHealth();
                }
                if (wpVictim.getCooldownManager().hasCooldown(IceBarrier.class)) {
                    wpAttacker.getSpeed().addSpeedModifier("Ice Barrier", -20, 40, new String[0]);
                }
            }
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        final Player player = e.getPlayer();
        Action action = e.getAction();
        Location location = player.getLocation();
        WarlordsPlayer wp = Warlords.getPlayer(player);
        if (action == Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_AIR) {
            ItemStack itemHeld = player.getItemInHand();
            if (wp != null && wp.isAlive() && !wp.getGame().isFrozen()) {
                if (player.getInventory().getHeldItemSlot() == 7 && itemHeld.getType() == Material.GOLD_BARDING && player.getVehicle() == null && wp.getHorseCooldown() <= 0.0f) {
                    if (!Utils.isMountableZone(location) || Utils.blocksInFrontOfLocation(location)) {
                        player.sendMessage(ChatColor.RED + "You can't mount here!");
                    } else {
                        double distance = Utils.getDistance((Entity)player, 0.25);
                        if (distance >= 2.0) {
                            player.sendMessage(ChatColor.RED + "You can't mount in the air!");
                        } else if (wp.getCarriedFlag() != null) {
                            player.sendMessage(ChatColor.RED + "You can't mount while holding the flag!");
                        } else {
                            player.playSound(player.getLocation(), "mountup", 1.0f, 1.0f);
                            wp.getHorse().spawn();
                            wp.setHorseCooldown((float)((double)wp.getHorse().getCooldown() * wp.getCooldownModifier()));
                        }
                    }
                } else if (itemHeld.getType() == Material.BONE) {
                    player.getInventory().remove(UndyingArmy.BONE);
                    wp.addDamageInstance(Warlords.getPlayer(player), "", 100000.0f, 100000.0f, -1, 100, false);
                } else if (itemHeld.getType() == Material.BANNER) {
                    if (wp.getFlagDropCooldown() > 0) {
                        player.sendMessage("\u00a7cYou cannot drop the flag yet, please wait 5 seconds!");
                    } else if (wp.getCooldownManager().hasCooldown(TimeWarp.class)) {
                        player.sendMessage(ChatColor.RED + "You cannot drop the flag with a Time Warp active!");
                    } else {
                        FlagHolder.dropFlagForPlayer(wp);
                        wp.setFlagDropCooldown(5);
                    }
                } else if (itemHeld.getType() == Material.COMPASS) {
                    player.playSound(player.getLocation(), Sound.NOTE_PLING, 1.0f, 2.0f);
                    wp.toggleTeamFlagCompass();
                } else if (player.getInventory().getHeldItemSlot() == 0 || !Warlords.getPlayerSettings(wp.getUuid()).getHotKeyMode()) {
                    wp.getSpec().onRightClick(wp, player, player.getInventory().getHeldItemSlot(), false);
                }
            } else {
                PreLobbyState state = Warlords.getGameManager().getPlayerGame(player.getUniqueId()).flatMap(g2 -> g2.getState(PreLobbyState.class)).orElse(null);
                if (state != null) {
                    state.interactEvent(player, player.getInventory().getHeldItemSlot());
                } else if (itemHeld.getType() == Material.NETHER_STAR) {
                    WarlordsShopMenu.openMainMenu(player);
                } else if (itemHeld.getType() == Material.EMERALD) {
                    Bukkit.getServer().dispatchCommand((CommandSender)player, "wl");
                } else if (itemHeld.getType() == Material.BLAZE_POWDER) {
                    DebugMenuGameOptions.StartMenu.openMapPickerMenu(player);
                } else if (itemHeld.getType() == Material.WOOL && itemHeld.getItemMeta().getDisplayName() != null && itemHeld.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Team Builder")) {
                    Warlords.partyManager.getPartyFromAny(player.getUniqueId()).ifPresent(party -> {
                        List<RegularGamesMenu.RegularGamePlayer> playerList = party.getRegularGamesMenu().getRegularGamePlayers();
                        if (!playerList.isEmpty()) {
                            party.getRegularGamesMenu().openMenuForPlayer(player);
                            new BukkitRunnable((Party)party){
                                final /* synthetic */ Party val$party;
                                {
                                    this.val$party = party;
                                }

                                public void run() {
                                    if (player.getOpenInventory().getTopInventory().getName().equals("Team Builder")) {
                                        this.val$party.getRegularGamesMenu().openMenuForPlayer(player);
                                    } else {
                                        this.cancel();
                                    }
                                }
                            }.runTaskTimer((Plugin)Warlords.getInstance(), 20L, 10L);
                        }
                    });
                }
            }
        } else if (action != Action.LEFT_CLICK_BLOCK && action != Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_AIR) {
            // empty if block
        }
    }

    @EventHandler
    public void onMount(VehicleEnterEvent e) {
    }

    @EventHandler
    public void onDismount(VehicleExitEvent e) {
        e.getVehicle().remove();
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
            WarlordsPlayer warlordsPlayer = Warlords.getPlayer(e.getPlayer().getUniqueId());
            if (warlordsPlayer == null) {
                return;
            }
            if (e.getPlayer().getGameMode() == GameMode.SPECTATOR) {
                e.setCancelled(true);
                e.getPlayer().setSpectatorTarget(null);
            }
        }
    }

    @EventHandler
    public void regenEvent(EntityRegainHealthEvent e) {
        e.setCancelled(true);
    }

    @EventHandler
    public void pickUpItem(PlayerArmorStandManipulateEvent e) {
        e.setCancelled(true);
    }

    @EventHandler
    public void switchItemHeld(PlayerItemHeldEvent e) {
        int slot = e.getNewSlot();
        WarlordsPlayer wp = Warlords.getPlayer(e.getPlayer());
        if (wp != null && Warlords.getPlayerSettings(wp.getUuid()).getHotKeyMode() && (slot == 1 || slot == 2 || slot == 3 || slot == 4)) {
            wp.getSpec().onRightClick(wp, e.getPlayer(), slot, true);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent e) {
        Player player;
        WarlordsPlayer wp;
        if (e.getSlot() == 0 && (wp = Warlords.getPlayer(player = (Player)e.getWhoClicked())) != null) {
            if (e.isLeftClick()) {
                wp.weaponLeftClick(player);
            } else if (e.isRightClick()) {
                wp.weaponRightClick(player);
            }
        }
        if (e.getWhoClicked().getGameMode() != GameMode.CREATIVE) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onOpenInventory(InventoryOpenEvent e) {
        if (e.getPlayer().getVehicle() != null && e.getInventory().getHolder() != null && e.getInventory().getHolder().getInventory().getTitle().equals("Horse")) {
            e.setCancelled(true);
        }
        if (e.getInventory() instanceof CraftInventoryAnvil || e.getInventory() instanceof CraftInventoryBeacon || e.getInventory() instanceof CraftInventoryBrewer || e.getInventory() instanceof CraftInventoryCrafting || e.getInventory() instanceof CraftInventoryDoubleChest || e.getInventory() instanceof CraftInventoryFurnace || e.getInventory().getType() == InventoryType.HOPPER || e.getInventory().getType() == InventoryType.DROPPER) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropEvent(PlayerDropItemEvent e) {
        e.setCancelled(true);
    }

    @EventHandler
    public void onHorseJump(HorseJumpEvent e) {
        if (Warlords.hasPlayer((OfflinePlayer)e.getEntity().getPassenger()) && Objects.requireNonNull(Warlords.getPlayer(e.getEntity().getPassenger())).getGame().isFrozen()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Location location;
        if (e.getPlayer().getVehicle() instanceof Horse && !Utils.isMountableZone(location = e.getPlayer().getLocation())) {
            e.getPlayer().getVehicle().remove();
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            WarlordsPlayer wp;
            if (e.getCause() == EntityDamageEvent.DamageCause.VOID) {
                e.getEntity().teleport(Warlords.getRejoinPoint(e.getEntity().getUniqueId()));
                WarlordsPlayer wp2 = Warlords.getPlayer(e.getEntity());
                if (wp2 != null) {
                    if (wp2.isDead()) {
                        wp2.getEntity().teleport(wp2.getLocation().clone().add(0.0, 100.0, 0.0));
                    } else {
                        wp2.addDamageInstance(wp2, "Fall", 1000000.0f, 1000000.0f, -1, 100, false);
                    }
                }
            } else if (e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                int damage;
                WarlordsPlayer wp3;
                if (e.getEntity() instanceof Player && (wp3 = Warlords.getPlayer(e.getEntity())) != null && (damage = (int)e.getDamage()) > 5) {
                    wp3.addDamageInstance(wp3, "Fall", (damage + 3) * 40 - 200, (damage + 3) * 40 - 200, -1, 100, false);
                    wp3.setRegenTimer(10);
                }
            } else if (e.getCause() == EntityDamageEvent.DamageCause.DROWNING && e.getEntity() instanceof Player && (wp = Warlords.getPlayer(e.getEntity())) != null && !wp.getGame().isFrozen()) {
                wp.addDamageInstance(wp, "Fall", 100.0f, 100.0f, -1, 100, false);
                wp.setRegenTimer(10);
            }
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent e) {
        e.getDrops().clear();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        e.getBlock().getDrops().clear();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (MuteCommand.mutedPlayers.getOrDefault(uuid, false).booleanValue()) {
            e.setCancelled(true);
            return;
        }
        try {
            Bukkit.getScheduler().callSyncMethod((Plugin)Warlords.getInstance(), () -> {
                if (!Warlords.playerChatChannels.containsKey(uuid)) {
                    Warlords.playerChatChannels.put(uuid, ChatChannels.ALL);
                }
                String prefix = "";
                ChatColor prefixColor = ChatColor.WHITE;
                if (PermissionHandler.isDefault(player)) {
                    prefixColor = ChatColor.AQUA;
                    prefix = prefixColor + "";
                } else if (PermissionHandler.isGameTester(player)) {
                    prefixColor = ChatColor.YELLOW;
                    prefix = prefixColor + "[T] ";
                } else if (PermissionHandler.isGameStarter(player)) {
                    prefixColor = ChatColor.YELLOW;
                    prefix = prefixColor + "[GS] ";
                } else if (PermissionHandler.isContentCreator(player)) {
                    prefixColor = ChatColor.LIGHT_PURPLE;
                    prefix = prefixColor + "[CT] ";
                } else if (PermissionHandler.isCoordinator(player)) {
                    prefixColor = ChatColor.GOLD;
                    prefix = prefixColor + "[HGS] ";
                } else if (PermissionHandler.isAdmin(player)) {
                    prefixColor = ChatColor.DARK_AQUA;
                    prefix = prefixColor + "[ADMIN] ";
                } else {
                    System.out.println(ChatColor.RED + "[WARLORDS] Player has invalid rank or permissions have not been set up properly!");
                }
                switch (Warlords.playerChatChannels.getOrDefault(uuid, ChatChannels.ALL)) {
                    case ALL: {
                        WarlordsPlayer wp = Warlords.getPlayer(player);
                        PlayerSettings playerSettings = Warlords.getPlayerSettings(uuid);
                        int level = ExperienceManager.getLevelForSpec(uuid, playerSettings.getSelectedSpec());
                        if (wp == null) {
                            e.setFormat(ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + Specializations.getClass((Specializations)playerSettings.getSelectedSpec()).name.toUpperCase().substring(0, 3) + ChatColor.DARK_GRAY + "][" + ChatColor.GRAY + (level < 10 ? "0" : "") + level + ChatColor.DARK_GRAY + "][" + playerSettings.getSelectedSpec().specType.getColoredSymbol() + ChatColor.DARK_GRAY + "] " + prefix + prefixColor + "%1$s" + ChatColor.WHITE + ": %2$s");
                            e.getRecipients().removeIf(Warlords::hasPlayer);
                            return null;
                        }
                        e.setFormat(wp.getTeam().teamColor() + "[" + wp.getTeam().prefix() + "]" + ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + wp.getSpec().getClassNameShort() + ChatColor.DARK_GRAY + "][" + ChatColor.GRAY + (level < 10 ? "0" : "") + level + ChatColor.DARK_GRAY + "][" + playerSettings.getSelectedSpec().specType.getColoredSymbol() + ChatColor.DARK_GRAY + "] " + (wp.isDead() ? ChatColor.GRAY + "[SPECTATOR] " : "") + prefix + prefixColor + "%1$s" + ChatColor.WHITE + ": %2$s");
                        if (wp.getGame().getState() instanceof EndState) break;
                        e.getRecipients().removeIf(p -> wp.getGame().getPlayerTeam(p.getUniqueId()) != wp.getTeam());
                        break;
                    }
                    case PARTY: {
                        if (Warlords.partyManager.getPartyFromAny(uuid).isPresent()) {
                            e.setFormat(ChatColor.BLUE + "Party" + ChatColor.DARK_GRAY + " > " + prefixColor + "%1$s" + ChatColor.WHITE + ": %2$s");
                            e.getRecipients().retainAll(Warlords.partyManager.getPartyFromAny(uuid).get().getAllPartyPeoplePlayerOnline());
                            break;
                        }
                        player.sendMessage(ChatColor.RED + "You are not in a party and were moved to the ALL channel.");
                        Warlords.playerChatChannels.put(uuid, ChatChannels.ALL);
                        e.setCancelled(true);
                        return null;
                    }
                }
                return null;
            }).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Warlords.getInstance().getLogger().log(Level.SEVERE, null, ex);
            System.out.println("UUID: " + uuid);
            System.out.println("Chat Channels: " + Warlords.playerChatChannels);
            System.out.println("Player Chat Channel: " + (Object)((Object)Warlords.playerChatChannels.get(uuid)));
            System.out.println("Contains UUID: " + Warlords.playerChatChannels.containsKey(uuid));
        }
    }

    @EventHandler
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        EntityDamageEvent lastDamage = player.getLastDamageCause();
        if (!(lastDamage instanceof EntityDamageByEntityEvent)) {
            return;
        }
        if (((EntityDamageByEntityEvent)lastDamage).getDamager() instanceof Player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWeatherChange(WeatherChangeEvent change) {
        change.setCancelled(true);
        if (change.getWorld().hasStorm()) {
            change.getWorld().setWeatherDuration(0);
        }
    }

    @EventHandler
    public void onFoodChange(FoodLevelChangeEvent change) {
        change.setCancelled(true);
        if (change.getEntity() instanceof Player) {
            ((Player)change.getEntity()).setFoodLevel(20);
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent e) {
        e.setCancelled(true);
    }

    @EventHandler
    public void onFlagChange(WarlordsFlagUpdatedEvent event) {
        if (event.getOld() instanceof PlayerFlagLocation) {
            ((PlayerFlagLocation)event.getOld()).getPlayer().setCarriedFlag(null);
        }
        if (event.getNew() instanceof PlayerFlagLocation) {
            PlayerFlagLocation pfl = (PlayerFlagLocation)event.getNew();
            WarlordsPlayer player = pfl.getPlayer();
            player.setCarriedFlag(event.getInfo());
            OrderOfEviscerate.removeCloak(player, false);
            if (event.getOld() instanceof PlayerFlagLocation) {
                if (pfl.getComputedHumanMultiplier() % 10 == 0) {
                    event.getGame().forEachOnlinePlayerWithoutSpectators((p, t2) -> p.sendMessage("\u00a7eThe " + event.getTeam().coloredPrefix() + " \u00a7eflag carrier now takes \u00a7c" + pfl.getComputedHumanMultiplier() + "% \u00a7eincreased damage!"));
                    event.getGame().spectators().forEach(uuid -> {
                        if (Bukkit.getPlayer((UUID)uuid) != null) {
                            Player p = Bukkit.getPlayer((UUID)uuid);
                            p.sendMessage("\u00a7eThe " + event.getTeam().coloredPrefix() + " \u00a7eflag carrier now takes \u00a7c" + pfl.getComputedHumanMultiplier() + "% \u00a7eincreased damage!");
                        }
                    });
                }
            } else {
                ChatColor enemyColor = event.getTeam().enemy().teamColor();
                event.getGame().forEachOnlinePlayerWithoutSpectators((p, t2) -> {
                    p.sendMessage(enemyColor + player.getName() + " \u00a7epicked up the " + event.getTeam().coloredPrefix() + " \u00a7eflag!");
                    PacketUtils.sendTitle(p, "", enemyColor + player.getName() + " \u00a7epicked up the " + event.getTeam().coloredPrefix() + " \u00a7eflag!", 0, 60, 0);
                    if (t2 == event.getTeam()) {
                        p.playSound(player.getLocation(), "ctf.friendlyflagtaken", 500.0f, 1.0f);
                    } else {
                        p.playSound(player.getLocation(), "ctf.enemyflagtaken", 500.0f, 1.0f);
                    }
                });
                event.getGame().spectators().forEach(uuid -> {
                    if (Bukkit.getPlayer((UUID)uuid) != null) {
                        Player p = Bukkit.getPlayer((UUID)uuid);
                        p.sendMessage(enemyColor + player.getName() + " \u00a7epicked up the " + event.getTeam().coloredPrefix() + " \u00a7eflag!");
                        PacketUtils.sendTitle(p, "", enemyColor + player.getName() + " \u00a7epicked up the " + event.getTeam().coloredPrefix() + " \u00a7eflag!", 0, 60, 0);
                    }
                });
            }
        } else if (event.getNew() instanceof SpawnFlagLocation) {
            WarlordsPlayer toucher = ((SpawnFlagLocation)event.getNew()).getFlagReturner();
            if (event.getOld() instanceof GroundFlagLocation) {
                if (toucher != null) {
                    toucher.addFlagReturn();
                    event.getGame().forEachOnlinePlayer((p, t2) -> {
                        ChatColor color = event.getTeam().teamColor();
                        p.sendMessage(color + toucher.getName() + " \u00a7ehas returned the " + event.getTeam().coloredPrefix() + " \u00a7eflag!");
                        PacketUtils.sendTitle(p, "", color + toucher.getName() + " \u00a7ehas returned the " + event.getTeam().coloredPrefix() + " \u00a7eflag!", 0, 60, 0);
                        if (t2 == event.getTeam()) {
                            p.playSound(p.getLocation(), "ctf.flagreturned", 500.0f, 1.0f);
                        }
                    });
                } else {
                    event.getGame().forEachOnlinePlayer((p, t2) -> p.sendMessage("\u00a7eThe " + event.getTeam().coloredPrefix() + " \u00a7eflag has returned to its base."));
                }
            }
        } else if (event.getNew() instanceof GroundFlagLocation) {
            if (event.getOld() instanceof PlayerFlagLocation) {
                PlayerFlagLocation pfl = (PlayerFlagLocation)event.getOld();
                pfl.getPlayer().updateArmor();
                String flag = event.getTeam().coloredPrefix();
                ChatColor playerColor = event.getTeam().enemy().teamColor();
                event.getGame().forEachOnlinePlayer((p, t2) -> {
                    PacketUtils.sendTitle(p, "", playerColor + pfl.getPlayer().getName() + " \u00a7ehas dropped the " + flag + " \u00a7eflag!", 0, 60, 0);
                    p.sendMessage(playerColor + pfl.getPlayer().getName() + " \u00a7ehas dropped the " + flag + " \u00a7eflag!");
                });
            }
        } else if (event.getNew() instanceof WaitingFlagLocation && ((WaitingFlagLocation)event.getNew()).getScorer() != null) {
            WarlordsPlayer player = ((WaitingFlagLocation)event.getNew()).getScorer();
            player.addFlagCap();
            event.getGame().forEachOnlinePlayer((p, t2) -> {
                String message = player.getColoredName() + " \u00a7ecaptured the " + event.getInfo().getTeam().coloredPrefix() + " \u00a7eflag!";
                p.sendMessage(message);
                PacketUtils.sendTitle(p, "", message, 0, 60, 0);
                if (t2 != null) {
                    if (event.getTeam() == t2) {
                        p.playSound(player.getLocation(), "ctf.enemycapturedtheflag", 500.0f, 1.0f);
                    } else {
                        p.playSound(player.getLocation(), "ctf.enemyflagcaptured", 500.0f, 1.0f);
                    }
                }
            });
        }
    }

    @EventHandler
    public void onPlayerLogout(PlayerQuitEvent event) {
        this.dropFlag(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(WarlordsDeathEvent event) {
        this.dropFlag(event.getPlayer());
    }

    public boolean dropFlag(Player player) {
        return this.dropFlag(Warlords.getPlayer(player));
    }

    public boolean dropFlag(@Nullable WarlordsPlayer player) {
        if (player == null) {
            return false;
        }
        FlagHolder.dropFlagForPlayer(player);
        return true;
    }
}

