/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.events;

import com.ebicep.warlords.events.AbstractWarlordsPlayerEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.AbstractCooldown;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.HandlerList;

public class WarlordsDamageHealingFinalEvent
extends AbstractWarlordsPlayerEvent {
    private static final HandlerList handlers = new HandlerList();
    private final List<CooldownRecord> playerCooldowns = new ArrayList<CooldownRecord>();
    private final List<CooldownRecord> attackerCooldowns = new ArrayList<CooldownRecord>();
    private final WarlordsPlayer attacker;
    private final String ability;
    private final int initialHealth;
    private final int finalHealth;
    private final float valueBeforeAllReduction;
    private final float valueBeforeInterveneReduction;
    private final float valueBeforeShieldReduction;
    private final float value;
    private final int critChance;
    private final int critMultiplier;
    private final boolean isCrit;
    private final boolean hasFlag;
    private final boolean isDead;
    private final boolean attackerInCombat;
    private boolean isDamageInstance;
    private int inGameTick;

    public WarlordsDamageHealingFinalEvent(WarlordsPlayer player, WarlordsPlayer attacker, String ability, int initialHealth, float valueBeforeAllReduction, float valueBeforeInterveneReduction, float valueBeforeShieldReduction, float value, int critChance, int critMultiplier, boolean isCrit, boolean isDamageInstance) {
        super(player);
        this.playerCooldowns.addAll(player.getCooldownManager().getCooldowns().stream().map(CooldownRecord::new).collect(Collectors.toList()));
        this.attackerCooldowns.addAll(attacker.getCooldownManager().getCooldowns().stream().map(CooldownRecord::new).collect(Collectors.toList()));
        this.attacker = attacker;
        this.ability = ability;
        this.initialHealth = initialHealth;
        this.finalHealth = player.getHealth();
        this.valueBeforeAllReduction = valueBeforeAllReduction;
        this.valueBeforeInterveneReduction = valueBeforeInterveneReduction;
        this.valueBeforeShieldReduction = valueBeforeShieldReduction;
        this.value = value;
        this.critChance = critChance;
        this.critMultiplier = critMultiplier;
        this.isCrit = isCrit;
        this.hasFlag = player.hasFlag();
        this.isDead = isDamageInstance && player.getHealth() <= 0 && !player.getCooldownManager().checkUndyingArmy(false);
        this.attackerInCombat = attacker.getRegenTimer() > 6;
        this.isDamageInstance = isDamageInstance;
        this.inGameTick = player.getGameState().getTicksElapsed();
    }

    public List<CooldownRecord> getPlayerCooldowns() {
        return this.playerCooldowns;
    }

    public List<CooldownRecord> getAttackerCooldowns() {
        return this.attackerCooldowns;
    }

    public WarlordsPlayer getAttacker() {
        return this.attacker;
    }

    public String getAbility() {
        return this.ability;
    }

    public int getInitialHealth() {
        return this.initialHealth;
    }

    public int getFinalHealth() {
        return this.finalHealth;
    }

    public float getValueBeforeAllReduction() {
        return this.valueBeforeAllReduction;
    }

    public float getValueBeforeInterveneReduction() {
        return this.valueBeforeInterveneReduction;
    }

    public float getValueBeforeShieldReduction() {
        return this.valueBeforeShieldReduction;
    }

    public float getValue() {
        return this.value;
    }

    public int getCritChance() {
        return this.critChance;
    }

    public int getCritMultiplier() {
        return this.critMultiplier;
    }

    public boolean isCrit() {
        return this.isCrit;
    }

    public boolean isHasFlag() {
        return this.hasFlag;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isAttackerInCombat() {
        return this.attackerInCombat;
    }

    public boolean isDamageInstance() {
        return this.isDamageInstance;
    }

    public boolean isHealingInstance() {
        return !this.isDamageInstance;
    }

    public int getInGameTick() {
        return this.inGameTick;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public String toString() {
        return "WarlordsDamageHealingFinalEvent{playerCooldowns=" + this.playerCooldowns + ", attackerCooldowns=" + this.attackerCooldowns + ", attacker=" + this.attacker + ", ability='" + this.ability + '\'' + ", initialHealth=" + this.initialHealth + ", finalHealth=" + this.finalHealth + ", valueBeforeAllReduction=" + this.valueBeforeAllReduction + ", valueBeforeInterveneReduction=" + this.valueBeforeInterveneReduction + ", valueBeforeShieldReduction=" + this.valueBeforeShieldReduction + ", value=" + this.value + ", critChance=" + this.critChance + ", critMultiplier=" + this.critMultiplier + ", isCrit=" + this.isCrit + ", hasFlag=" + this.hasFlag + ", isDead=" + this.isDead + ", attackerInCombat=" + this.attackerInCombat + ", isDamageInstance=" + this.isDamageInstance + ", inGameTick=" + this.inGameTick + '}';
    }

    public static class CooldownRecord {
        private final AbstractCooldown<?> abstractCooldown;
        private final int ticksLeft;

        public CooldownRecord(AbstractCooldown<?> abstractCooldown) {
            this.abstractCooldown = abstractCooldown;
            this.ticksLeft = abstractCooldown instanceof RegularCooldown ? ((RegularCooldown)abstractCooldown).getTicksLeft() : -1;
        }

        public AbstractCooldown<?> getAbstractCooldown() {
            return this.abstractCooldown;
        }

        public int getTicksLeft() {
            return this.ticksLeft;
        }
    }
}

