/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects.circle;

import com.ebicep.warlords.effects.AbstractEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.TeamBasedEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public class LineEffect
extends AbstractEffectPlayer<CircleEffect> {
    private final DoubleUnaryOperator INITIAL_PARTICLES;
    @Nonnull
    private TeamBasedEffect effect;
    @Nonnull
    private DoubleUnaryOperator particles;
    private double pendingParticles;
    private double period;
    private double pendingPeriod;
    private Location target;

    public LineEffect(Location target, ParticleEffect own, ParticleEffect other) {
        this(target, new TeamBasedEffect(own, other));
    }

    public LineEffect(Location target, ParticleEffect effect) {
        this(target, new TeamBasedEffect(effect));
    }

    public LineEffect(Location target, TeamBasedEffect effect) {
        this.particles = this.INITIAL_PARTICLES = i -> Math.sqrt(i) * 2.0;
        this.pendingParticles = 0.0;
        this.period = 0.2;
        this.pendingPeriod = 0.0;
        this.target = target;
        this.effect = effect;
    }

    @Override
    public void playEffect(CircleEffect baseData) {
        Location center = baseData.getCenter();
        double radius = baseData.getRadius();
        CircleEffect.LOCATION_CACHE.setY(center.getY());
        double newLines = this.pendingPeriod + this.period;
        int maxNewLines = (int)newLines;
        this.pendingPeriod = newLines - (double)maxNewLines;
        for (int i = 0; i < maxNewLines; ++i) {
            double xA = this.target.getX();
            double yA = this.target.getY();
            double zA = this.target.getZ();
            double angleB = (double)CircleEffect.RANDOM.nextInt(360) * Math.PI / 180.0;
            double xB = center.getX() + radius * Math.sin(angleB);
            double yB = center.getY();
            double zB = center.getZ() + radius * Math.cos(angleB);
            double distanceSquared = (xA - xB) * (xA - xB) + (yA - yB) * (yA - yB) + (zA - zB) * (zA - zB);
            double newPoints = this.pendingParticles + this.particles.applyAsDouble(distanceSquared);
            int maxNewPoints = (int)newPoints;
            this.pendingParticles = newPoints - (double)maxNewPoints;
            double maxNewPointsMinusOne = maxNewPoints - 1;
            for (int j = 0; j < maxNewPoints; ++j) {
                double factorA = (double)j / maxNewPointsMinusOne;
                double factorB = 1.0 - (double)j / maxNewPointsMinusOne;
                CircleEffect.LOCATION_CACHE.setX(xA * factorA + xB * factorB);
                CircleEffect.LOCATION_CACHE.setY(yA * factorA + yB * factorB);
                CircleEffect.LOCATION_CACHE.setZ(zA * factorA + zB * factorB);
                this.effect.display(baseData.players, 0.0f, 0.0f, 0.0f, 0.0f, 1, CircleEffect.LOCATION_CACHE);
            }
        }
    }

    public Location getTarget() {
        return this.target;
    }

    public LineEffect target(Location target) {
        this.target = target;
        return this;
    }

    @Override
    public void updateCachedData(CircleEffect baseData) {
        this.needsUpdate = false;
    }

    public LineEffect effect(@Nonnull ParticleEffect effect) {
        this.effect = new TeamBasedEffect(effect);
        return this;
    }

    public LineEffect effect(@Nonnull ParticleEffect ownTeam, @Nonnull ParticleEffect enemyTeam) {
        this.effect = new TeamBasedEffect(ownTeam, enemyTeam);
        return this;
    }

    public LineEffect particles(double particles) {
        this.particles = d -> particles;
        return this;
    }

    public LineEffect particlesPerBlock(double particles) {
        this.particles = d -> Math.sqrt(d) * particles;
        return this;
    }

    public double getPeriod() {
        return this.period;
    }

    public LineEffect period(double period) {
        this.period = period;
        return this;
    }
}

