/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects.circle;

import com.ebicep.warlords.effects.AbstractEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.TeamBasedEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public class DoubleLineEffect
extends AbstractEffectPlayer<CircleEffect> {
    private final DoubleUnaryOperator INITIAL_PARTICLES;
    @Nonnull
    private TeamBasedEffect effect;
    @Nonnull
    private DoubleUnaryOperator particles;
    private double pendingParticles;
    private double period;
    private double pendingPeriod;

    public DoubleLineEffect(ParticleEffect own, ParticleEffect other) {
        this(new TeamBasedEffect(own, other));
    }

    public DoubleLineEffect(ParticleEffect effect) {
        this(new TeamBasedEffect(effect));
    }

    public DoubleLineEffect(TeamBasedEffect effect) {
        this.particles = this.INITIAL_PARTICLES = i -> Math.sqrt(i) * 1.5;
        this.pendingParticles = 0.0;
        this.period = 0.2;
        this.pendingPeriod = 0.0;
        this.effect = effect;
    }

    @Override
    public void playEffect(CircleEffect baseData) {
        Location center = baseData.getCenter();
        double radius = baseData.getRadius();
        CircleEffect.LOCATION_CACHE.setY(center.getY());
        double newLines = this.pendingPeriod + this.period;
        int maxNewLines = (int)newLines;
        this.pendingPeriod = newLines - (double)maxNewLines;
        for (int i = 0; i < maxNewLines; ++i) {
            double angleB;
            double angleA;
            double difference;
            do {
                if (!((difference = Math.abs((angleA = (double)CircleEffect.RANDOM.nextInt(360) * Math.PI / 180.0) - (angleB = (double)CircleEffect.RANDOM.nextInt(360) * Math.PI / 180.0))) > Math.PI)) continue;
                difference = Math.PI * 2 - difference;
            } while (difference < 0.7853981633974483);
            double xA = radius * Math.sin(angleA);
            double zA = radius * Math.cos(angleA);
            double xB = radius * Math.sin(angleB);
            double zB = radius * Math.cos(angleB);
            double distanceSquared = (xA - xB) * (xA - xB) + (zA - zB) * (zA - zB);
            double newPoints = this.pendingParticles + this.particles.applyAsDouble(distanceSquared);
            int maxNewPoints = (int)newPoints;
            this.pendingParticles = newPoints - (double)maxNewPoints;
            double maxNewPointsMinusOne = maxNewPoints - 1;
            for (int j = 0; j < maxNewPoints; ++j) {
                double factorA = (double)j / maxNewPointsMinusOne;
                double factorB = 1.0 - (double)j / maxNewPointsMinusOne;
                CircleEffect.LOCATION_CACHE.setX(xA * factorA + xB * factorB + center.getX());
                CircleEffect.LOCATION_CACHE.setZ(zA * factorA + zB * factorB + center.getZ());
                this.effect.display(baseData.players, 0.0f, 0.0f, 0.0f, 0.0f, 1, CircleEffect.LOCATION_CACHE);
            }
        }
    }

    @Override
    public void updateCachedData(CircleEffect baseData) {
        this.needsUpdate = false;
    }

    public DoubleLineEffect effect(@Nonnull ParticleEffect effect) {
        this.effect = new TeamBasedEffect(effect);
        return this;
    }

    public DoubleLineEffect effect(@Nonnull ParticleEffect ownTeam, @Nonnull ParticleEffect enemyTeam) {
        this.effect = new TeamBasedEffect(ownTeam, enemyTeam);
        return this;
    }

    public DoubleLineEffect particles(double particles) {
        this.particles = d -> particles;
        return this;
    }

    public DoubleLineEffect particlesPerBlock(double particles) {
        this.particles = d -> Math.sqrt(d) * particles;
        return this;
    }

    public double getPeriod() {
        return this.period;
    }

    public DoubleLineEffect period(double period) {
        this.period = period;
        return this;
    }
}

