/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects.circle;

import com.ebicep.warlords.effects.AbstractEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.TeamBasedEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public class CircumferenceEffect
extends AbstractEffectPlayer<CircleEffect> {
    private final DoubleUnaryOperator INITIAL_PARTICLES;
    @Nonnull
    private TeamBasedEffect effect;
    @Nonnull
    private DoubleUnaryOperator particles;
    private double cachedParticles;
    private double pendingParticles;

    public CircumferenceEffect(ParticleEffect own, ParticleEffect other) {
        this(new TeamBasedEffect(own, other));
    }

    public CircumferenceEffect(ParticleEffect effect) {
        this(new TeamBasedEffect(effect));
    }

    public CircumferenceEffect(TeamBasedEffect effect) {
        this.particles = this.INITIAL_PARTICLES = i -> Math.PI * 2 * i * 0.05;
        this.effect = effect;
    }

    @Override
    public void playEffect(CircleEffect baseData) {
        Location center = baseData.getCenter();
        double radius = baseData.getRadius();
        CircleEffect.LOCATION_CACHE.setY(center.getY());
        double newParticles = this.pendingParticles + this.cachedParticles;
        int maxCircleParticles = (int)newParticles;
        this.pendingParticles = newParticles - (double)maxCircleParticles;
        for (int i = 0; i < maxCircleParticles; ++i) {
            double angle = (double)CircleEffect.RANDOM.nextInt(360) * Math.PI / 180.0;
            CircleEffect.LOCATION_CACHE.setX(radius * Math.sin(angle) + center.getX());
            CircleEffect.LOCATION_CACHE.setZ(radius * Math.cos(angle) + center.getZ());
            CircleEffect.LOCATION_CACHE.setY(center.getY());
            do {
                CircleEffect.LOCATION_CACHE.setY(CircleEffect.LOCATION_CACHE.getY() - 1.0);
            } while (CircleEffect.LOCATION_CACHE.getY() >= 0.0 && !CircleEffect.LOCATION_CACHE.getBlock().getType().isOccluding());
            CircleEffect.LOCATION_CACHE.setY(CircleEffect.LOCATION_CACHE.getY() + 1.0);
            this.effect.display(baseData.players, 0.0f, 0.0f, 0.0f, 0.0f, 1, CircleEffect.LOCATION_CACHE);
        }
    }

    @Override
    public void updateCachedData(CircleEffect baseData) {
        this.cachedParticles = this.particles.applyAsDouble(baseData.getRadius());
        this.needsUpdate = false;
    }

    public CircumferenceEffect effect(@Nonnull ParticleEffect effect) {
        this.effect = new TeamBasedEffect(effect);
        return this;
    }

    public CircumferenceEffect effect(@Nonnull ParticleEffect ownTeam, @Nonnull ParticleEffect enemyTeam) {
        this.effect = new TeamBasedEffect(ownTeam, enemyTeam);
        return this;
    }

    public CircumferenceEffect particles(double particles) {
        this.particles = d -> particles;
        this.needsUpdate = true;
        return this;
    }

    public CircumferenceEffect particlesPerCircumference(double particles) {
        this.particles = d -> Math.PI * 2 * d * particles;
        this.needsUpdate = true;
        return this;
    }
}

