/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects.circle;

import com.ebicep.warlords.effects.AbstractBaseAreaEffect;
import com.ebicep.warlords.effects.EffectPlayer;
import com.ebicep.warlords.effects.GameTeamContainer;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;

public class CircleEffect
extends AbstractBaseAreaEffect<EffectPlayer<? super CircleEffect>> {
    static final Random RANDOM = new Random();
    static final Location LOCATION_CACHE = new Location(null, 0.0, 0.0, 0.0);
    private double radius;
    @Nonnull
    final GameTeamContainer players;

    @SafeVarargs
    public CircleEffect(@Nonnull WarlordsPlayer wp, @Nonnull Location center, double radius, EffectPlayer<? super CircleEffect> ... effects) {
        this(wp.getGame(), wp.getTeam(), center, radius, effects);
    }

    @SafeVarargs
    public CircleEffect(@Nonnull Game game, @Nullable Team team, @Nonnull Location center, double radius, EffectPlayer<? super CircleEffect> ... effects) {
        Validate.notNull((Object)game, (String)"game");
        Validate.notNull((Object)center, (String)"center");
        center.setY((double)center.getBlockY() + 0.01);
        this.center = center;
        this.radius = radius;
        this.players = new GameTeamContainer(game, team);
        this.addEffects(effects);
    }

    public Team getTeam() {
        return this.players.getTeam();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        for (EffectPlayer effect : this) {
            effect.updateCachedData(this);
        }
    }

    @Override
    public void playEffects() {
        LOCATION_CACHE.setWorld(this.center.getWorld());
        for (EffectPlayer effect : this) {
            if (effect.needsUpdate()) {
                effect.updateCachedData(this);
            }
            effect.playEffect(this);
        }
    }
}

