/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects.circle;

import com.ebicep.warlords.effects.AbstractEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.TeamBasedEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public final class AreaEffect
extends AbstractEffectPlayer<CircleEffect> {
    private final DoubleUnaryOperator INITIAL_PARTICLES;
    @Nonnull
    private TeamBasedEffect effect;
    @Nonnull
    private DoubleUnaryOperator particles;
    private double cachedParticles;
    private double pendingParticles;
    private double yOffset;

    public AreaEffect(double yOffset, ParticleEffect own, ParticleEffect other) {
        this(yOffset, new TeamBasedEffect(own, other));
    }

    public AreaEffect(double yOffset, ParticleEffect effect) {
        this(yOffset, new TeamBasedEffect(effect));
    }

    public AreaEffect(double yOffset, TeamBasedEffect effect) {
        this.particles = this.INITIAL_PARTICLES = i -> Math.PI * i * i * 0.1;
        this.yOffset = yOffset;
        this.effect = effect;
    }

    @Override
    public void playEffect(CircleEffect baseData) {
        Location center = baseData.getCenter();
        double radius = baseData.getRadius();
        CircleEffect.LOCATION_CACHE.setY(center.getY() + this.yOffset);
        double newParticles = this.pendingParticles + this.cachedParticles;
        int maxParticles = (int)newParticles;
        this.pendingParticles = newParticles - (double)maxParticles;
        for (int i = 0; i < maxParticles; ++i) {
            double z;
            double x;
            double distanceSquared;
            while ((distanceSquared = (x = CircleEffect.RANDOM.nextDouble() * radius * 2.0 - radius) * x + (z = CircleEffect.RANDOM.nextDouble() * radius * 2.0 - radius) * z) > radius * radius) {
            }
            CircleEffect.LOCATION_CACHE.setX(x + center.getX());
            CircleEffect.LOCATION_CACHE.setZ(z + center.getZ());
            this.effect.display(baseData.players, 0.0f, 0.0f, 0.0f, 0.01f, 1, CircleEffect.LOCATION_CACHE);
        }
    }

    @Override
    public void updateCachedData(CircleEffect baseData) {
        this.cachedParticles = this.particles.applyAsDouble(baseData.getRadius());
        this.needsUpdate = false;
    }

    public AreaEffect effect(@Nonnull ParticleEffect effect) {
        this.effect = new TeamBasedEffect(effect);
        return this;
    }

    public AreaEffect effect(@Nonnull ParticleEffect ownTeam, @Nonnull ParticleEffect enemyTeam) {
        this.effect = new TeamBasedEffect(ownTeam, enemyTeam);
        return this;
    }

    public AreaEffect particles(double particles) {
        this.particles = d -> particles;
        this.needsUpdate = true;
        return this;
    }

    public AreaEffect particlesPerSurface(double particles) {
        this.particles = d -> Math.PI * d * d * particles;
        this.needsUpdate = true;
        return this;
    }

    public double getyOffset() {
        return this.yOffset;
    }

    public AreaEffect yOffset(double yOffset) {
        this.yOffset = yOffset;
        return this;
    }
}

