/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import com.ebicep.warlords.effects.GameTeamContainer;
import com.ebicep.warlords.effects.ParticleEffect;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class TeamBasedEffect {
    @Nonnull
    final ParticleEffect ownTeam;
    @Nonnull
    final ParticleEffect enemyTeam;

    public TeamBasedEffect(@Nonnull ParticleEffect effect) {
        this(effect, effect);
    }

    public TeamBasedEffect(@Nonnull ParticleEffect ownTeam, @Nonnull ParticleEffect enemyTeam) {
        this.ownTeam = ownTeam;
        this.enemyTeam = enemyTeam;
    }

    public void display(GameTeamContainer teams, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center) {
        this.ownTeam.display(offsetX, offsetY, offsetZ, speed, amount, center, teams.getAllyPlayers().collect(Collectors.toList()));
        this.enemyTeam.display(offsetX, offsetY, offsetZ, speed, amount, center, teams.getEnemyPlayers().collect(Collectors.toList()));
    }

    public void display(GameTeamContainer teams, Vector direction, float speed, Location center) {
        this.ownTeam.display(direction, speed, center, teams.getAllyPlayers().collect(Collectors.toList()));
        this.enemyTeam.display(direction, speed, center, teams.getEnemyPlayers().collect(Collectors.toList()));
    }

    public void display(GameTeamContainer teams, ParticleEffect.ParticleColor color, Location center) {
        this.ownTeam.display(color, center, teams.getAllyPlayers().collect(Collectors.toList()));
        this.enemyTeam.display(color, center, teams.getEnemyPlayers().collect(Collectors.toList()));
    }

    public void display(GameTeamContainer teams, ParticleEffect.ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center) {
        this.ownTeam.display(data, offsetX, offsetY, offsetZ, speed, amount, center, teams.getAllyPlayers().collect(Collectors.toList()));
        this.enemyTeam.display(data, offsetX, offsetY, offsetZ, speed, amount, center, teams.getEnemyPlayers().collect(Collectors.toList()));
    }

    public void display(GameTeamContainer teams, ParticleEffect.ParticleData data, Vector direction, float speed, Location center) {
        this.ownTeam.display(data, direction, speed, center, teams.getAllyPlayers().collect(Collectors.toList()));
        this.enemyTeam.display(data, direction, speed, center, teams.getEnemyPlayers().collect(Collectors.toList()));
    }

    public String toString() {
        return "TeamBasedEffect{ownTeam=" + (Object)((Object)this.ownTeam) + ", enemyTeam=" + (Object)((Object)this.enemyTeam) + '}';
    }
}

