/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class GameTeamContainer {
    private final Game game;
    private final Team team;

    public GameTeamContainer(Game game, @Nullable Team team) {
        this.game = game;
        this.team = team;
    }

    public Team getTeam() {
        return this.team;
    }

    public Stream<Player> getAllyPlayers() {
        return GameTeamContainer.getAllyPlayers(this.game, this.team);
    }

    public static Stream<Player> getAllyPlayers(Game game, Team team) {
        return game.onlinePlayersWithoutSpectators().filter(e -> e.getValue() == team).map(e -> (Player)e.getKey());
    }

    public Stream<Player> getEnemyPlayers() {
        return GameTeamContainer.getEnemyPlayers(this.game, this.team);
    }

    public static Stream<Player> getEnemyPlayers(Game game, Team team) {
        return game.onlinePlayersWithoutSpectators().filter(e -> e.getValue() != team).map(e -> (Player)e.getKey());
    }
}

