/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireWorkEffectPlayer {
    private static Method firework_getHandle = null;
    private static Field fireworkTicksLived = null;
    private static Field expectedLifespan = null;
    private static boolean fireworksDisabled = false;

    public static boolean playFirework(Location loc, FireworkEffect ... fe) {
        return FireWorkEffectPlayer.playFirework(loc.getWorld(), loc, fe);
    }

    public static boolean playFirework(World world, Location loc, FireworkEffect ... fe) {
        Objects.requireNonNull(world, "world == null");
        Objects.requireNonNull(loc, "loc == null");
        Objects.requireNonNull(fe, "fe == null");
        for (int i = 0; i < fe.length; ++i) {
            Objects.requireNonNull(fe[i++], "fe[" + i + "] == null");
        }
        if (!loc.getWorld().equals(world)) {
            throw new IllegalArgumentException("loc not in world");
        }
        if (fireworksDisabled) {
            return false;
        }
        try {
            FireWorkEffectPlayer.playFirework0(world, loc, fe);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot use fireworks in this server", ex);
            fireworksDisabled = true;
            return false;
        }
    }

    private static void playFirework0(World world, Location loc, FireworkEffect ... fe) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException, NoSuchMethodException {
        Objects.requireNonNull(world);
        Firework fw = (Firework)world.spawn(loc, Firework.class);
        fw.teleport(loc);
        if (firework_getHandle == null) {
            firework_getHandle = FireWorkEffectPlayer.getMethod(fw.getClass(), "getHandle");
        }
        Object nms_firework = firework_getHandle.invoke((Object)fw, (Object[])null);
        if (fireworkTicksLived == null) {
            fireworkTicksLived = nms_firework.getClass().getDeclaredField("ticksFlown");
            fireworkTicksLived.setAccessible(true);
            expectedLifespan = nms_firework.getClass().getDeclaredField("expectedLifespan");
            expectedLifespan.setAccessible(true);
        }
        FireworkMeta data = fw.getFireworkMeta();
        data.clearEffects();
        data.addEffect(fe[0]);
        fw.setFireworkMeta(data);
        fireworkTicksLived.set(nms_firework, 1);
        expectedLifespan.set(nms_firework, 2);
    }

    private static Method getMethod(Class<?> cl, String method) throws NoSuchMethodException {
        for (Method m4 : cl.getMethods()) {
            if (!m4.getName().equals(method)) continue;
            return m4;
        }
        throw new NoSuchMethodException(method + " on class " + cl);
    }
}

