/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.events.WarlordsEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FallingBlockWaveEffect {
    private final List<Stand> stands;

    public FallingBlockWaveEffect(Location center, double range, double speed, Material material, byte damage) {
        this.stands = new ArrayList<Stand>((int)(Math.pow(Math.ceil(range), 2.0) * Math.PI * 1.1));
        double doubleRange = range * range;
        int x = (int)(-range);
        while ((double)x <= range) {
            int z = (int)(-range);
            while ((double)z <= range) {
                double distanceSquared = x * x + z * z;
                if (distanceSquared < doubleRange) {
                    this.stands.add(new Stand(center.clone().add((double)x, 0.0, (double)z), (int)(-Math.sqrt(distanceSquared) / speed), material, damage));
                }
                if ((int)(Math.random() * 5.0) == 1) {
                    ++z;
                }
                ++z;
            }
            if ((int)(Math.random() * 5.0) == 1) {
                ++x;
            }
            ++x;
        }
        Collections.sort(this.stands, Comparator.comparing(Stand::getTimer).reversed());
    }

    public void play() {
        new BukkitRunnable(){

            public void run() {
                int size = FallingBlockWaveEffect.this.stands.size();
                if (size == 0) {
                    this.cancel();
                    return;
                }
                ListIterator itr = FallingBlockWaveEffect.this.stands.listIterator(size);
                while (itr.hasPrevious()) {
                    if (!((Stand)itr.previous()).tick()) continue;
                    itr.remove();
                }
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 1L, 1L);
    }

    class Stand {
        private final Location loc;
        private int timer;
        private final Material material;
        private final byte damage;
        private FallingBlock fallingBlock;

        public Stand(Location loc, int timer, Material material, byte damage) {
            this.loc = loc;
            this.timer = timer;
            this.material = material;
            this.damage = damage;
        }

        public int getTimer() {
            return this.timer;
        }

        public boolean tick() {
            ++this.timer;
            if (this.timer == 0) {
                this.fallingBlock = this.loc.getWorld().spawnFallingBlock(this.loc, this.material, this.damage);
                this.fallingBlock.setVelocity(new Vector(0.0, 0.05, 0.0));
                this.fallingBlock.setDropItem(false);
                WarlordsEvents.addEntityUUID((Entity)this.fallingBlock);
                return false;
            }
            if (this.timer == 6) {
                if (this.fallingBlock != null) {
                    this.fallingBlock.remove();
                }
                return true;
            }
            return false;
        }
    }
}

