/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class EffectUtils {
    public static void playSphereAnimation(Player player, double sphereRadius, int red, int green, int blue) {
        EffectUtils.playSphereAnimation(player.getLocation(), sphereRadius, red, green, blue);
    }

    public static void playSphereAnimation(Location particleLoc, double sphereRadius, int red, int green, int blue) {
        particleLoc.add(0.0, 1.0, 0.0);
        for (double i = 0.0; i <= Math.PI; i += 0.3141592653589793) {
            double radius = Math.sin(i) * sphereRadius + 0.5;
            double y = Math.cos(i) * sphereRadius;
            for (double a = 0.0; a < Math.PI * 2; a += 0.3141592653589793) {
                double x = Math.cos(a) * radius;
                double z = Math.sin(a) * radius;
                particleLoc.add(x, y, z);
                ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(red, green, blue), particleLoc, 500.0);
                particleLoc.subtract(x, y, z);
            }
        }
    }

    public static void playSphereAnimation(Player player, double sphereRadius, ParticleEffect effect, int particleCount) {
        EffectUtils.playSphereAnimation(player.getLocation(), sphereRadius, effect, particleCount);
    }

    public static void playSphereAnimation(Location particleLoc, double sphereRadius, ParticleEffect effect, int particleCount) {
        particleLoc.add(0.0, 1.0, 0.0);
        for (double i = 0.0; i <= Math.PI; i += 0.3141592653589793) {
            double radius = Math.sin(i) * sphereRadius + 0.5;
            double y = Math.cos(i) * sphereRadius;
            for (double a = 0.0; a < Math.PI * 2; a += 0.3141592653589793) {
                double x = Math.cos(a) * radius;
                double z = Math.sin(a) * radius;
                particleLoc.add(x, y, z);
                effect.display(0.0f, 0.0f, 0.0f, 0.0f, particleCount, particleLoc, 500.0);
                particleLoc.subtract(x, y, z);
            }
        }
    }

    public static void playHelixAnimation(Player player, double helixRadius, int red, int green, int blue) {
        EffectUtils.playHelixAnimation(player.getLocation(), helixRadius, red, green, blue);
    }

    public static void playHelixAnimation(Location location, double helixRadius, int red, int green, int blue) {
        double rotation = 0.7853981633974483;
        int particles = 40;
        int strands = 8;
        int curve = 10;
        for (int i = 1; i <= strands; ++i) {
            for (int j = 1; j <= particles; ++j) {
                float ratio = (float)j / (float)particles;
                double angle = (double)((float)curve * ratio * 2.0f) * Math.PI / (double)strands + Math.PI * 2 * (double)i / (double)strands + rotation;
                double x = Math.cos(angle) * (double)ratio * helixRadius;
                double z = Math.sin(angle) * (double)ratio * helixRadius;
                location.add(x, 0.0, z);
                ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(red, green, blue), location, 500.0);
                location.subtract(x, 0.0, z);
            }
        }
    }

    public static void playHelixAnimation(Player player, double helixRadius, ParticleEffect effect, int particleCount) {
        EffectUtils.playHelixAnimation(player.getLocation(), helixRadius, effect, particleCount);
    }

    public static void playHelixAnimation(Location location, double helixRadius, ParticleEffect effect, int particleCount) {
        double rotation = 0.7853981633974483;
        int particles = 20;
        int strands = 4;
        int curve = 10;
        for (int i = 1; i <= strands; ++i) {
            for (int j = 1; j <= particles; ++j) {
                float ratio = (float)j / (float)particles;
                double angle = (double)((float)curve * ratio * 2.0f) * Math.PI / (double)strands + Math.PI * 2 * (double)i / (double)strands + rotation;
                double x = Math.cos(angle) * (double)ratio * helixRadius;
                double z = Math.sin(angle) * (double)ratio * helixRadius;
                location.add(x, 0.0, z);
                effect.display(0.0f, 0.0f, 0.0f, 0.0f, particleCount, location, 500.0);
                location.subtract(x, 0.0, z);
            }
        }
    }

    public static void playCylinderAnimation(Player player, double cylinderRadius, int red, int green, int blue) {
        EffectUtils.playCylinderAnimation(player.getLocation(), cylinderRadius, red, green, blue);
    }

    public static void playCylinderAnimation(Location location, double cylinderRadius, int red, int green, int blue) {
        Location particleLoc = location.clone();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                double angle = (double)j / 10.0 * Math.PI * 2.0;
                particleLoc.setX(location.getX() + Math.sin(angle) * cylinderRadius);
                particleLoc.setY(location.getY() + (double)i / 5.0);
                particleLoc.setZ(location.getZ() + Math.cos(angle) * cylinderRadius);
                ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(red, green, blue), particleLoc, 500.0);
            }
        }
    }

    public static void playCylinderAnimation(Player player, double cylinderRadius, ParticleEffect effect, int particleCount) {
        Location playerLoc = player.getLocation();
        Location particleLoc = playerLoc.clone();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                double angle = (double)j / 10.0 * Math.PI * 2.0;
                particleLoc.setX(playerLoc.getX() + Math.sin(angle) * cylinderRadius);
                particleLoc.setY(playerLoc.getY() + (double)i / 5.0);
                particleLoc.setZ(playerLoc.getZ() + Math.cos(angle) * cylinderRadius);
                effect.display(0.0f, 0.0f, 0.0f, 0.0f, particleCount, particleLoc, 500.0);
            }
        }
    }

    public static void playCylinderAnimation(Location location, double cylinderRadius, ParticleEffect effect, int particleCount) {
        Location particleLoc = location.clone();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                double angle = (double)j / 10.0 * Math.PI * 2.0;
                particleLoc.setX(location.getX() + Math.sin(angle) * cylinderRadius);
                particleLoc.setY(location.getY() + (double)i / 5.0);
                particleLoc.setZ(location.getZ() + Math.cos(angle) * cylinderRadius);
                effect.display(0.0f, 0.0f, 0.0f, 0.0f, particleCount, particleLoc, 500.0);
            }
        }
    }

    public static void playStarAnimation(Player player, float starRadius, ParticleEffect effect) {
        Location location = player.getLocation();
        int spikesHalf = 3;
        float spikeHeight = 3.5f;
        int particles = 30;
        float radius = 3.0f * starRadius / 1.73205f;
        for (int i = 0; i < spikesHalf * 2; ++i) {
            double xRotation = (double)i * Math.PI / (double)spikesHalf;
            for (int x = 0; x < particles; ++x) {
                double angle = Math.PI * 2 * (double)x / (double)particles;
                Random random = new Random(System.nanoTime());
                float height = random.nextFloat() * spikeHeight;
                Vector v = new Vector(Math.cos(angle), 0.0, Math.sin(angle));
                v.multiply((spikeHeight - height) * radius / spikeHeight);
                v.setY(starRadius + height);
                EffectUtils.rotateAroundAxisX(v, xRotation);
                location.add(v);
                effect.display(0.0f, 0.0f, 0.0f, 0.0f, 1, location, 500.0);
                location.subtract(v);
            }
        }
    }

    public static void playStarAnimation(Location location, float starRadius, ParticleEffect effect) {
        int spikesHalf = 3;
        float spikeHeight = 3.5f;
        int particles = 30;
        float radius = 3.0f * starRadius / 1.73205f;
        for (int i = 0; i < spikesHalf * 2; ++i) {
            double xRotation = (double)i * Math.PI / (double)spikesHalf;
            for (int x = 0; x < particles; ++x) {
                double angle = Math.PI * 2 * (double)x / (double)particles;
                Random random = new Random(System.nanoTime());
                float height = random.nextFloat() * spikeHeight;
                Vector v = new Vector(Math.cos(angle), 0.0, Math.sin(angle));
                v.multiply((spikeHeight - height) * radius / spikeHeight);
                v.setY(starRadius + height);
                EffectUtils.rotateAroundAxisY(v, xRotation);
                location.add(v);
                effect.display(0.0f, 0.0f, 0.0f, 0.0f, 1, location, 500.0);
                location.subtract(v);
            }
        }
    }

    public static void playChainAnimation(Location location1, Location location2, ItemStack item, final int ticksLived) {
        Location from = location1.clone().add(0.0, -0.6, 0.0);
        Location to = location2.clone().add(0.0, -0.6, 0.0);
        from.setDirection(from.toVector().subtract(to.toVector()).multiply(-1));
        final ArrayList<ArmorStand> chains = new ArrayList<ArmorStand>();
        int maxDistance = (int)Math.round(to.distance(from));
        for (int i = 0; i < maxDistance; ++i) {
            ArmorStand chain = (ArmorStand)from.getWorld().spawn(from, ArmorStand.class);
            chain.setHeadPose(new EulerAngle(from.getDirection().getY() * -1.0, 0.0, 0.0));
            chain.setGravity(false);
            chain.setVisible(false);
            chain.setBasePlate(false);
            chain.setMarker(true);
            chain.setHelmet(item);
            from.add(from.getDirection().multiply(1.1));
            chains.add(chain);
            if (to.distanceSquared(from) < 0.3) break;
        }
        new BukkitRunnable(){

            public void run() {
                if (chains.size() == 0) {
                    this.cancel();
                }
                for (int i = 0; i < chains.size(); ++i) {
                    ArmorStand armorStand = (ArmorStand)chains.get(i);
                    if (armorStand.getTicksLived() <= ticksLived) continue;
                    armorStand.remove();
                    chains.remove(i);
                    --i;
                }
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 0L);
    }

    public static void playChainAnimation(Player player1, Player player2, ItemStack item, int ticksLived) {
        EffectUtils.playChainAnimation(player1.getLocation(), player2.getLocation(), item, ticksLived);
    }

    public static void playChainAnimation(WarlordsPlayer player1, WarlordsPlayer player2, ItemStack item, int ticksLived) {
        EffectUtils.playChainAnimation(player1.getLocation(), player2.getLocation(), item, ticksLived);
    }

    public static void playParticleLinkAnimation(Location to, Location from, ParticleEffect effect) {
        to = to.clone();
        from = from.clone();
        Location lineLocation = to.add(0.0, 1.0, 0.0).clone();
        lineLocation.setDirection(lineLocation.toVector().subtract(from.add(0.0, 1.0, 0.0).toVector()).multiply(-1));
        int i = 0;
        while ((double)i < Math.floor(to.distance(from)) * 2.0) {
            effect.display(0.0f, 0.0f, 0.0f, 0.0f, 1, lineLocation, 500.0);
            lineLocation.add(lineLocation.getDirection().multiply(0.5));
            ++i;
        }
    }

    public static void playParticleLinkAnimation(Location to, Location from, int red, int green, int blue, int amount) {
        to = to.clone();
        from = from.clone();
        Location lineLocation = to.add(0.0, 1.0, 0.0).clone();
        lineLocation.setDirection(lineLocation.toVector().subtract(from.add(0.0, 1.0, 0.0).toVector()).multiply(-1));
        int i = 0;
        while ((double)i < Math.floor(to.distance(from)) * 2.0) {
            for (int i1 = 0; i1 < amount; ++i1) {
                ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(red, green, blue), lineLocation, 500.0);
            }
            lineLocation.add(lineLocation.getDirection().multiply(0.5));
            ++i;
        }
    }

    public static Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }
}

