/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import com.ebicep.warlords.Warlords;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorStandWaveEffect {
    private final List<Stand> stands;

    public ArmorStandWaveEffect(Location center, double range, double speed, ItemStack texture) {
        this.stands = new ArrayList<Stand>((int)(Math.pow(Math.ceil(range), 2.0) * Math.PI * 1.1));
        double doubleRange = range * range;
        int x = (int)(-range);
        while ((double)x <= range) {
            int z = (int)(-range);
            while ((double)z <= range) {
                double distanceSquared = x * x + z * z;
                if (distanceSquared < doubleRange) {
                    this.stands.add(new Stand(center.clone().add((double)x, -1.0, (double)z), (int)(-Math.sqrt(distanceSquared) * speed), texture));
                }
                ++z;
            }
            ++x;
        }
        Collections.sort(this.stands, Comparator.comparing(Stand::getTimer).reversed());
    }

    public void play() {
        new BukkitRunnable(){

            public void run() {
                int size = ArmorStandWaveEffect.this.stands.size();
                if (size == 0) {
                    this.cancel();
                    return;
                }
                ListIterator itr = ArmorStandWaveEffect.this.stands.listIterator(size);
                while (itr.hasPrevious()) {
                    if (!((Stand)itr.previous()).tick()) continue;
                    itr.remove();
                }
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 1L, 1L);
    }

    class Stand {
        private final Location loc;
        private ArmorStand stand;
        private int timer;
        private final ItemStack texture;

        public Stand(Location loc, int timer, ItemStack texture) {
            this.loc = loc;
            this.timer = timer;
            this.texture = texture;
        }

        public int getTimer() {
            return this.timer;
        }

        public boolean tick() {
            ++this.timer;
            if (this.timer >= 0) {
                if (this.stand == null) {
                    this.stand = (ArmorStand)this.loc.getWorld().spawn(this.loc, ArmorStand.class);
                    this.stand.setGravity(false);
                    this.stand.setHelmet(this.texture);
                    this.stand.setBasePlate(false);
                    this.stand.setVisible(false);
                    this.stand.setMarker(true);
                }
                this.stand.teleport(this.stand.getLocation().add(0.0, 0.3 - (double)this.timer / 20.0, 0.0));
                if (this.timer > 20) {
                    this.stand.remove();
                    return true;
                }
            }
            return false;
        }
    }
}

