/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.effects;

import com.ebicep.warlords.effects.EffectPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public abstract class AbstractBaseAreaEffect<T extends EffectPlayer<?>>
implements Iterable<T> {
    @Nonnull
    protected Location center;
    protected final List<T> effects = new ArrayList<T>();

    public Location getCenter() {
        return this.center;
    }

    public void setCenter(Location center) {
        this.center = center;
    }

    public void addEffect(T effect) {
        this.effects.add(effect);
    }

    public void addEffects(T ... effect) {
        this.effects.addAll(Arrays.asList(effect));
    }

    public boolean removeEffect(T o) {
        return this.effects.remove(o);
    }

    public void clearEffects() {
        this.effects.clear();
    }

    public void replaceEffects(Predicate<T> search, T ... replaceWith) {
        ListIterator<T> itr = this.effects.listIterator();
        int replaced = 0;
        while (itr.hasNext()) {
            EffectPlayer value = (EffectPlayer)itr.next();
            if (!search.test(value)) continue;
            if (replaced < replaceWith.length) {
                itr.set(replaceWith[replaced]);
                ++replaced;
                continue;
            }
            itr.remove();
        }
        while (replaced < replaceWith.length) {
            itr.add(replaceWith[replaced]);
            ++replaced;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.effects.iterator();
    }

    public abstract void playEffects();
}

