/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.tdm;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.tdm.DatabaseGamePlayersTDM;
import com.ebicep.warlords.database.repositories.games.pojos.tdm.DatabaseGameTDM;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.DatabasePlayer;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.DatabaseBaseTDM;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.classes.DatabaseMageTDM;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.classes.DatabasePaladinTDM;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.classes.DatabaseRogueTDM;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.classes.DatabaseShamanTDM;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.classes.DatabaseWarriorTDM;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.Specializations;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabasePlayerTDM
extends AbstractDatabaseStatInformation
implements DatabasePlayer {
    @Field(value="total_time_played")
    private long totalTimePlayed = 0L;
    private DatabaseMageTDM mage = new DatabaseMageTDM();
    private DatabaseWarriorTDM warrior = new DatabaseWarriorTDM();
    private DatabasePaladinTDM paladin = new DatabasePaladinTDM();
    private DatabaseShamanTDM shaman = new DatabaseShamanTDM();
    private DatabaseRogueTDM rogue = new DatabaseRogueTDM();

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        assert (databaseGame instanceof DatabaseGameTDM);
        assert (gamePlayer instanceof DatabaseGamePlayersTDM.DatabaseGamePlayerTDM);
        this.experience += add ? gamePlayer.getExperienceEarnedUniversal() : -gamePlayer.getExperienceEarnedUniversal();
        this.totalTimePlayed += (long)(900 - ((DatabaseGameTDM)databaseGame).getTimeLeft());
        this.getClass(Specializations.getClass(gamePlayer.getSpec())).updateStats(databaseGame, gamePlayer, add);
        this.getSpec(gamePlayer.getSpec()).updateStats(databaseGame, gamePlayer, add);
    }

    @Override
    public DatabaseBaseTDM getSpec(Specializations specializations) {
        switch (specializations) {
            case PYROMANCER: {
                return this.mage.getPyromancer();
            }
            case CRYOMANCER: {
                return this.mage.getCryomancer();
            }
            case AQUAMANCER: {
                return this.mage.getAquamancer();
            }
            case BERSERKER: {
                return this.warrior.getBerserker();
            }
            case DEFENDER: {
                return this.warrior.getDefender();
            }
            case REVENANT: {
                return this.warrior.getRevenant();
            }
            case AVENGER: {
                return this.paladin.getAvenger();
            }
            case CRUSADER: {
                return this.paladin.getCrusader();
            }
            case PROTECTOR: {
                return this.paladin.getProtector();
            }
            case THUNDERLORD: {
                return this.shaman.getThunderlord();
            }
            case SPIRITGUARD: {
                return this.shaman.getSpiritguard();
            }
            case EARTHWARDEN: {
                return this.shaman.getEarthwarden();
            }
            case ASSASSIN: {
                return this.rogue.getAssassin();
            }
            case VINDICATOR: {
                return this.rogue.getVindicator();
            }
            case APOTHECARY: {
                return this.rogue.getApothecary();
            }
        }
        return null;
    }

    @Override
    public DatabaseBaseTDM getClass(Classes classes) {
        switch (classes) {
            case MAGE: {
                return this.mage;
            }
            case WARRIOR: {
                return this.warrior;
            }
            case PALADIN: {
                return this.paladin;
            }
            case SHAMAN: {
                return this.shaman;
            }
            case ROGUE: {
                return this.rogue;
            }
        }
        return null;
    }

    public DatabaseBaseTDM[] getClasses() {
        return new DatabaseBaseTDM[]{this.mage, this.warrior, this.paladin, this.shaman, this.rogue};
    }
}

