/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.interception;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.interception.DatabaseGameInterception;
import com.ebicep.warlords.database.repositories.games.pojos.interception.DatabaseGamePlayersInterception;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.DatabasePlayer;
import com.ebicep.warlords.database.repositories.player.pojos.interception.DatabaseBaseInterception;
import com.ebicep.warlords.database.repositories.player.pojos.interception.classes.DatabaseMageInterception;
import com.ebicep.warlords.database.repositories.player.pojos.interception.classes.DatabasePaladinInterception;
import com.ebicep.warlords.database.repositories.player.pojos.interception.classes.DatabaseRogueInterception;
import com.ebicep.warlords.database.repositories.player.pojos.interception.classes.DatabaseShamanInterception;
import com.ebicep.warlords.database.repositories.player.pojos.interception.classes.DatabaseWarriorInterception;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.Specializations;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabasePlayerInterception
extends AbstractDatabaseStatInformation
implements DatabasePlayer {
    @Field(value="points_captured")
    private int pointsCaptured;
    @Field(value="points_defended")
    private int pointsDefended;
    @Field(value="total_time_played")
    private long totalTimePlayed = 0L;
    private DatabaseMageInterception mage = new DatabaseMageInterception();
    private DatabaseWarriorInterception warrior = new DatabaseWarriorInterception();
    private DatabasePaladinInterception paladin = new DatabasePaladinInterception();
    private DatabaseShamanInterception shaman = new DatabaseShamanInterception();
    private DatabaseRogueInterception rogue = new DatabaseRogueInterception();

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        assert (databaseGame instanceof DatabaseGameInterception);
        assert (gamePlayer instanceof DatabaseGamePlayersInterception.DatabaseGamePlayerInterception);
        this.experience += add ? gamePlayer.getExperienceEarnedUniversal() : -gamePlayer.getExperienceEarnedUniversal();
        this.pointsCaptured += ((DatabaseGamePlayersInterception.DatabaseGamePlayerInterception)gamePlayer).getPointsCaptured();
        this.pointsDefended += ((DatabaseGamePlayersInterception.DatabaseGamePlayerInterception)gamePlayer).getPointsDefended();
        this.totalTimePlayed += (long)(900 - ((DatabaseGameInterception)databaseGame).getTimeLeft());
        this.getClass(Specializations.getClass(gamePlayer.getSpec())).updateStats(databaseGame, gamePlayer, add);
        this.getSpec(gamePlayer.getSpec()).updateStats(databaseGame, gamePlayer, add);
    }

    @Override
    public DatabaseBaseInterception getSpec(Specializations specializations) {
        switch (specializations) {
            case PYROMANCER: {
                return this.mage.getPyromancer();
            }
            case CRYOMANCER: {
                return this.mage.getCryomancer();
            }
            case AQUAMANCER: {
                return this.mage.getAquamancer();
            }
            case BERSERKER: {
                return this.warrior.getBerserker();
            }
            case DEFENDER: {
                return this.warrior.getDefender();
            }
            case REVENANT: {
                return this.warrior.getRevenant();
            }
            case AVENGER: {
                return this.paladin.getAvenger();
            }
            case CRUSADER: {
                return this.paladin.getCrusader();
            }
            case PROTECTOR: {
                return this.paladin.getProtector();
            }
            case THUNDERLORD: {
                return this.shaman.getThunderlord();
            }
            case SPIRITGUARD: {
                return this.shaman.getSpiritguard();
            }
            case EARTHWARDEN: {
                return this.shaman.getEarthwarden();
            }
            case ASSASSIN: {
                return this.rogue.getAssassin();
            }
            case VINDICATOR: {
                return this.rogue.getVindicator();
            }
            case APOTHECARY: {
                return this.rogue.getApothecary();
            }
        }
        return null;
    }

    @Override
    public DatabaseBaseInterception getClass(Classes classes) {
        switch (classes) {
            case MAGE: {
                return this.mage;
            }
            case WARRIOR: {
                return this.warrior;
            }
            case PALADIN: {
                return this.paladin;
            }
            case SHAMAN: {
                return this.shaman;
            }
            case ROGUE: {
                return this.rogue;
            }
        }
        return null;
    }

    public DatabaseBaseInterception[] getClasses() {
        return new DatabaseBaseInterception[]{this.mage, this.warrior, this.paladin, this.shaman, this.rogue};
    }
}

