/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.general;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.DatabasePlayer;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.DatabasePlayerCTF;
import com.ebicep.warlords.database.repositories.player.pojos.general.classescomppub.DatabaseMage;
import com.ebicep.warlords.database.repositories.player.pojos.general.classescomppub.DatabasePaladin;
import com.ebicep.warlords.database.repositories.player.pojos.general.classescomppub.DatabaseRogue;
import com.ebicep.warlords.database.repositories.player.pojos.general.classescomppub.DatabaseShaman;
import com.ebicep.warlords.database.repositories.player.pojos.general.classescomppub.DatabaseWarrior;
import com.ebicep.warlords.database.repositories.player.pojos.interception.DatabasePlayerInterception;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.DatabasePlayerTDM;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.Specializations;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabasePlayerCompStats
extends AbstractDatabaseStatInformation
implements DatabasePlayer {
    private DatabaseMage mage = new DatabaseMage();
    private DatabaseWarrior warrior = new DatabaseWarrior();
    private DatabasePaladin paladin = new DatabasePaladin();
    private DatabaseShaman shaman = new DatabaseShaman();
    private DatabaseRogue rogue = new DatabaseRogue();
    @Field(value="ctf_stats")
    private DatabasePlayerCTF ctfStats = new DatabasePlayerCTF();
    @Field(value="tdm_stats")
    private DatabasePlayerTDM tdmStats = new DatabasePlayerTDM();
    @Field(value="interception_stats")
    private DatabasePlayerInterception interceptionStats = new DatabasePlayerInterception();

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        this.experience += add ? gamePlayer.getExperienceEarnedUniversal() : -gamePlayer.getExperienceEarnedUniversal();
        this.getClass(Specializations.getClass(gamePlayer.getSpec())).updateStats(databaseGame, gamePlayer, add);
        this.getSpec(gamePlayer.getSpec()).updateStats(databaseGame, gamePlayer, add);
        switch (gameMode) {
            case CAPTURE_THE_FLAG: {
                this.ctfStats.updateStats(databaseGame, gamePlayer, add);
                break;
            }
            case TEAM_DEATHMATCH: {
                this.tdmStats.updateStats(databaseGame, gamePlayer, add);
                break;
            }
            case INTERCEPTION: {
                this.interceptionStats.updateStats(databaseGame, gamePlayer, add);
            }
        }
    }

    @Override
    public AbstractDatabaseStatInformation getSpec(Specializations specializations) {
        switch (specializations) {
            case PYROMANCER: {
                return this.mage.getPyromancer();
            }
            case CRYOMANCER: {
                return this.mage.getCryomancer();
            }
            case AQUAMANCER: {
                return this.mage.getAquamancer();
            }
            case BERSERKER: {
                return this.warrior.getBerserker();
            }
            case DEFENDER: {
                return this.warrior.getDefender();
            }
            case REVENANT: {
                return this.warrior.getRevenant();
            }
            case AVENGER: {
                return this.paladin.getAvenger();
            }
            case CRUSADER: {
                return this.paladin.getCrusader();
            }
            case PROTECTOR: {
                return this.paladin.getProtector();
            }
            case THUNDERLORD: {
                return this.shaman.getThunderlord();
            }
            case SPIRITGUARD: {
                return this.shaman.getSpiritguard();
            }
            case EARTHWARDEN: {
                return this.shaman.getEarthwarden();
            }
            case ASSASSIN: {
                return this.rogue.getAssassin();
            }
            case VINDICATOR: {
                return this.rogue.getVindicator();
            }
            case APOTHECARY: {
                return this.rogue.getApothecary();
            }
        }
        return null;
    }

    @Override
    public AbstractDatabaseStatInformation getClass(Classes classes) {
        switch (classes) {
            case MAGE: {
                return this.mage;
            }
            case WARRIOR: {
                return this.warrior;
            }
            case PALADIN: {
                return this.paladin;
            }
            case SHAMAN: {
                return this.shaman;
            }
            case ROGUE: {
                return this.rogue;
            }
        }
        return null;
    }

    @Override
    public AbstractDatabaseStatInformation[] getClasses() {
        return new AbstractDatabaseStatInformation[]{this.mage, this.warrior, this.paladin, this.shaman, this.rogue};
    }

    public DatabaseMage getMage() {
        return this.mage;
    }

    public void setMage(DatabaseMage mage) {
        this.mage = mage;
    }

    public DatabaseWarrior getWarrior() {
        return this.warrior;
    }

    public void setWarrior(DatabaseWarrior warrior) {
        this.warrior = warrior;
    }

    public DatabasePaladin getPaladin() {
        return this.paladin;
    }

    public void setPaladin(DatabasePaladin paladin) {
        this.paladin = paladin;
    }

    public DatabaseShaman getShaman() {
        return this.shaman;
    }

    public void setShaman(DatabaseShaman shaman) {
        this.shaman = shaman;
    }

    public DatabaseRogue getRogue() {
        return this.rogue;
    }

    public void setRogue(DatabaseRogue rogue) {
        this.rogue = rogue;
    }

    public DatabasePlayerCTF getCtfStats() {
        return this.ctfStats;
    }

    public void setCtfStats(DatabasePlayerCTF ctfStats) {
        this.ctfStats = ctfStats;
    }

    public DatabasePlayerTDM getTdmStats() {
        return this.tdmStats;
    }

    public void setTdmStats(DatabasePlayerTDM tdmStats) {
        this.tdmStats = tdmStats;
    }

    public DatabasePlayerInterception getInterceptionStats() {
        return this.interceptionStats;
    }

    public void setInterceptionStats(DatabasePlayerInterception interceptionStats) {
        this.interceptionStats = interceptionStats;
    }
}

