/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.general;

import com.ebicep.warlords.achievements.Achievement;
import com.ebicep.warlords.achievements.types.ChallengeAchievements;
import com.ebicep.warlords.achievements.types.TieredAchievements;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.DatabasePlayerCTF;
import com.ebicep.warlords.database.repositories.player.pojos.duel.DatabasePlayerDuel;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayerCompStats;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayerPubStats;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabaseSpecialization;
import com.ebicep.warlords.database.repositories.player.pojos.general.classes.DatabaseMage;
import com.ebicep.warlords.database.repositories.player.pojos.general.classes.DatabasePaladin;
import com.ebicep.warlords.database.repositories.player.pojos.general.classes.DatabaseRogue;
import com.ebicep.warlords.database.repositories.player.pojos.general.classes.DatabaseShaman;
import com.ebicep.warlords.database.repositories.player.pojos.general.classes.DatabaseWarrior;
import com.ebicep.warlords.database.repositories.player.pojos.interception.DatabasePlayerInterception;
import com.ebicep.warlords.database.repositories.player.pojos.tdm.DatabasePlayerTDM;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.Settings;
import com.ebicep.warlords.player.Specializations;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="Players_Information")
public class DatabasePlayer
extends AbstractDatabaseStatInformation
implements com.ebicep.warlords.database.repositories.player.pojos.DatabasePlayer {
    @Id
    private String id;
    @Indexed(unique=true)
    private String uuid = "";
    private String name = "";
    @Field(value="discord_id")
    private Long discordID = null;
    private DatabaseMage mage = new DatabaseMage();
    private DatabaseWarrior warrior = new DatabaseWarrior();
    private DatabasePaladin paladin = new DatabasePaladin();
    private DatabaseShaman shaman = new DatabaseShaman();
    private DatabaseRogue rogue = new DatabaseRogue();
    @Field(value="ctf_stats")
    private DatabasePlayerCTF ctfStats = new DatabasePlayerCTF();
    @Field(value="tdm_stats")
    private DatabasePlayerTDM tdmStats = new DatabasePlayerTDM();
    @Field(value="interception_stats")
    private DatabasePlayerInterception interceptionStats = new DatabasePlayerInterception();
    @Field(value="duel_stats")
    private DatabasePlayerDuel duelStats = new DatabasePlayerDuel();
    @Field(value="comp_stats")
    private DatabasePlayerCompStats compStats = new DatabasePlayerCompStats();
    @Field(value="public_queue_stats")
    private DatabasePlayerPubStats pubStats = new DatabasePlayerPubStats();
    @Field(value="last_spec")
    private Specializations lastSpec = Specializations.PYROMANCER;
    @Field(value="hotkeymode")
    private Settings.HotkeyMode hotkeyMode = Settings.HotkeyMode.NEW_MODE;
    @Field(value="particle_quality")
    private Settings.ParticleQuality particleQuality = Settings.ParticleQuality.HIGH;
    private List<Achievement.AbstractAchievementRecord> achievements = new ArrayList<Achievement.AbstractAchievementRecord>();

    public DatabasePlayer() {
    }

    public DatabasePlayer(String uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public DatabasePlayer(UUID uuid, String name) {
        this.uuid = uuid.toString();
        this.name = name;
    }

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        this.experience += add ? gamePlayer.getExperienceEarnedUniversal() : -gamePlayer.getExperienceEarnedUniversal();
        this.getClass(Specializations.getClass(gamePlayer.getSpec())).updateStats(databaseGame, gamePlayer, add);
        this.getSpec(gamePlayer.getSpec()).updateStats(databaseGame, gamePlayer, add);
        switch (gameMode) {
            case CAPTURE_THE_FLAG: {
                this.ctfStats.updateStats(databaseGame, gamePlayer, add);
                break;
            }
            case TEAM_DEATHMATCH: {
                this.tdmStats.updateStats(databaseGame, gamePlayer, add);
                break;
            }
            case INTERCEPTION: {
                this.interceptionStats.updateStats(databaseGame, gamePlayer, add);
            }
        }
        if (isCompGame) {
            this.compStats.updateStats(databaseGame, gamePlayer, add);
        } else {
            this.pubStats.updateStats(databaseGame, gamePlayer, add);
        }
    }

    @Override
    public DatabaseSpecialization getSpec(Specializations specializations) {
        switch (specializations) {
            case PYROMANCER: {
                return this.mage.getPyromancer();
            }
            case CRYOMANCER: {
                return this.mage.getCryomancer();
            }
            case AQUAMANCER: {
                return this.mage.getAquamancer();
            }
            case BERSERKER: {
                return this.warrior.getBerserker();
            }
            case DEFENDER: {
                return this.warrior.getDefender();
            }
            case REVENANT: {
                return this.warrior.getRevenant();
            }
            case AVENGER: {
                return this.paladin.getAvenger();
            }
            case CRUSADER: {
                return this.paladin.getCrusader();
            }
            case PROTECTOR: {
                return this.paladin.getProtector();
            }
            case THUNDERLORD: {
                return this.shaman.getThunderlord();
            }
            case SPIRITGUARD: {
                return this.shaman.getSpiritguard();
            }
            case EARTHWARDEN: {
                return this.shaman.getEarthwarden();
            }
            case ASSASSIN: {
                return this.rogue.getAssassin();
            }
            case VINDICATOR: {
                return this.rogue.getVindicator();
            }
            case APOTHECARY: {
                return this.rogue.getApothecary();
            }
        }
        return null;
    }

    @Override
    public AbstractDatabaseStatInformation getClass(Classes classes) {
        switch (classes) {
            case MAGE: {
                return this.mage;
            }
            case WARRIOR: {
                return this.warrior;
            }
            case PALADIN: {
                return this.paladin;
            }
            case SHAMAN: {
                return this.shaman;
            }
            case ROGUE: {
                return this.rogue;
            }
        }
        return null;
    }

    @Override
    public AbstractDatabaseStatInformation[] getClasses() {
        return new AbstractDatabaseStatInformation[]{this.mage, this.warrior, this.paladin, this.shaman, this.rogue};
    }

    public String toString() {
        return "DatabasePlayer{uuid='" + this.uuid + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Long getDiscordID() {
        return this.discordID;
    }

    public void setDiscordID(Long discordID) {
        this.discordID = discordID;
    }

    public DatabaseMage getMage() {
        return this.mage;
    }

    public void setMage(DatabaseMage mage) {
        this.mage = mage;
    }

    public DatabaseWarrior getWarrior() {
        return this.warrior;
    }

    public void setWarrior(DatabaseWarrior warrior) {
        this.warrior = warrior;
    }

    public DatabasePaladin getPaladin() {
        return this.paladin;
    }

    public void setPaladin(DatabasePaladin paladin) {
        this.paladin = paladin;
    }

    public DatabaseShaman getShaman() {
        return this.shaman;
    }

    public void setShaman(DatabaseShaman shaman) {
        this.shaman = shaman;
    }

    public DatabaseRogue getRogue() {
        return this.rogue;
    }

    public void setRogue(DatabaseRogue rogue) {
        this.rogue = rogue;
    }

    public DatabasePlayerCTF getCtfStats() {
        return this.ctfStats;
    }

    public void setCtfStats(DatabasePlayerCTF ctfStats) {
        this.ctfStats = ctfStats;
    }

    public DatabasePlayerTDM getTdmStats() {
        return this.tdmStats;
    }

    public void setTdmStats(DatabasePlayerTDM tdmStats) {
        this.tdmStats = tdmStats;
    }

    public DatabasePlayerInterception getInterceptionStats() {
        return this.interceptionStats;
    }

    public void setInterceptionStats(DatabasePlayerInterception interceptionStats) {
        this.interceptionStats = interceptionStats;
    }

    public DatabasePlayerDuel getDuelStats() {
        return this.duelStats;
    }

    public void setDuelStats(DatabasePlayerDuel duelStats) {
        this.duelStats = duelStats;
    }

    public DatabasePlayerCompStats getCompStats() {
        return this.compStats;
    }

    public void setCompStats(DatabasePlayerCompStats compStats) {
        this.compStats = compStats;
    }

    public DatabasePlayerPubStats getPubStats() {
        return this.pubStats;
    }

    public void setPubStats(DatabasePlayerPubStats pubStats) {
        this.pubStats = pubStats;
    }

    public Specializations getLastSpec() {
        return this.lastSpec;
    }

    public void setLastSpec(Specializations lastSpec) {
        this.lastSpec = lastSpec;
    }

    public Settings.HotkeyMode getHotkeyMode() {
        return this.hotkeyMode;
    }

    public void setHotkeyMode(Settings.HotkeyMode hotkeyMode) {
        this.hotkeyMode = hotkeyMode;
    }

    public Settings.ParticleQuality getParticleQuality() {
        return this.particleQuality;
    }

    public void setParticleQuality(Settings.ParticleQuality particleQuality) {
        this.particleQuality = particleQuality;
    }

    public void addAchievement(Achievement.AbstractAchievementRecord achievementRecord) {
        this.achievements.add(achievementRecord);
    }

    public void addAchievements(List<Achievement.AbstractAchievementRecord> achievements) {
        this.achievements.addAll(achievements);
    }

    public List<Achievement.AbstractAchievementRecord> getAchievements() {
        return this.achievements;
    }

    public boolean hasAchievement(TieredAchievements achievement) {
        return this.achievements.stream().anyMatch(achievementRecord -> achievementRecord instanceof TieredAchievements.TieredAchievementRecord && ((TieredAchievements.TieredAchievementRecord)achievementRecord).getAchievement() == achievement);
    }

    public boolean hasAchievement(ChallengeAchievements achievement) {
        return this.achievements.stream().anyMatch(achievementRecord -> achievementRecord instanceof ChallengeAchievements.ChallengeAchievementRecord && ((ChallengeAchievements.ChallengeAchievementRecord)achievementRecord).getAchievement() == achievement);
    }
}

