/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.duel;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.duel.DatabaseGameDuel;
import com.ebicep.warlords.database.repositories.games.pojos.duel.DatabaseGamePlayersDuel;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.DatabasePlayer;
import com.ebicep.warlords.database.repositories.player.pojos.duel.DatabaseBaseDuel;
import com.ebicep.warlords.database.repositories.player.pojos.duel.classes.DatabaseMageDuel;
import com.ebicep.warlords.database.repositories.player.pojos.duel.classes.DatabasePaladinDuel;
import com.ebicep.warlords.database.repositories.player.pojos.duel.classes.DatabaseRogueDuel;
import com.ebicep.warlords.database.repositories.player.pojos.duel.classes.DatabaseShamanDuel;
import com.ebicep.warlords.database.repositories.player.pojos.duel.classes.DatabaseWarriorDuel;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.Specializations;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabasePlayerDuel
extends AbstractDatabaseStatInformation
implements DatabasePlayer {
    @Field(value="total_time_played")
    private long totalTimePlayed = 0L;
    private DatabaseMageDuel mage = new DatabaseMageDuel();
    private DatabaseWarriorDuel warrior = new DatabaseWarriorDuel();
    private DatabasePaladinDuel paladin = new DatabasePaladinDuel();
    private DatabaseShamanDuel shaman = new DatabaseShamanDuel();
    private DatabaseRogueDuel rogue = new DatabaseRogueDuel();

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        assert (databaseGame instanceof DatabaseGameDuel);
        assert (gamePlayer instanceof DatabaseGamePlayersDuel.DatabaseGamePlayerDuel);
        this.experience += add ? gamePlayer.getExperienceEarnedUniversal() : -gamePlayer.getExperienceEarnedUniversal();
        this.totalTimePlayed += (long)(900 - ((DatabaseGameDuel)databaseGame).getTimeLeft());
        this.getClass(Specializations.getClass(gamePlayer.getSpec())).updateStats(databaseGame, gamePlayer, add);
        this.getSpec(gamePlayer.getSpec()).updateStats(databaseGame, gamePlayer, add);
    }

    @Override
    public DatabaseBaseDuel getSpec(Specializations specializations) {
        switch (specializations) {
            case PYROMANCER: {
                return this.mage.getPyromancer();
            }
            case CRYOMANCER: {
                return this.mage.getCryomancer();
            }
            case AQUAMANCER: {
                return this.mage.getAquamancer();
            }
            case BERSERKER: {
                return this.warrior.getBerserker();
            }
            case DEFENDER: {
                return this.warrior.getDefender();
            }
            case REVENANT: {
                return this.warrior.getRevenant();
            }
            case AVENGER: {
                return this.paladin.getAvenger();
            }
            case CRUSADER: {
                return this.paladin.getCrusader();
            }
            case PROTECTOR: {
                return this.paladin.getProtector();
            }
            case THUNDERLORD: {
                return this.shaman.getThunderlord();
            }
            case SPIRITGUARD: {
                return this.shaman.getSpiritguard();
            }
            case EARTHWARDEN: {
                return this.shaman.getEarthwarden();
            }
            case ASSASSIN: {
                return this.rogue.getAssassin();
            }
            case VINDICATOR: {
                return this.rogue.getVindicator();
            }
            case APOTHECARY: {
                return this.rogue.getApothecary();
            }
        }
        return null;
    }

    @Override
    public DatabaseBaseDuel getClass(Classes classes) {
        switch (classes) {
            case MAGE: {
                return this.mage;
            }
            case WARRIOR: {
                return this.warrior;
            }
            case PALADIN: {
                return this.paladin;
            }
            case SHAMAN: {
                return this.shaman;
            }
            case ROGUE: {
                return this.rogue;
            }
        }
        return null;
    }

    public DatabaseBaseDuel[] getClasses() {
        return new DatabaseBaseDuel[]{this.mage, this.warrior, this.paladin, this.shaman, this.rogue};
    }
}

